/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.common.listeners;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import sfiomn.legendarysurvivaloverhaul.LegendarySurvivalOverhaul;
import sfiomn.legendarysurvivaloverhaul.api.data.json.JsonTemperatureDimension;
import sfiomn.legendarysurvivaloverhaul.api.data.manager.ITemperatureDimensionManager;
import sfiomn.legendarysurvivaloverhaul.network.packets.SyncTemperatureDimensionsPacket;

public class TemperatureDimensionListener
extends SimpleJsonResourceReloadListener
implements ITemperatureDimensionManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final Map<ResourceLocation, JsonTemperatureDimension> TEMPERATURE_DIMENSIONS = new HashMap<ResourceLocation, JsonTemperatureDimension>();

    public TemperatureDimensionListener() {
        super(GSON, "legendarysurvivaloverhaul/temperature/dimensions");
    }

    protected void apply(@NotNull Map<ResourceLocation, JsonElement> resourceLocationJsonElementMap, @NotNull ResourceManager resourceManager, @NotNull ProfilerFiller profilerFiller) {
        TEMPERATURE_DIMENSIONS.clear();
        resourceLocationJsonElementMap.forEach((key, json) -> {
            try {
                DataResult parsedJson = JsonTemperatureDimension.CODEC.parse((DynamicOps)JsonOps.INSTANCE, json);
                JsonTemperatureDimension temperatureDimension = (JsonTemperatureDimension)parsedJson.getOrThrow(false, error -> LegendarySurvivalOverhaul.LOGGER.error("Failed parsing temperature dimension : {}", error));
                if (ModList.get().isLoaded(key.m_135827_())) {
                    TEMPERATURE_DIMENSIONS.put((ResourceLocation)key, temperatureDimension);
                }
            }
            catch (JsonParseException error2) {
                LegendarySurvivalOverhaul.LOGGER.error("Failed to parse temperature dimension json {}", key);
            }
        });
        LegendarySurvivalOverhaul.LOGGER.info("Loaded {} temperature dimensions", (Object)TEMPERATURE_DIMENSIONS.size());
    }

    public static void sendDataToClient(PacketDistributor.PacketTarget packetTarget) {
        SyncTemperatureDimensionsPacket.sendTo(packetTarget, TEMPERATURE_DIMENSIONS);
    }

    public static void acceptServerTemperatureDimensions(Map<ResourceLocation, JsonTemperatureDimension> temperatureDimensions) {
        TEMPERATURE_DIMENSIONS.clear();
        TEMPERATURE_DIMENSIONS.putAll(temperatureDimensions);
    }

    @Override
    public JsonTemperatureDimension get(ResourceLocation dimensionRegistryName) {
        return TEMPERATURE_DIMENSIONS.get(dimensionRegistryName);
    }
}

