/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.common.listeners;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import sfiomn.legendarysurvivaloverhaul.LegendarySurvivalOverhaul;
import sfiomn.legendarysurvivaloverhaul.api.data.json.JsonTemperatureBiomeOverride;
import sfiomn.legendarysurvivaloverhaul.api.data.manager.ITemperatureBiomeManager;
import sfiomn.legendarysurvivaloverhaul.network.packets.SyncTemperatureBiomesPacket;

public class TemperatureBiomeListener
extends SimpleJsonResourceReloadListener
implements ITemperatureBiomeManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final Map<ResourceLocation, JsonTemperatureBiomeOverride> TEMPERATURE_BIOMES = new HashMap<ResourceLocation, JsonTemperatureBiomeOverride>();

    public TemperatureBiomeListener() {
        super(GSON, "legendarysurvivaloverhaul/temperature/biomes");
    }

    protected void apply(@NotNull Map<ResourceLocation, JsonElement> resourceLocationJsonElementMap, @NotNull ResourceManager resourceManager, @NotNull ProfilerFiller profilerFiller) {
        TEMPERATURE_BIOMES.clear();
        resourceLocationJsonElementMap.forEach((key, json) -> {
            try {
                DataResult parsedJson = JsonTemperatureBiomeOverride.CODEC.parse((DynamicOps)JsonOps.INSTANCE, json);
                JsonTemperatureBiomeOverride temperatures = (JsonTemperatureBiomeOverride)parsedJson.getOrThrow(false, error -> LegendarySurvivalOverhaul.LOGGER.error("Failed parsing temperature biome : {}", error));
                if (ModList.get().isLoaded(key.m_135827_())) {
                    TEMPERATURE_BIOMES.put((ResourceLocation)key, temperatures);
                }
            }
            catch (JsonParseException error2) {
                LegendarySurvivalOverhaul.LOGGER.error("Failed to parse temperature biome json {}", key);
            }
        });
        LegendarySurvivalOverhaul.LOGGER.info("Loaded {} temperature biomes", (Object)TEMPERATURE_BIOMES.size());
    }

    public static void sendDataToClient(PacketDistributor.PacketTarget packetTarget) {
        SyncTemperatureBiomesPacket.sendTo(packetTarget, TEMPERATURE_BIOMES);
    }

    public static void acceptServerTemperatureBiomes(Map<ResourceLocation, JsonTemperatureBiomeOverride> temperatureBiomes) {
        TEMPERATURE_BIOMES.clear();
        TEMPERATURE_BIOMES.putAll(temperatureBiomes);
    }

    @Override
    public JsonTemperatureBiomeOverride get(ResourceLocation itemRegistryName) {
        return TEMPERATURE_BIOMES.get(itemRegistryName);
    }
}

