/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.common.listeners;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import sfiomn.legendarysurvivaloverhaul.LegendarySurvivalOverhaul;
import sfiomn.legendarysurvivaloverhaul.api.data.json.JsonBodyPartsDamageSource;
import sfiomn.legendarysurvivaloverhaul.api.data.manager.IBodyPartsDamageSourceManager;
import sfiomn.legendarysurvivaloverhaul.network.packets.SyncBodyPartsDamageSourcesPacket;

public class BodyPartsDamageSourceListener
extends SimpleJsonResourceReloadListener
implements IBodyPartsDamageSourceManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final Map<ResourceLocation, JsonBodyPartsDamageSource> DAMAGE_SOURCES = new HashMap<ResourceLocation, JsonBodyPartsDamageSource>();

    public BodyPartsDamageSourceListener() {
        super(GSON, "legendarysurvivaloverhaul/body_damage/damage_sources");
    }

    protected void apply(@NotNull Map<ResourceLocation, JsonElement> resourceLocationJsonElementMap, @NotNull ResourceManager resourceManager, @NotNull ProfilerFiller profilerFiller) {
        DAMAGE_SOURCES.clear();
        resourceLocationJsonElementMap.forEach((key, json) -> {
            try {
                DataResult parsedJson = JsonBodyPartsDamageSource.CODEC.parse((DynamicOps)JsonOps.INSTANCE, json);
                JsonBodyPartsDamageSource temperatures = (JsonBodyPartsDamageSource)parsedJson.getOrThrow(false, error -> LegendarySurvivalOverhaul.LOGGER.error("Failed parsing body parts damage source : {}", error));
                if (ModList.get().isLoaded(key.m_135827_())) {
                    DAMAGE_SOURCES.put((ResourceLocation)key, temperatures);
                }
            }
            catch (JsonParseException error2) {
                LegendarySurvivalOverhaul.LOGGER.error("Failed to parse body parts damage source json {}", key);
            }
        });
        LegendarySurvivalOverhaul.LOGGER.info("Loaded {} body parts damage sources", (Object)DAMAGE_SOURCES.size());
    }

    public static void sendDataToClient(PacketDistributor.PacketTarget packetTarget) {
        SyncBodyPartsDamageSourcesPacket.sendTo(packetTarget, DAMAGE_SOURCES);
    }

    public static void acceptServerDamageSources(Map<ResourceLocation, JsonBodyPartsDamageSource> damageSources) {
        DAMAGE_SOURCES.clear();
        DAMAGE_SOURCES.putAll(damageSources);
    }

    @Override
    public JsonBodyPartsDamageSource get(String damageSourceName) {
        for (Map.Entry<ResourceLocation, JsonBodyPartsDamageSource> entry : DAMAGE_SOURCES.entrySet()) {
            if (!entry.getKey().m_135815_().equals(damageSourceName)) continue;
            return entry.getValue();
        }
        return null;
    }
}

