/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.common.integration.eclipticseasons;

import com.teamtea.eclipticseasons.api.EclipticSeasonsApi;
import com.teamtea.eclipticseasons.api.constant.solar.SolarTerm;
import com.teamtea.eclipticseasons.api.util.EclipticUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import sfiomn.legendarysurvivaloverhaul.LegendarySurvivalOverhaul;
import sfiomn.legendarysurvivaloverhaul.api.temperature.ModifierBase;
import sfiomn.legendarysurvivaloverhaul.common.integration.eclipticseasons.EclipticSeasonsUtil;
import sfiomn.legendarysurvivaloverhaul.config.Config;

public class EclipticSeasonsModifier
extends ModifierBase {
    @Override
    public float getWorldInfluence(Player player, Level level, BlockPos pos) {
        if (!LegendarySurvivalOverhaul.eclipticSeasonsLoaded || !Config.Baked.eclipticSeasonsEnabled) {
            return 0.0f;
        }
        try {
            return this.getUncaughtWorldInfluence(level, pos);
        }
        catch (Exception e) {
            LegendarySurvivalOverhaul.LOGGER.error("An error has occurred with Ecliptic Seasons compatibility, disabling modifier", (Throwable)e);
            LegendarySurvivalOverhaul.eclipticSeasonsLoaded = false;
            return 0.0f;
        }
    }

    public float getUncaughtWorldInfluence(Level level, BlockPos pos) {
        if (!EclipticSeasonsUtil.hasDimensionSeason(level)) {
            return 0.0f;
        }
        SolarTerm solarTerm = EclipticSeasonsApi.getInstance().getSolarTerm(level);
        if (solarTerm == SolarTerm.NONE) {
            return 0.0f;
        }
        int timeInSubSeason = (int)((long)(EclipticUtil.getTimeInSolarTerm((Level)level) * 24000) + level.m_6106_().m_6792_());
        int ordinal = solarTerm.ordinal();
        float value = EclipticSeasonsUtil.getBlendedSeasonModifier(EclipticSeasonsUtil.getSeasonModifier(ordinal - 1), EclipticSeasonsUtil.getSeasonModifier(ordinal), EclipticSeasonsUtil.getSeasonModifier(ordinal + 1), timeInSubSeason, EclipticSeasonsUtil.getDaysInSolarTerm());
        double targetUndergroundTemperature = 0.0;
        return this.applyUndergroundEffect(value, level, pos, (float)targetUndergroundTemperature);
    }
}

