/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.common.events;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.level.storage.PrimaryLevelData;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.ItemAttributeModifierEvent;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.event.level.SleepFinishedTimeEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;
import sfiomn.legendarysurvivaloverhaul.LegendarySurvivalOverhaul;
import sfiomn.legendarysurvivaloverhaul.api.ModDamageTypes;
import sfiomn.legendarysurvivaloverhaul.api.bodydamage.BodyDamageUtil;
import sfiomn.legendarysurvivaloverhaul.api.bodydamage.BodyPartEnum;
import sfiomn.legendarysurvivaloverhaul.api.bodydamage.DamageDistributionEnum;
import sfiomn.legendarysurvivaloverhaul.api.data.json.JsonBodyPartResistance;
import sfiomn.legendarysurvivaloverhaul.api.data.json.JsonBodyPartsDamageSource;
import sfiomn.legendarysurvivaloverhaul.api.data.json.JsonTemperatureResistance;
import sfiomn.legendarysurvivaloverhaul.api.data.json.JsonThirstBlock;
import sfiomn.legendarysurvivaloverhaul.api.data.manager.BodyDamageDataManager;
import sfiomn.legendarysurvivaloverhaul.api.health.HealthUtil;
import sfiomn.legendarysurvivaloverhaul.api.temperature.AttributeModifierBase;
import sfiomn.legendarysurvivaloverhaul.api.temperature.TemperatureUtil;
import sfiomn.legendarysurvivaloverhaul.api.thirst.ThirstUtil;
import sfiomn.legendarysurvivaloverhaul.common.capabilities.health.HealthCapability;
import sfiomn.legendarysurvivaloverhaul.common.capabilities.thirst.ThirstCapability;
import sfiomn.legendarysurvivaloverhaul.common.integration.curios.CuriosUtil;
import sfiomn.legendarysurvivaloverhaul.common.integration.medsandherbs.MedsAndHerbsUtil;
import sfiomn.legendarysurvivaloverhaul.common.integration.supplementaries.SupplementariesUtil;
import sfiomn.legendarysurvivaloverhaul.common.items.heal.BodyHealingItem;
import sfiomn.legendarysurvivaloverhaul.common.listeners.BodyDamageHealingConsumableListener;
import sfiomn.legendarysurvivaloverhaul.common.listeners.BodyPartResistanceItemListener;
import sfiomn.legendarysurvivaloverhaul.common.listeners.BodyPartsDamageSourceListener;
import sfiomn.legendarysurvivaloverhaul.common.listeners.TemperatureBiomeListener;
import sfiomn.legendarysurvivaloverhaul.common.listeners.TemperatureBlockListener;
import sfiomn.legendarysurvivaloverhaul.common.listeners.TemperatureConsumableListener;
import sfiomn.legendarysurvivaloverhaul.common.listeners.TemperatureDimensionListener;
import sfiomn.legendarysurvivaloverhaul.common.listeners.TemperatureFuelItemListener;
import sfiomn.legendarysurvivaloverhaul.common.listeners.TemperatureItemListener;
import sfiomn.legendarysurvivaloverhaul.common.listeners.TemperatureMountListener;
import sfiomn.legendarysurvivaloverhaul.common.listeners.TemperatureOriginListener;
import sfiomn.legendarysurvivaloverhaul.common.listeners.ThirstBlockListener;
import sfiomn.legendarysurvivaloverhaul.common.listeners.ThirstConsumableListener;
import sfiomn.legendarysurvivaloverhaul.config.Config;
import sfiomn.legendarysurvivaloverhaul.registry.ItemRegistry;
import sfiomn.legendarysurvivaloverhaul.registry.MobEffectRegistry;
import sfiomn.legendarysurvivaloverhaul.registry.SoundRegistry;
import sfiomn.legendarysurvivaloverhaul.registry.TemperatureModifierRegistry;
import sfiomn.legendarysurvivaloverhaul.util.CapabilityUtil;
import sfiomn.legendarysurvivaloverhaul.util.ItemUtil;
import sfiomn.legendarysurvivaloverhaul.util.PlayerModelUtil;
import sfiomn.legendarysurvivaloverhaul.util.internal.BodyDamageUtilInternal;
import sfiomn.legendarysurvivaloverhaul.util.internal.TemperatureUtilInternal;

@Mod.EventBusSubscriber(modid="legendarysurvivaloverhaul", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CommonForgeEvents {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onItemUse(PlayerInteractEvent.RightClickItem event) {
        Player player;
        block6: {
            block5: {
                Player entity = event.getEntity();
                if (!(entity instanceof Player)) break block5;
                player = entity;
                if (event.getHand() == event.getEntity().m_7655_()) break block6;
            }
            return;
        }
        ItemStack usedItemStack = event.getItemStack();
        ResourceLocation itemRegistryName = ForgeRegistries.ITEMS.getKey((Object)usedItemStack.m_41720_());
        if (Config.Baked.localizedBodyDamageEnabled && LegendarySurvivalOverhaul.medsandherbsLoaded && itemRegistryName != null && itemRegistryName.m_135827_().equals("meds_and_herbs")) {
            if (itemRegistryName.equals((Object)new ResourceLocation("meds_and_herbs", "syringe_morphine")) && !MedsAndHerbsUtil.triggerMorphineBehavior(player)) {
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.CONSUME);
            }
            BodyDamageUtil.applyConsumableHealing(player, itemRegistryName);
        }
    }

    @SubscribeEvent
    public static void onFinishUseItem(LivingEntityUseItemEvent.Finish event) {
        ItemStack itemStackInBasket;
        LivingEntity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        ItemStack usedItemStack = event.getItem();
        if (LegendarySurvivalOverhaul.supplementariesLoaded && (itemStackInBasket = SupplementariesUtil.getSelectedItemInLunchBasket(event.getItem())) != ItemStack.f_41583_) {
            usedItemStack = itemStackInBasket;
        }
        ResourceLocation itemRegistryName = ForgeRegistries.ITEMS.getKey((Object)usedItemStack.m_41720_());
        if (!entity.m_9236_().f_46443_) {
            TemperatureUtil.applyConsumableTemperature(player, itemRegistryName);
        }
        if (!entity.m_9236_().f_46443_) {
            ThirstUtil.takeDrink(player, usedItemStack);
        }
        if (Config.Baked.localizedBodyDamageEnabled && !(usedItemStack.m_41720_() instanceof BodyHealingItem)) {
            BodyDamageUtil.applyConsumableHealing(player, itemRegistryName);
        }
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        Player player;
        ThirstCapability thirstCapability;
        if (CommonForgeEvents.shouldApplyThirst(event.getEntity()) && event.getHand() == InteractionHand.MAIN_HAND && event.getEntity().m_21205_().m_41619_() && !(thirstCapability = CapabilityUtil.getThirstCapability(player = event.getEntity())).isHydrationLevelAtMax()) {
            boolean hasMenu = event.getLevel().m_7702_(event.getHitVec().m_82425_()) instanceof MenuProvider;
            if (hasMenu) {
                return;
            }
            JsonThirstBlock jsonBlockThirst = ThirstUtil.getBlockThirstLookedAt(player, player.m_21133_((Attribute)ForgeMod.BLOCK_REACH.get()) / 2.0);
            JsonThirstBlock jsonFluidThirst = ThirstUtil.getFluidThirstLookedAt(player, player.m_21133_((Attribute)ForgeMod.BLOCK_REACH.get()) / 2.0);
            if (!(jsonBlockThirst == null || jsonBlockThirst.hydration == 0 && jsonBlockThirst.saturation == 0.0f || event.getEntity().m_6047_())) {
                if (event.getLevel().f_46443_) {
                    CommonForgeEvents.playerDrinkEffect(event.getEntity());
                } else {
                    ThirstUtil.takeDrink(event.getEntity(), jsonBlockThirst.hydration, jsonBlockThirst.saturation, jsonBlockThirst.effects);
                }
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.CONSUME);
                return;
            }
            if (jsonFluidThirst != null && (jsonFluidThirst.hydration != 0 || jsonFluidThirst.saturation != 0.0f)) {
                if (event.getLevel().f_46443_) {
                    CommonForgeEvents.playerDrinkEffect(event.getEntity());
                } else {
                    ThirstUtil.takeDrink(event.getEntity(), jsonFluidThirst.hydration, jsonFluidThirst.saturation, jsonFluidThirst.effects);
                }
                return;
            }
        }
        if (Config.Baked.temperatureEnabled && event.getHand() == InteractionHand.MAIN_HAND && !event.getLevel().m_5776_()) {
            player = event.getEntity();
            BlockState usedBlock = event.getLevel().m_8055_(event.getHitVec().m_82425_());
            if (player != null) {
                TemperatureUtil.applyConsumableBlockTemperature(player, usedBlock);
            }
        }
    }

    @SubscribeEvent
    public static void onAttributeModifier(ItemAttributeModifierEvent event) {
        if (!Config.Baked.temperatureEnabled) {
            return;
        }
        if (FMLEnvironment.dist == Dist.CLIENT && Minecraft.m_91087_().f_91073_ == null) {
            return;
        }
        if (ItemUtil.canBeEquippedInSlot(event.getItemStack(), event.getSlotType())) {
            if (Config.Baked.temperatureEnabled) {
                JsonTemperatureResistance config = new JsonTemperatureResistance();
                for (AttributeModifierBase attributeModifier : TemperatureModifierRegistry.ITEM_ATTRIBUTE_MODIFIERS_REGISTRY.get().getValues()) {
                    config.add(attributeModifier.getItemAttributes(event.getItemStack()));
                }
                UUID modifierUuid = TemperatureUtilInternal.equipmentSlotTemperatureUuid.get(event.getSlotType());
                if (config.temperature != 0.0f) {
                    TemperatureUtilInternal.HEATING_TEMPERATURE.addModifier(event, modifierUuid, (double)Math.max(config.temperature, 0.0f));
                    TemperatureUtilInternal.COOLING_TEMPERATURE.addModifier(event, modifierUuid, (double)Math.min(config.temperature, 0.0f));
                }
                if (config.heatResistance != 0.0f) {
                    TemperatureUtilInternal.HEAT_RESISTANCE.addModifier(event, modifierUuid, (double)config.heatResistance);
                }
                if (config.coldResistance != 0.0f) {
                    TemperatureUtilInternal.COLD_RESISTANCE.addModifier(event, modifierUuid, (double)config.coldResistance);
                }
                if (config.thermalResistance != 0.0f) {
                    TemperatureUtilInternal.THERMAL_RESISTANCE.addModifier(event, modifierUuid, (double)config.thermalResistance);
                }
            }
            if (Config.Baked.localizedBodyDamageEnabled) {
                ResourceLocation itemRegistryName = ForgeRegistries.ITEMS.getKey((Object)event.getItemStack().m_41720_());
                JsonBodyPartResistance config = BodyDamageDataManager.getBodyResistanceItem(itemRegistryName);
                if (itemRegistryName == null || config == null) {
                    return;
                }
                UUID modifierUuid = BodyDamageUtilInternal.equipmentSlotBodyResistanceUuid.get(event.getSlotType());
                if (config.bodyResistance != 0.0) {
                    BodyDamageUtilInternal.BODY_RESISTANCE.addModifier(event, modifierUuid, config.bodyResistance);
                }
                if (config.headResistance != 0.0) {
                    BodyDamageUtilInternal.HEAD_RESISTANCE.addModifier(event, modifierUuid, config.headResistance);
                }
                if (config.chestResistance != 0.0) {
                    BodyDamageUtilInternal.CHEST_RESISTANCE.addModifier(event, modifierUuid, config.chestResistance);
                }
                if (config.rightArmResistance != 0.0) {
                    BodyDamageUtilInternal.RIGHT_ARM_RESISTANCE.addModifier(event, modifierUuid, config.rightArmResistance);
                }
                if (config.leftArmResistance != 0.0) {
                    BodyDamageUtilInternal.LEFT_ARM_RESISTANCE.addModifier(event, modifierUuid, config.leftArmResistance);
                }
                if (config.legsResistance != 0.0) {
                    BodyDamageUtilInternal.LEGS_RESISTANCE.addModifier(event, modifierUuid, config.legsResistance);
                }
                if (config.feetResistance != 0.0) {
                    BodyDamageUtilInternal.FEET_RESISTANCE.addModifier(event, modifierUuid, config.feetResistance);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onJump(LivingEvent.LivingJumpEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity instanceof Player && CommonForgeEvents.shouldApplyThirst((Player)entity) && !entity.m_9236_().f_46443_) {
            ThirstUtil.addExhaustion((Player)entity, (float)Config.Baked.onJumpThirstExhaustion);
        }
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        Player player = event.getPlayer();
        if (CommonForgeEvents.shouldApplyThirst(player) && !player.m_9236_().f_46443_ && event.getState().m_60800_((BlockGetter)event.getLevel(), event.getPos()) > 0.0f) {
            ThirstUtil.addExhaustion(player, (float)Config.Baked.onBlockBreakThirstExhaustion);
        }
    }

    @SubscribeEvent
    public static void onAttackEntity(AttackEntityEvent event) {
        Entity monster;
        Player player = event.getEntity();
        if (CommonForgeEvents.shouldApplyThirst(player) && !player.m_9236_().f_46443_ && (monster = event.getTarget()).m_6097_()) {
            ThirstUtil.addExhaustion(player, (float)Config.Baked.onAttackThirstExhaustion);
            player.m_36399_((float)Config.Baked.onAttackFoodExhaustion);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onEntityHurt(LivingHurtEvent event) {
        if (!(event.getSource().m_276093_(DamageTypes.f_268671_) || event.getSource().m_276093_(DamageTypes.f_268441_) || event.getSource().m_276093_(DamageTypes.f_268444_) || event.getSource().m_276093_(DamageTypes.f_268722_) || event.getSource().m_276093_(ModDamageTypes.DEHYDRATION) || event.getSource().m_276093_(ModDamageTypes.HYPOTHERMIA) || event.getSource().m_276093_(ModDamageTypes.HYPERTHERMIA) || !event.getEntity().m_21023_((MobEffect)MobEffectRegistry.VULNERABILITY.get()))) {
            event.setAmount(event.getAmount() * (1.0f + 0.2f * (float)Objects.requireNonNull(event.getEntity().m_21124_((MobEffect)MobEffectRegistry.VULNERABILITY.get())).m_19564_() + 1.0f));
        } else if (event.getSource().m_276093_(DamageTypes.f_268671_) && event.getEntity().m_21023_((MobEffect)MobEffectRegistry.HARD_FALLING.get())) {
            event.setAmount(event.getAmount() * (1.0f + 0.2f * (float)Objects.requireNonNull(event.getEntity().m_21124_((MobEffect)MobEffectRegistry.HARD_FALLING.get())).m_19564_() + 1.0f));
            event.getEntity().m_9236_().m_6269_(null, (Entity)event.getEntity(), (SoundEvent)SoundRegistry.HARD_FALLING_HURT.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onEntityHurtDamage(LivingDamageEvent event) {
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getEntity();
        if (player.m_9236_().f_46443_) {
            return;
        }
        if (CommonForgeEvents.shouldApplyHealthOverhaul(player)) {
            event.setAmount(HealthUtil.hurtPlayer(player, event.getAmount()));
        }
        if (CommonForgeEvents.shouldApplyLocalizedBodyDamage(player)) {
            float bodyPartDamageValue = event.getAmount() * (float)Config.Baked.bodyDamageMultiplier;
            DamageSource source = event.getSource();
            JsonBodyPartsDamageSource damageSourceBodyParts = BodyDamageDataManager.getBodyParts(source.m_19385_());
            ArrayList<BodyPartEnum> hitBodyParts = new ArrayList<BodyPartEnum>();
            if (damageSourceBodyParts != null) {
                if (damageSourceBodyParts.damageDistribution != DamageDistributionEnum.NONE) {
                    hitBodyParts.addAll(damageSourceBodyParts.getBodyParts(player));
                }
            } else {
                List<BodyPartEnum> possibleHitParts;
                if (source.m_269533_(DamageTypeTags.f_268524_) && source.m_7640_() != null) {
                    hitBodyParts.addAll(PlayerModelUtil.getPreciseEntityImpact(source.m_7640_(), player));
                } else if (source.m_7640_() != null && !(possibleHitParts = PlayerModelUtil.getEntityImpact(source.m_7640_(), player)).isEmpty()) {
                    hitBodyParts.addAll(DamageDistributionEnum.ONE_OF.getBodyParts(player, possibleHitParts));
                }
                if (hitBodyParts.isEmpty()) {
                    hitBodyParts.addAll(DamageDistributionEnum.ONE_OF.getBodyParts(player, Arrays.asList(BodyPartEnum.values())));
                }
            }
            if (!hitBodyParts.isEmpty()) {
                BodyDamageUtil.balancedHurtBodyParts(player, hitBodyParts, bodyPartDamageValue);
            }
            if (source.m_269533_(DamageTypeTags.f_268524_) && hitBodyParts.contains((Object)BodyPartEnum.HEAD) && Config.Baked.headCriticalShotMultiplier > 1.0 && player.m_6844_(EquipmentSlot.HEAD).m_41619_()) {
                event.setAmount(event.getAmount() * (float)Config.Baked.headCriticalShotMultiplier);
                player.m_9236_().m_245747_(player.m_20183_(), (SoundEvent)SoundRegistry.HEADSHOT.get(), SoundSource.HOSTILE, 1.0f, 1.0f, false);
            }
        }
    }

    @SubscribeEvent
    public static void onSleepFinished(SleepFinishedTimeEvent event) {
        for (Player player : event.getLevel().m_6907_()) {
            if (!player.m_36317_()) continue;
            if (Config.Baked.localizedBodyDamageEnabled && Config.Baked.bodyHealthRatioRecoveredFromSleep > 0.0) {
                for (BodyPartEnum bodyPart : BodyPartEnum.values()) {
                    double healthRecovered = (double)BodyDamageUtil.getMaxHealth(player, bodyPart) * Config.Baked.bodyHealthRatioRecoveredFromSleep;
                    BodyDamageUtil.healBodyPart(player, bodyPart, (float)healthRecovered);
                }
                CapabilityUtil.getBodyDamageCapability(player).updateBrokenHearts(player);
                BodyDamageUtil.updatePlayerBrokenHeartAttribute(player);
            }
            if (!(Config.Baked.healthRatioRecoveredFromSleep > 0.0)) continue;
            HealthUtil.updatePlayerMaxHealthAttribute(player);
            double healthRecovered = (double)player.m_21233_() * Config.Baked.healthRatioRecoveredFromSleep;
            player.m_5634_((float)healthRecovered);
        }
    }

    @SubscribeEvent
    public static void onPlayerEffect(MobEffectEvent.Applicable event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (!event.getEntity().m_9236_().f_46443_) {
                if (Config.Baked.healthOverhaulEnabled && event.getEffectInstance().m_19544_() == MobEffects.f_19617_ && Config.Baked.absorptionEffectOverride) {
                    HealthCapability healthCapability = CapabilityUtil.getHealthCapability(player);
                    healthCapability.addShieldHealth(2.0f);
                    event.setResult(Event.Result.DENY);
                }
                if (event.getEffectInstance().m_19544_() == MobEffectRegistry.THIRST.get() && CuriosUtil.isCurioItemEquipped(player, (Item)ItemRegistry.WATER_PURIFIER.get())) {
                    event.setResult(Event.Result.DENY);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (event.isEndConquered()) {
            return;
        }
        if (Config.Baked.temperatureImmunityOnDeathEnabled && Config.Baked.temperatureEnabled) {
            event.getEntity().m_7292_(new MobEffectInstance((MobEffect)MobEffectRegistry.TEMPERATURE_IMMUNITY.get(), Config.Baked.temperatureImmunityOnDeathTime, 0, false, false, true));
        }
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (Config.Baked.temperatureImmunityOnFirstSpawnEnabled && Config.Baked.temperatureEnabled && !event.getEntity().getPersistentData().m_128471_("tempImmuneOnSpawn")) {
            event.getEntity().getPersistentData().m_128379_("tempImmuneOnSpawn", true);
            event.getEntity().m_7292_(new MobEffectInstance((MobEffect)MobEffectRegistry.TEMPERATURE_IMMUNITY.get(), Config.Baked.temperatureImmunityOnFirstSpawnTime, 0, false, false, true));
        }
        if (Config.Baked.healthOverhaulEnabled) {
            HealthUtil.initializeHealthAttributes(event.getEntity());
        }
        HealthUtil.updatePlayerMaxHealthAttribute(event.getEntity());
        BodyDamageUtil.updatePlayerBrokenHeartAttribute(event.getEntity());
    }

    @SubscribeEvent
    public static void onLevelLoad(LevelEvent.Load event) {
        LevelData levelData;
        if (!event.getLevel().m_5776_() && (levelData = event.getLevel().m_6106_()) instanceof PrimaryLevelData) {
            PrimaryLevelData primaryLevelData = (PrimaryLevelData)levelData;
            ((GameRules.BooleanValue)primaryLevelData.m_5470_().m_46170_(GameRules.f_46139_)).m_46246_(Config.Baked.naturalRegenerationEnabled, event.getLevel().m_7654_());
        }
    }

    @SubscribeEvent
    public static void onDataPackSyncEvent(OnDatapackSyncEvent event) {
        ServerPlayer player = event.getPlayer();
        PacketDistributor.PacketTarget target = player == null ? PacketDistributor.ALL.noArg() : PacketDistributor.PLAYER.with(() -> player);
        ThirstBlockListener.sendDataToClient(target);
        ThirstConsumableListener.sendDataToClient(target);
        TemperatureBiomeListener.sendDataToClient(target);
        TemperatureBlockListener.sendDataToClient(target);
        TemperatureConsumableListener.sendDataToClient(target);
        TemperatureDimensionListener.sendDataToClient(target);
        TemperatureFuelItemListener.sendDataToClient(target);
        TemperatureItemListener.sendDataToClient(target);
        TemperatureMountListener.sendDataToClient(target);
        TemperatureOriginListener.sendDataToClient(target);
        BodyDamageHealingConsumableListener.sendDataToClient(target);
        BodyPartsDamageSourceListener.sendDataToClient(target);
        BodyPartResistanceItemListener.sendDataToClient(target);
    }

    private static boolean shouldApplyThirst(Player player) {
        return !player.m_7500_() && !player.m_5833_() && Config.Baked.thirstEnabled && ThirstUtil.isThirstActive(player);
    }

    private static boolean shouldApplyLocalizedBodyDamage(Player player) {
        return !player.m_7500_() && !player.m_5833_() && Config.Baked.localizedBodyDamageEnabled;
    }

    private static boolean shouldApplyHealthOverhaul(Player player) {
        return !player.m_7500_() && !player.m_5833_() && Config.Baked.healthOverhaulEnabled;
    }

    public static void playerDrinkEffect(Player player) {
        player.m_6674_(InteractionHand.MAIN_HAND);
        player.m_5496_(SoundEvents.f_11911_, 1.0f, 1.0f);
    }
}

