/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.common.containers;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.ItemCombinerMenu;
import net.minecraft.world.inventory.ItemCombinerMenuSlotDefinition;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import sfiomn.legendarysurvivaloverhaul.api.temperature.TemperatureUtil;
import sfiomn.legendarysurvivaloverhaul.common.integration.mutantmonsters.MutantMonstersUtil;
import sfiomn.legendarysurvivaloverhaul.common.items.CoatItem;
import sfiomn.legendarysurvivaloverhaul.common.recipe.SewingRecipe;
import sfiomn.legendarysurvivaloverhaul.data.providers.ModAdvancementProvider;
import sfiomn.legendarysurvivaloverhaul.registry.BlockRegistry;
import sfiomn.legendarysurvivaloverhaul.registry.ContainerRegistry;
import sfiomn.legendarysurvivaloverhaul.registry.SoundRegistry;

public class SewingTableContainer
extends ItemCombinerMenu {
    public static final int INPUT_SLOT = 0;
    public static final int ADDITIONAL_SLOT = 1;
    public static final int RESULT_SLOT = 2;
    @Nullable
    private SewingRecipe selectedRecipe;

    public SewingTableContainer(int windowId, Inventory playerInventory, FriendlyByteBuf data) {
        this(windowId, playerInventory, ContainerLevelAccess.f_39287_);
    }

    public SewingTableContainer(int windowId, Inventory playerInventory, ContainerLevelAccess access) {
        super((MenuType)ContainerRegistry.SEWING_TABLE_CONTAINER.get(), windowId, playerInventory, access);
    }

    @NotNull
    protected ItemCombinerMenuSlotDefinition m_266183_() {
        return ItemCombinerMenuSlotDefinition.m_266303_().m_266197_(0, 18, 39, itemStack -> true).m_266197_(1, 65, 39, itemStack -> true).m_266198_(2, 134, 39).m_266441_();
    }

    public void m_6640_() {
        SimpleContainer simpleContainerInputSlots = new SimpleContainer(this.f_39769_.m_6643_());
        for (int i = 0; i < this.f_39769_.m_6643_(); ++i) {
            simpleContainerInputSlots.m_19173_(this.f_39769_.m_8020_(i));
        }
        List sewingRecipes = this.f_39771_.m_9236_().m_7465_().m_44056_((RecipeType)SewingRecipe.Type.INSTANCE, (Container)simpleContainerInputSlots, this.f_39771_.m_9236_());
        ItemStack itemStack = ItemStack.f_41583_;
        if (!SewingTableContainer.isItemArmor(this.f_39769_.m_8020_(0)) || !SewingTableContainer.isItemCoat(this.f_39769_.m_8020_(1))) {
            if (!sewingRecipes.isEmpty()) {
                this.selectedRecipe = (SewingRecipe)sewingRecipes.get(0);
                itemStack = this.selectedRecipe.assemble(simpleContainerInputSlots, this.f_39771_.m_9236_().m_9598_());
                this.f_39768_.m_6029_((Recipe)this.selectedRecipe);
            }
        } else if (!Objects.equals(TemperatureUtil.getArmorCoatTag(this.f_39769_.m_8020_(0)), ((CoatItem)this.f_39769_.m_8020_((int)1).m_41720_()).coat.id())) {
            if (!sewingRecipes.isEmpty()) {
                this.selectedRecipe = (SewingRecipe)sewingRecipes.get(0);
                itemStack = this.selectedRecipe.assemble(simpleContainerInputSlots, this.f_39771_.m_9236_().m_9598_());
                this.f_39768_.m_6029_((Recipe)this.selectedRecipe);
            } else {
                itemStack = this.f_39769_.m_8020_(0).m_41777_();
                CoatItem coatItem = (CoatItem)this.f_39769_.m_8020_(1).m_41720_();
                TemperatureUtil.setArmorCoatTag(itemStack, coatItem.coat.id());
                Player player = this.f_39771_;
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    Advancement sewCoatAdvancement = serverPlayer.f_8924_.m_129889_().m_136041_(new ResourceLocation(ModAdvancementProvider.SEW_A_COAT_ADVANCEMENT));
                    if (sewCoatAdvancement != null) {
                        for (String criteria : serverPlayer.m_8960_().m_135996_(sewCoatAdvancement).m_8219_()) {
                            serverPlayer.m_8960_().m_135988_(sewCoatAdvancement, criteria);
                        }
                    }
                }
            }
        }
        this.f_39768_.m_6836_(0, itemStack);
        this.m_38946_();
    }

    private void shrinkStackInSlot(int index) {
        this.f_39769_.m_7407_(index, 1);
    }

    protected boolean m_6560_(Player player, boolean b) {
        return true;
    }

    protected void m_142365_(Player player, ItemStack itemStack) {
        itemStack.m_41678_(player.m_9236_(), player, itemStack.m_41613_());
        this.f_39768_.m_58395_(player, Collections.singletonList(itemStack));
        this.shrinkStackInSlot(0);
        this.shrinkStackInSlot(1);
        this.f_39771_.m_9236_().m_247517_((Player)null, player.m_20183_(), (SoundEvent)SoundRegistry.SEWING_TABLE.get(), SoundSource.BLOCKS);
    }

    protected boolean m_8039_(BlockState blockState) {
        return blockState.m_60713_((Block)BlockRegistry.SEWING_TABLE.get());
    }

    public static boolean isItemArmor(ItemStack itemStack) {
        return itemStack.m_41720_() instanceof ArmorItem || MutantMonstersUtil.isMutantMonstersArmor(itemStack.m_41720_());
    }

    public static boolean isItemCoat(ItemStack itemStack) {
        return itemStack.m_41720_() instanceof CoatItem;
    }
}

