/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.common.capabilities.thirst;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import sfiomn.legendarysurvivaloverhaul.api.ModDamageTypes;
import sfiomn.legendarysurvivaloverhaul.api.thirst.IThirstCapability;
import sfiomn.legendarysurvivaloverhaul.config.Config;
import sfiomn.legendarysurvivaloverhaul.registry.MobEffectRegistry;
import sfiomn.legendarysurvivaloverhaul.util.DifficultyUtil;

public class ThirstCapability
implements IThirstCapability {
    public static int MAX_HYDRATION = 20;
    public static float MAX_SATURATION = 20.0f;
    private float exhaustion = 0.0f;
    private int thirst;
    private float thirstSaturation;
    private int thirstTickTimer;
    private int damageTickTimer;
    private int damageCounter;
    private int oldThirst;
    private float oldThirstSaturation;
    private boolean wasSprinting;
    private Vec3 oldPos;
    private boolean dirty;
    private int packetTimer;

    public ThirstCapability() {
        this.init();
    }

    public void init() {
        this.thirst = 20;
        this.thirstSaturation = 5.0f;
        this.thirstTickTimer = 0;
        this.damageCounter = 0;
        this.oldThirst = 0;
        this.oldThirstSaturation = 0.0f;
        this.wasSprinting = false;
        this.oldPos = null;
        this.dirty = false;
        this.damageTickTimer = 0;
        this.packetTimer = 0;
    }

    @Override
    public void tickUpdate(Player player, Level level, TickEvent.Phase phase) {
        if (this.getThirstTickTimer() == -1) {
            return;
        }
        if (phase == TickEvent.Phase.START) {
            ++this.packetTimer;
            return;
        }
        if (this.oldPos == null) {
            this.oldPos = player.m_20182_();
        }
        this.addThirstTickTimer(1);
        if (this.getThirstTickTimer() >= 10) {
            this.setThirstTickTimer(0);
            if (player.m_21023_((MobEffect)MobEffectRegistry.HYDRATION_FILL.get())) {
                if (this.getHydrationLevel() < MAX_HYDRATION) {
                    this.addHydrationLevel(1);
                }
                return;
            }
            if (this.oldPos.m_82554_(player.m_20182_()) > 1.0) {
                float thirstExhausted = player.m_20142_() && this.wasSprinting ? (float)Config.Baked.sprintingThirstExhaustion : (player.m_20142_() || this.wasSprinting ? (float)((Config.Baked.sprintingThirstExhaustion + Config.Baked.baseThirstExhaustion) / 2.0) : (float)Config.Baked.baseThirstExhaustion);
                this.addThirstExhaustion(thirstExhausted);
                this.oldPos = player.m_20182_();
                this.wasSprinting = player.m_20142_();
            }
        }
        if (this.getThirstExhaustion() > 4.0f) {
            this.addThirstExhaustion(-4.0f);
            if (this.getSaturationLevel() > 0.0f) {
                this.addSaturationLevel(-1.0f);
            } else if (DifficultyUtil.isModDangerous(level)) {
                this.addHydrationLevel(-1);
            }
        }
        if (this.getHydrationLevel() <= 0) {
            this.addThirstDamageTickTimer(1);
            if (this.getThirstDamageTickTimer() > 80) {
                this.setThirstDamageTickTimer(0);
                if (DifficultyUtil.isModDangerous(level) && DifficultyUtil.healthAboveDifficulty(level, player) && !player.m_5833_() && !player.m_7500_() && Config.Baked.dangerousDehydration) {
                    this.applyDangerousEffect(player);
                }
            }
        } else {
            this.setThirstDamageTickTimer(0);
            this.setThirstDamageCounter(0);
        }
    }

    private void applyDangerousEffect(Player player) {
        this.addThirstDamageCounter(1);
        float thirstDamageToApply = (float)((double)this.getThirstDamageCounter() * Config.Baked.dehydrationDamageScaling);
        ModDamageTypes.dehydration((Entity)player, thirstDamageToApply);
    }

    @Override
    public boolean isDirty() {
        return this.thirst != this.oldThirst || this.thirstSaturation != this.oldThirstSaturation || this.dirty;
    }

    @Override
    public void setClean() {
        this.oldThirst = this.thirst;
        this.oldThirstSaturation = this.thirstSaturation;
        this.dirty = false;
    }

    @Override
    public void setDirty() {
        this.dirty = true;
    }

    @Override
    public float getThirstExhaustion() {
        return this.exhaustion;
    }

    @Override
    public int getHydrationLevel() {
        return this.thirst;
    }

    @Override
    public float getSaturationLevel() {
        return this.thirstSaturation;
    }

    @Override
    public int getThirstTickTimer() {
        return this.thirstTickTimer;
    }

    @Override
    public int getThirstDamageTickTimer() {
        return this.damageTickTimer;
    }

    @Override
    public int getThirstDamageCounter() {
        return this.damageCounter;
    }

    @Override
    public void setThirstExhaustion(float exhaustion) {
        this.exhaustion = Math.max(exhaustion, 0.0f);
        if (!Float.isFinite(this.exhaustion)) {
            this.exhaustion = 0.0f;
        }
    }

    @Override
    public void setHydrationLevel(int thirst) {
        this.thirst = Mth.m_14045_((int)thirst, (int)0, (int)MAX_HYDRATION);
    }

    @Override
    public void setThirstSaturation(float saturation) {
        this.thirstSaturation = Mth.m_14036_((float)saturation, (float)0.0f, (float)MAX_SATURATION);
        if (!Float.isFinite(this.thirstSaturation)) {
            this.thirstSaturation = 0.0f;
        }
    }

    @Override
    public void setThirstTickTimer(int ticktimer) {
        this.thirstTickTimer = ticktimer;
    }

    @Override
    public void setThirstDamageTickTimer(int damageTickTimer) {
        this.damageTickTimer = damageTickTimer;
    }

    @Override
    public void setThirstDamageCounter(int damageCounter) {
        this.damageCounter = damageCounter;
    }

    @Override
    public void addThirstExhaustion(float exhaustion) {
        this.setThirstExhaustion(this.getThirstExhaustion() + exhaustion);
    }

    @Override
    public void addHydrationLevel(int thirst) {
        this.setHydrationLevel(this.getHydrationLevel() + thirst);
    }

    @Override
    public void addSaturationLevel(float saturation) {
        this.setThirstSaturation(Math.max((float)Math.round((this.getSaturationLevel() + saturation) * 100.0f) / 100.0f, 0.0f));
    }

    @Override
    public void addThirstTickTimer(int ticktimer) {
        this.setThirstTickTimer(this.getThirstTickTimer() + ticktimer);
    }

    @Override
    public void addThirstDamageTickTimer(int damageTickTimer) {
        this.setThirstDamageTickTimer(this.getThirstDamageTickTimer() + damageTickTimer);
    }

    @Override
    public void addThirstDamageCounter(int damageCounter) {
        this.setThirstDamageCounter(this.getThirstDamageCounter() + damageCounter);
    }

    @Override
    public boolean isHydrationLevelAtMax() {
        return this.getHydrationLevel() >= MAX_HYDRATION;
    }

    @Override
    public int getPacketTimer() {
        return this.packetTimer;
    }

    public CompoundTag writeNBT() {
        CompoundTag compound = new CompoundTag();
        compound.m_128350_("thirstExhaustion", this.getThirstExhaustion());
        compound.m_128405_("thirstLevel", this.getHydrationLevel());
        compound.m_128350_("thirstSaturation", this.getSaturationLevel());
        compound.m_128405_("thirstTickTimer", this.getThirstTickTimer());
        compound.m_128405_("thirstDamageTickTimer", this.getThirstDamageTickTimer());
        compound.m_128405_("thirstDamageCounter", this.getThirstDamageCounter());
        return compound;
    }

    public void readNBT(CompoundTag nbt) {
        this.init();
        if (nbt.m_128441_("thirstExhaustion")) {
            this.setThirstExhaustion(nbt.m_128457_("thirstExhaustion"));
        }
        if (nbt.m_128441_("thirstLevel")) {
            this.setHydrationLevel(nbt.m_128451_("thirstLevel"));
        }
        if (nbt.m_128441_("thirstSaturation")) {
            this.setThirstSaturation(nbt.m_128457_("thirstSaturation"));
        }
        if (nbt.m_128441_("thirstTickTimer")) {
            this.setThirstTickTimer(nbt.m_128451_("thirstTickTimer"));
        }
        if (nbt.m_128441_("thirstDamageTickTimer")) {
            this.setThirstDamageTickTimer(nbt.m_128451_("thirstDamageTickTimer"));
        }
        if (nbt.m_128441_("thirstDamageCounter")) {
            this.setThirstDamageCounter(nbt.m_128451_("thirstDamageCounter"));
        }
    }
}

