/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.common.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;
import net.minecraftforge.common.Tags;
import org.jetbrains.annotations.NotNull;
import sfiomn.legendarysurvivaloverhaul.registry.ItemRegistry;

public class WaterPlantBlock
extends CropBlock
implements IPlantable {
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.f_61401_;
    public static final int MAX_AGE = 7;
    public static final IntegerProperty AGE = BlockStateProperties.f_61409_;
    private static final VoxelShape[] SHAPE_BY_AGE = new VoxelShape[]{Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)6.0, (double)12.0), Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)9.0, (double)14.0), Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)13.0, (double)14.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)7.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)7.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)11.0, (double)16.0)};
    public static final BlockBehaviour.Properties properties = WaterPlantBlock.getProperties();

    public WaterPlantBlock() {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER));
    }

    public static BlockBehaviour.Properties getProperties() {
        return BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283915_).m_60977_().m_60955_().m_60910_().m_60966_().m_60918_(SoundType.f_56758_).m_278166_(PushReaction.DESTROY);
    }

    public void m_213898_(@NotNull BlockState state, ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        if (!level.isAreaLoaded(pos, 1)) {
            return;
        }
        if (level.m_45524_(pos, 0) >= 9 && !this.isUpperBlock(state)) {
            float f;
            int age = this.m_52305_(state);
            if (this.canGrow((Level)level, state, pos) && ForgeHooks.onCropsGrowPre((Level)level, (BlockPos)pos, (BlockState)state, (random.m_188503_((int)(25.0f / (f = WaterPlantBlock.m_52272_((Block)this, (BlockGetter)level, (BlockPos)pos))) + 1) == 0 ? 1 : 0) != 0)) {
                level.m_7731_(pos, this.m_52289_(age + 1), 2);
                if (this.m_52305_(state) > this.m_7419_() / 2) {
                    level.m_7731_(pos.m_7494_(), (BlockState)this.m_52289_(age + 1).m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER), 2);
                }
                ForgeHooks.onCropsGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
            }
        }
    }

    public void m_52263_(Level level, BlockPos pos, BlockState state) {
        int age = this.m_52305_(state);
        if (this.canGrow(level, state, pos)) {
            BlockPos basePos = pos;
            if (this.isUpperBlock(state)) {
                basePos = pos.m_7495_();
            }
            age = Math.min(age + this.m_7125_(level), this.m_7419_());
            level.m_7731_(basePos, this.m_52289_(age), 2);
            if (age > this.m_7419_() / 2) {
                level.m_7731_(basePos.m_7494_(), (BlockState)this.m_52289_(age).m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER), 2);
            }
        }
    }

    public boolean isUpperBlock(BlockState state) {
        return state.m_61143_(HALF) == DoubleBlockHalf.UPPER;
    }

    public boolean canGrow(Level level, BlockState state, BlockPos pos) {
        if (this.isUpperBlock(state) || level.m_46859_(pos.m_7494_()) || level.m_8055_(pos.m_7494_()).m_60713_((Block)this)) {
            return this.m_52305_(state) < this.m_7419_();
        }
        return this.m_52305_(state) < this.m_7419_() / 2;
    }

    @NotNull
    protected ItemLike m_6404_() {
        return (ItemLike)ItemRegistry.WATER_PLANT_SEEDS.get();
    }

    @NotNull
    public IntegerProperty m_7959_() {
        return AGE;
    }

    public int m_7419_() {
        return 7;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AGE}).m_61104_(new Property[]{HALF});
    }

    public boolean m_7898_(@NotNull BlockState state, @NotNull LevelReader level, @NotNull BlockPos pos) {
        if (state.m_60734_() == this && this.isUpperBlock(state)) {
            BlockState stateBelow = level.m_8055_(pos.m_7495_());
            return (level.m_45524_(pos, 0) >= 8 || level.m_45527_(pos)) && stateBelow.m_60734_() == this && this.m_52305_(stateBelow) > this.m_7419_() / 2;
        }
        return super.m_7898_(state, level, pos);
    }

    protected boolean m_6266_(BlockState blockState, BlockGetter blockReader, BlockPos blockPos) {
        return blockState.m_204336_(Tags.Blocks.SAND);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        Vec3 vector3d = state.m_60824_(reader, pos);
        if (state.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
            return SHAPE_BY_AGE[Math.min(this.m_52305_(state), 3)].m_83216_(vector3d.f_82479_, vector3d.f_82480_, vector3d.f_82481_);
        }
        return SHAPE_BY_AGE[this.m_52305_(state)].m_83216_(vector3d.f_82479_, vector3d.f_82480_, vector3d.f_82481_);
    }

    public PlantType getPlantType(BlockGetter world, BlockPos pos) {
        return PlantType.DESERT;
    }

    public BlockState getPlant(BlockGetter world, BlockPos pos) {
        return this.m_49966_();
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        if (!level.f_46443_) {
            if (this.isUpperBlock(state)) {
                if (level.m_8055_(pos.m_7495_()).m_60713_((Block)this)) {
                    level.m_7471_(pos.m_7495_(), false);
                }
            } else if (level.m_8055_(pos.m_7494_()).m_60713_((Block)this)) {
                level.m_7471_(pos.m_7494_(), false);
            }
            if (player.m_7500_()) {
                level.m_7471_(pos, false);
            }
        }
        super.m_5707_(level, pos, state, player);
    }

    protected int m_7125_(Level pLevel) {
        return Mth.m_216271_((RandomSource)pLevel.f_46441_, (int)1, (int)2);
    }

    public boolean m_7370_(@NotNull LevelReader level, @NotNull BlockPos pos, @NotNull BlockState state, boolean isClient) {
        if (this.canGrow((Level)level, state, pos)) {
            return state.m_60734_() == this;
        }
        return false;
    }
}

