/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.client.tooltips;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import sfiomn.legendarysurvivaloverhaul.config.Config;

public class HydrationClientTooltipComponent
implements ClientTooltipComponent {
    public static final ResourceLocation ICONS = new ResourceLocation("legendarysurvivaloverhaul", "textures/gui/overlay.png");
    public static final int THIRST_TEXTURE_WIDTH = 9;
    public static final int THIRST_TEXTURE_HEIGHT = 9;
    public final int hydration;
    public final float saturation;
    public int hydrationIconNumber;
    public int saturationIconNumber;

    public HydrationClientTooltipComponent(int hydration, float saturation) {
        this.hydration = hydration;
        this.saturation = saturation;
        this.hydrationIconNumber = Math.min((int)Math.ceil((float)Math.abs(hydration) / 2.0f), 10);
        this.saturationIconNumber = Config.Baked.thirstSaturationDisplayed ? Math.min((int)Math.ceil(Math.abs(saturation) / 2.0f), 10) : 0;
    }

    public int m_142103_() {
        int height = 14;
        if (this.saturationIconNumber > 0 && Config.Baked.thirstSaturationDisplayed && this.hydrationIconNumber > 0 && !Config.Baked.mergeHydrationAndSaturationTooltip) {
            height += 10;
        }
        return height;
    }

    public int m_142069_(Font font) {
        return Math.max(this.hydrationIconNumber, this.saturationIconNumber) * 9;
    }

    public void m_183452_(Font font, int tooltipX, int tooltipY, GuiGraphics gui) {
        int y;
        int x;
        int halfIcon;
        int i;
        RenderSystem.disableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172749_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int leftMax = 0;
        leftMax = Math.max(tooltipX + (this.hydrationIconNumber - 1) * 9, tooltipX + (this.saturationIconNumber - 1) * 9);
        int left = 0;
        left = !Config.Baked.mergeHydrationAndSaturationTooltip ? tooltipX + (this.hydrationIconNumber - 1) * 9 : leftMax;
        int top = tooltipY + 2;
        int xOffsetTexture = 0;
        xOffsetTexture = this.hydration >= 0 ? 9 : 36;
        for (i = 0; i < this.hydrationIconNumber; ++i) {
            halfIcon = i * 2 + 1;
            x = left - i * 9;
            y = top;
            if (halfIcon < Math.abs(this.hydration)) {
                gui.m_280163_(ICONS, x, y, (float)xOffsetTexture, 0.0f, 9, 9, 256, 256);
                continue;
            }
            if (halfIcon != Math.abs(this.hydration)) continue;
            gui.m_280163_(ICONS, x, y, (float)(xOffsetTexture + 9), 0.0f, 9, 9, 256, 256);
        }
        if (this.saturationIconNumber > 0 && Config.Baked.thirstSaturationDisplayed) {
            if (this.hydrationIconNumber > 0 && !Config.Baked.mergeHydrationAndSaturationTooltip) {
                top += 10;
            }
            left = !Config.Baked.mergeHydrationAndSaturationTooltip ? tooltipX + (this.saturationIconNumber - 1) * 9 : leftMax;
        }
        xOffsetTexture = this.saturation >= 0.0f ? 54 : 126;
        for (i = 0; i < this.saturationIconNumber; ++i) {
            halfIcon = i * 2 + 1;
            x = left - i * 9;
            y = top;
            if (halfIcon < (int)Math.ceil(Math.abs(this.saturation))) {
                gui.m_280163_(ICONS, x, y, (float)xOffsetTexture, 0.0f, 9, 9, 256, 256);
                continue;
            }
            if (halfIcon != (int)Math.ceil(Math.abs(this.saturation))) continue;
            gui.m_280163_(ICONS, x, y, (float)(xOffsetTexture + 9), 0.0f, 9, 9, 256, 256);
        }
        RenderSystem.disableBlend();
        RenderSystem.disableDepthTest();
    }
}

