/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.client.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import sfiomn.legendarysurvivaloverhaul.api.bodydamage.BodyDamageUtil;
import sfiomn.legendarysurvivaloverhaul.api.bodydamage.BodyPartEnum;
import sfiomn.legendarysurvivaloverhaul.client.screens.BodyPartButton;
import sfiomn.legendarysurvivaloverhaul.network.packets.BodyPartHealingTimeMessage;
import sfiomn.legendarysurvivaloverhaul.registry.KeyMappingRegistry;
import sfiomn.legendarysurvivaloverhaul.util.MathUtil;

public class BodyHealthScreen
extends Screen {
    public static final ResourceLocation BODY_HEALTH_SCREEN = new ResourceLocation("legendarysurvivaloverhaul", "textures/gui/body_health_screen.png");
    public static final int HEALTH_SCREEN_WIDTH = 176;
    public static final int HEALTH_SCREEN_HEIGHT = 183;
    public static final int HEALTH_BAR_WIDTH = 30;
    public static final int HEALTH_BAR_HEIGHT = 5;
    public static final int TEX_HEALTH_BAR_X = 176;
    public static final int TEX_HEALTH_BAR_Y = 0;
    private final Map<BodyPartEnum, BodyPartButton> bodyPartButtons = new HashMap<BodyPartEnum, BodyPartButton>();
    private int leftPos;
    private int topPos;
    private final Player player;
    private final InteractionHand hand;
    private int healingCharges;
    private final float healingValue;
    private final int healingTime;
    private boolean consumeItem;

    public BodyHealthScreen(Player player, InteractionHand hand, boolean alreadyConsumed, int healingCharges, float healingValue, int healingTime) {
        super((Component)Component.m_237115_((String)"screen.legendarysurvivaloverhaul.body_health_screen"));
        this.player = player;
        this.hand = hand;
        this.healingCharges = healingCharges;
        this.healingValue = healingValue;
        this.healingTime = healingTime;
        this.consumeItem = !alreadyConsumed;
    }

    protected void m_7856_() {
        super.m_7856_();
        assert (this.f_96541_ != null);
        this.leftPos = (this.f_96543_ - 176) / 2;
        this.topPos = (this.f_96544_ - 183) / 2;
        this.m_7787_((GuiEventListener)new BodyPartButton(BodyPartEnum.HEAD, this.leftPos + 68, this.topPos + 46, 38, 34, button -> this.sendBodyPartHeal(BodyPartEnum.HEAD)));
        this.m_7787_((GuiEventListener)new BodyPartButton(BodyPartEnum.RIGHT_ARM, this.leftPos + 101, this.topPos + 79, 50, 38, button -> this.sendBodyPartHeal(BodyPartEnum.RIGHT_ARM)));
        this.m_7787_((GuiEventListener)new BodyPartButton(BodyPartEnum.LEFT_ARM, this.leftPos + 23, this.topPos + 79, 50, 38, button -> this.sendBodyPartHeal(BodyPartEnum.LEFT_ARM)));
        this.m_7787_((GuiEventListener)new BodyPartButton(BodyPartEnum.CHEST, this.leftPos + 73, this.topPos + 79, 28, 38, button -> this.sendBodyPartHeal(BodyPartEnum.CHEST)));
        this.m_7787_((GuiEventListener)new BodyPartButton(BodyPartEnum.RIGHT_LEG, this.leftPos + 87, this.topPos + 117, 49, 36, button -> this.sendBodyPartHeal(BodyPartEnum.RIGHT_LEG)));
        this.m_7787_((GuiEventListener)new BodyPartButton(BodyPartEnum.RIGHT_FOOT, this.leftPos + 87, this.topPos + 153, 49, 10, button -> this.sendBodyPartHeal(BodyPartEnum.RIGHT_FOOT)));
        this.m_7787_((GuiEventListener)new BodyPartButton(BodyPartEnum.LEFT_LEG, this.leftPos + 38, this.topPos + 117, 49, 36, button -> this.sendBodyPartHeal(BodyPartEnum.LEFT_LEG)));
        this.m_7787_((GuiEventListener)new BodyPartButton(BodyPartEnum.LEFT_FOOT, this.leftPos + 38, this.topPos + 153, 49, 10, button -> this.sendBodyPartHeal(BodyPartEnum.LEFT_FOOT)));
        this.bodyPartButtons.clear();
        for (GuiEventListener button2 : this.m_6702_()) {
            if (!(button2 instanceof BodyPartButton)) continue;
            BodyPartButton bodyPartButton = (BodyPartButton)button2;
            if (this.hand == null) {
                bodyPartButton.f_93623_ = false;
            }
            this.bodyPartButtons.put(bodyPartButton.bodyPart, bodyPartButton);
        }
    }

    public void sendBodyPartHeal(BodyPartEnum bodyPart) {
        if (this.healingCharges > 0) {
            BodyPartHealingTimeMessage.sendToServer(bodyPart, this.hand, this.consumeItem, this.healingValue, this.healingTime);
            BodyDamageUtil.applyHealingTimeBodyPart(this.player, bodyPart, this.healingValue, this.healingTime);
            if (this.consumeItem) {
                this.consumeItem = false;
            }
            --this.healingCharges;
        }
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
            if (this.f_96541_.f_91066_.f_92092_.m_90832_(keyCode, scanCode)) {
                this.f_96541_.m_91152_((Screen)new InventoryScreen((Player)this.f_96541_.f_91074_));
                return true;
            }
            if (KeyMappingRegistry.showBodyHealth.m_90832_(keyCode, scanCode)) {
                this.m_7379_();
                return true;
            }
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_7043_() {
        return false;
    }

    public boolean m_6913_() {
        return true;
    }

    public void m_88315_(@NotNull GuiGraphics gui, int mouseX, int mouseY, float partialTicks) {
        this.checkAutoCloseWhenHealing();
        this.m_280273_(gui);
        for (BodyPartEnum bodyPart : BodyPartEnum.values()) {
            this.renderBodyPartHealth(gui, bodyPart, mouseX, mouseY, partialTicks);
        }
        super.m_88315_(gui, mouseX, mouseY, partialTicks);
    }

    public void checkAutoCloseWhenHealing() {
        if (this.hand != null && this.healingCharges == 0) {
            assert (this.f_96541_ != null);
            this.f_96541_.m_91152_(null);
        }
    }

    public void m_280273_(@NotNull GuiGraphics gui) {
        if (this.f_96541_ == null) {
            return;
        }
        super.m_280273_(gui);
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        gui.m_280218_(BODY_HEALTH_SCREEN, this.leftPos, this.topPos, 0, 0, 176, 183);
    }

    private void renderBodyPartHealth(GuiGraphics gui, BodyPartEnum bodyPart, int mouseX, int mouseY, float partialTicks) {
        if (this.f_96541_ == null) {
            return;
        }
        float healthRatio = BodyDamageUtil.getHealthRatio(this.player, bodyPart);
        float totalRemainingHealing = BodyDamageUtil.getTotalRemainingHealing(this.player, bodyPart);
        float maxHealth = BodyDamageUtil.getMaxHealth(this.player, bodyPart);
        BodyPartButton bodyPartButton = this.bodyPartButtons.get((Object)bodyPart);
        bodyPartButton.setHealthRatio(healthRatio);
        if (healthRatio >= 1.0f || bodyPartButton.isPressed || this.hand == null) {
            if (bodyPartButton.f_93623_) {
                bodyPartButton.f_93623_ = false;
            }
            if (totalRemainingHealing > 0.0f) {
                bodyPartButton.isPressed = false;
            }
        } else if (!bodyPartButton.f_93623_) {
            bodyPartButton.f_93623_ = true;
        }
        bodyPartButton.m_88315_(gui, mouseX, mouseY, partialTicks);
        if (bodyPartButton.m_5953_(mouseX, mouseY) && this.hand != null) {
            totalRemainingHealing += this.healingValue;
        }
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.drawHealthBar(gui, bodyPart, healthRatio, MathUtil.round(totalRemainingHealing / maxHealth, 2));
    }

    private void drawHealthBar(GuiGraphics gui, BodyPartEnum bodyPart, float healthRatio, float totalRemainingHealingRatio) {
        HealthBarIcon healthBarIcon = HealthBarIcon.get(bodyPart);
        HealthBarCondition healthBarCondition = HealthBarCondition.get(healthRatio);
        if (healthBarIcon == null) {
            return;
        }
        gui.m_280218_(BODY_HEALTH_SCREEN, this.leftPos + healthBarIcon.x, this.topPos + healthBarIcon.y, 176 + 30 * HealthBarCondition.DEAD.iconIndexX, 0 + 5 * HealthBarCondition.DEAD.iconIndexY, 30, 5);
        int healthBarWidth = (int)Math.ceil(30.0f * healthRatio);
        int healthBarPreviewWidth = (int)Math.min(Math.ceil(30.0f * totalRemainingHealingRatio), (double)(30 - healthBarWidth));
        if (healthBarWidth > 0) {
            gui.m_280218_(BODY_HEALTH_SCREEN, this.leftPos + healthBarIcon.x, this.topPos + healthBarIcon.y, 176 + 30 * healthBarCondition.iconIndexX, 0 + 5 * healthBarCondition.iconIndexY, healthBarWidth, 5);
        }
        if (healthBarPreviewWidth > 0) {
            gui.m_280218_(BODY_HEALTH_SCREEN, this.leftPos + healthBarIcon.x + healthBarWidth, this.topPos + healthBarIcon.y, 176 + healthBarWidth + 30 * healthBarCondition.getPreviewVariant().iconIndexX, 0 + 5 * healthBarCondition.getPreviewVariant().iconIndexY, healthBarPreviewWidth, 5);
        }
    }

    private static enum HealthBarIcon {
        HEAD(72, 46),
        RIGHT_ARM(118, 80),
        LEFT_ARM(27, 80),
        CHEST(72, 92),
        RIGHT_LEG(106, 134),
        LEFT_LEG(39, 134),
        RIGHT_FOOT(106, 156),
        LEFT_FOOT(39, 156);

        public final int x;
        public final int y;

        private HealthBarIcon(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public static HealthBarIcon get(BodyPartEnum bodyPart) {
            return switch (bodyPart) {
                case BodyPartEnum.HEAD -> HEAD;
                case BodyPartEnum.RIGHT_ARM -> RIGHT_ARM;
                case BodyPartEnum.LEFT_ARM -> LEFT_ARM;
                case BodyPartEnum.CHEST -> CHEST;
                case BodyPartEnum.RIGHT_LEG -> RIGHT_LEG;
                case BodyPartEnum.RIGHT_FOOT -> RIGHT_FOOT;
                case BodyPartEnum.LEFT_LEG -> LEFT_LEG;
                case BodyPartEnum.LEFT_FOOT -> LEFT_FOOT;
                default -> null;
            };
        }
    }

    private static enum HealthBarCondition {
        HEALTHY(0, 0),
        WOUNDED(0, 1),
        HEAVILY_WOUNDED(0, 2),
        DEAD(0, 3),
        HEALTHY_PREVIEW(0, 4),
        WOUNDED_PREVIEW(0, 5),
        HEAVILY_WOUNDED_PREVIEW(0, 6),
        DEAD_PREVIEW(0, 7);

        public final int iconIndexX;
        public final int iconIndexY;

        private HealthBarCondition(int iconIndexX, int iconIndexY) {
            this.iconIndexX = iconIndexX;
            this.iconIndexY = iconIndexY;
        }

        public static HealthBarCondition get(float healthRatio) {
            if (healthRatio >= 0.66f) {
                return HEALTHY;
            }
            if (healthRatio >= 0.33f) {
                return WOUNDED;
            }
            if (healthRatio > 0.0f) {
                return HEAVILY_WOUNDED;
            }
            return DEAD;
        }

        public HealthBarCondition getPreviewVariant() {
            return switch (this) {
                case HEALTHY -> HEALTHY_PREVIEW;
                case WOUNDED -> WOUNDED_PREVIEW;
                case HEAVILY_WOUNDED -> HEAVILY_WOUNDED_PREVIEW;
                case DEAD -> DEAD_PREVIEW;
                default -> this;
            };
        }
    }
}

