/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.client.render;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.common.ForgeMod;
import sereneseasons.api.SSItems;
import sfiomn.legendarysurvivaloverhaul.LegendarySurvivalOverhaul;
import sfiomn.legendarysurvivaloverhaul.common.capabilities.temperature.TemperatureItemCapability;
import sfiomn.legendarysurvivaloverhaul.common.integration.eclipticseasons.EclipticSeasonsUtil;
import sfiomn.legendarysurvivaloverhaul.common.integration.sereneseasons.SereneSeasonsUtil;
import sfiomn.legendarysurvivaloverhaul.config.Config;
import sfiomn.legendarysurvivaloverhaul.registry.ItemRegistry;
import sfiomn.legendarysurvivaloverhaul.util.CapabilityUtil;
import sfiomn.legendarysurvivaloverhaul.util.ItemUtil;
import sfiomn.legendarysurvivaloverhaul.util.WorldUtil;

public class RenderTooltipFrame {
    public static final ResourceLocation ICONS = new ResourceLocation("legendarysurvivaloverhaul", "textures/gui/overlay.png");
    private static final int FRAME_HEIGHT = 20;
    private static final int FRAME_WIDTH = 122;
    private static final int LEFT_SIDE_FRAME_X_OFFSET = 0;
    private static final int LEFT_SIDE_FRAME_WIDTH = 6;
    private static final int MIDDLE_SIDE_FRAME_X_OFFSET = 4;
    private static final int RIGHT_SIDE_FRAME_WIDTH = 6;
    private static final int MIDDLE_SIDE_FRAME_MAX_WIDTH = 114;
    private static final int RIGHT_SIDE_FRAME_X_OFFSET = 116;
    private static Entity ENTITY_LOOKED_AT = null;
    public static IGuiOverlay TOOLTIP_ITEM_FRAME = (forgeGui, guiGraphics, partialTicks, width, height) -> {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null && (ENTITY_LOOKED_AT == null || player.f_19797_ % 4 == 0)) {
            ENTITY_LOOKED_AT = WorldUtil.getEntityLookedAt((Player)player, player.m_21133_((Attribute)ForgeMod.ENTITY_REACH.get()));
        }
        if (ENTITY_LOOKED_AT instanceof ItemFrame && !((ItemFrame)ENTITY_LOOKED_AT).m_31822_().m_41619_()) {
            Item itemInFrame = ((ItemFrame)ENTITY_LOOKED_AT).m_31822_().m_41720_();
            if (LegendarySurvivalOverhaul.sereneSeasonsLoaded && (itemInFrame == SSItems.CALENDAR || itemInFrame == ItemRegistry.SEASONAL_CALENDAR.get())) {
                RenderTooltipFrame.render(forgeGui, guiGraphics, width, height, SereneSeasonsUtil.seasonTooltip(ENTITY_LOOKED_AT.m_20183_(), ENTITY_LOOKED_AT.m_9236_()));
            } else if (LegendarySurvivalOverhaul.eclipticSeasonsLoaded && itemInFrame == ItemRegistry.SEASONAL_CALENDAR.get()) {
                RenderTooltipFrame.render(forgeGui, guiGraphics, width, height, EclipticSeasonsUtil.seasonTooltip(ENTITY_LOOKED_AT.m_9236_()));
            } else if (itemInFrame == ItemRegistry.THERMOMETER.get()) {
                TemperatureItemCapability tempItemCap = CapabilityUtil.getTempItemCapability(((ItemFrame)ENTITY_LOOKED_AT).m_31822_());
                float temperature = tempItemCap.getWorldTemperatureLevel();
                MutableComponent temperatureComponent = Config.Baked.renderTemperatureInFahrenheit ? Component.m_237113_((String)(WorldUtil.toFahrenheit(temperature) + "\u00b0F")) : Component.m_237113_((String)(temperature + "\u00b0C"));
                RenderTooltipFrame.render(forgeGui, guiGraphics, width, height, (Component)temperatureComponent);
            } else if (itemInFrame == Items.f_42522_) {
                String compassLocation = ItemUtil.compassLocation(ENTITY_LOOKED_AT);
                if (!compassLocation.isEmpty()) {
                    RenderTooltipFrame.render(forgeGui, guiGraphics, width, height, (Component)Component.m_237113_((String)compassLocation));
                }
            } else if (itemInFrame == Items.f_42524_) {
                RenderTooltipFrame.render(forgeGui, guiGraphics, width, height, (Component)Component.m_237113_((String)WorldUtil.timeInGame(Minecraft.m_91087_())));
            }
        }
    };

    public static void render(ForgeGui forgeGui, GuiGraphics guiGraphics, int width, int height, Component text) {
        forgeGui.setupOverlayRenderState(true, false);
        Minecraft.m_91087_().m_91307_().m_6180_("tooltip_frame");
        RenderTooltipFrame.drawTooltipInFrame(guiGraphics, width, height, text);
        Minecraft.m_91087_().m_91307_().m_7238_();
    }

    public static void drawTooltipInFrame(GuiGraphics gui, int width, int height, Component text) {
        int textWidth = Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)text);
        int white = 0xFFFFFF;
        int left = width / 2 - textWidth / 2 - 6;
        int top = height / 2 + 10;
        int x = left;
        gui.m_280218_(ICONS, x, top, 0, 18, 6, 20);
        int remainingTextWidth = textWidth;
        x = left + 6;
        while (remainingTextWidth > 0) {
            int renderedWidth = Math.min(remainingTextWidth, 114);
            gui.m_280218_(ICONS, x, top, 4, 18, renderedWidth, 20);
            remainingTextWidth -= renderedWidth;
            x += renderedWidth;
        }
        x = left + 6 + textWidth;
        gui.m_280218_(ICONS, x, top, 116, 18, 6, 20);
        gui.m_280653_(Minecraft.m_91087_().f_91062_, text, width / 2, top + 10 - 4, white);
    }
}

