/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import org.jetbrains.annotations.Nullable;
import sfiomn.legendarysurvivaloverhaul.api.data.json.JsonThirstConsumable;
import sfiomn.legendarysurvivaloverhaul.api.data.manager.ThirstDataManager;
import sfiomn.legendarysurvivaloverhaul.api.thirst.ThirstUtil;
import sfiomn.legendarysurvivaloverhaul.common.capabilities.thirst.ThirstCapability;
import sfiomn.legendarysurvivaloverhaul.config.Config;
import sfiomn.legendarysurvivaloverhaul.registry.MobEffectRegistry;
import sfiomn.legendarysurvivaloverhaul.util.CapabilityUtil;

public class RenderThirstGui {
    private static ThirstCapability THIRST_CAP = null;
    private static final Random rand = new Random();
    public static final ResourceLocation ICONS = new ResourceLocation("legendarysurvivaloverhaul", "textures/gui/overlay.png");
    private static final int THIRST_TEXTURE_WIDTH = 9;
    private static final int THIRST_TEXTURE_HEIGHT = 9;
    @Nullable
    private static Item heldItemOnPreview;
    private static int heldItemHydration;
    private static float heldItemSaturation;
    private static boolean heldItemThirst;
    private static float alphaPreview;
    private static float unclampedAlphaPreview;
    private static int alphaDirection;
    public static final IGuiOverlay THIRST_GUI;

    public static void drawHydrationBar(ForgeGui forgeGui, GuiGraphics gui, Player player, int width, int height) {
        if (THIRST_CAP == null || player.f_19797_ % 20 == 0) {
            THIRST_CAP = CapabilityUtil.getThirstCapability(player);
        }
        ItemStack currentHeldItemStack = player.m_21205_();
        if (Config.Baked.showDrinkPreview) {
            if (player.f_19797_ % 10 == 0) {
                JsonThirstConsumable jsonThirstConsumable = ThirstDataManager.getConsumable(currentHeldItemStack);
                heldItemHydration = jsonThirstConsumable != null ? jsonThirstConsumable.hydration : 0;
                heldItemSaturation = jsonThirstConsumable != null ? jsonThirstConsumable.saturation : 0.0f;
                boolean bl = heldItemThirst = jsonThirstConsumable != null && jsonThirstConsumable.effects.stream().anyMatch(jsonEffectParameter -> jsonEffectParameter.name.equals("legendarysurvivaloverhaul:thirst"));
            }
            if (heldItemOnPreview == null || currentHeldItemStack.m_41614_() != heldItemOnPreview.m_41472_()) {
                heldItemOnPreview = currentHeldItemStack.m_41720_();
                RenderThirstGui.resetFlash();
            }
        }
        if (heldItemHydration == 0 && heldItemSaturation == 0.0f && !heldItemThirst) {
            RenderThirstGui.resetFlash();
        }
        int hydration = THIRST_CAP.getHydrationLevel();
        float saturation = THIRST_CAP.getSaturationLevel();
        int left = width / 2 + 91 + Config.Baked.hydrationBarOffsetX;
        int top = height - forgeGui.rightHeight + Config.Baked.hydrationBarOffsetY;
        boolean hasThirstEffect = player.m_21023_((MobEffect)MobEffectRegistry.THIRST.get());
        boolean hasHeatThirstEffect = player.m_21023_((MobEffect)MobEffectRegistry.HEAT_THIRST.get());
        ThirstEffect thirstEffect = ThirstEffect.getEffect(hasThirstEffect, hasHeatThirstEffect);
        ThirstEffect targetThirstEffect = ThirstEffect.getEffect(hasThirstEffect || heldItemThirst, hasHeatThirstEffect);
        for (int i = 0; i < 10; ++i) {
            int halfIcon = i * 2 + 1;
            int x = left - i * 8 - 9;
            int y = top;
            int yOffset = 0;
            if (Config.Baked.showVanillaBarAnimationOverlay && saturation <= 0.0f && player.f_19797_ % (hydration * 3 + 1) == 0) {
                yOffset = rand.nextInt(3) - 1;
            }
            if (hydration + Math.min(heldItemHydration, 0) <= halfIcon && halfIcon <= hydration + Math.max(heldItemHydration, 0)) {
                RenderThirstGui.renderFading(gui, x, y + yOffset, new ThirstIcon(thirstEffect.getXTextureOffset(halfIcon == hydration, heldItemHydration > 0), thirstEffect.getYTextureOffset()), new ThirstIcon(targetThirstEffect.getXTextureOffset(halfIcon == hydration + heldItemHydration, heldItemHydration < 0), thirstEffect.getYTextureOffset()));
            } else {
                gui.m_280218_(ICONS, x, y + yOffset, thirstEffect.getXTextureOffset(false, halfIcon > hydration + Math.max(heldItemHydration, 0)), thirstEffect.getYTextureOffset(), 9, 9);
            }
            if (!Config.Baked.thirstSaturationDisplayed) continue;
            if (Mth.m_14167_((float)(saturation + Math.min(heldItemSaturation, 0.0f))) <= halfIcon && halfIcon <= Mth.m_14167_((float)(saturation + Math.max(heldItemSaturation, 0.0f)))) {
                if (heldItemSaturation < 0.0f || halfIcon == Mth.m_14167_((float)saturation)) {
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(1.0f - alphaPreview));
                    gui.m_280218_(ICONS, x, y, thirstEffect.getXTextureOffsetSaturation(halfIcon == Mth.m_14167_((float)saturation)), 0, 9, 9);
                }
                if (heldItemSaturation > 0.0f || Mth.m_14167_((float)(saturation + heldItemSaturation)) == halfIcon) {
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alphaPreview);
                    gui.m_280218_(ICONS, x, y, targetThirstEffect.getXTextureOffsetSaturation(halfIcon == Mth.m_14167_((float)(saturation + heldItemSaturation))), 0, 9, 9);
                }
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                continue;
            }
            if (halfIcon >= Mth.m_14167_((float)(saturation + Math.min(heldItemSaturation, 0.0f)))) continue;
            gui.m_280218_(ICONS, x, y + yOffset, thirstEffect.getXTextureOffsetSaturation(false), 0, 9, 9);
        }
    }

    public static void renderFading(GuiGraphics gui, int x, int y, ThirstIcon thirstIconFrom, ThirstIcon thirstIconTo) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(1.0f - alphaPreview));
        gui.m_280218_(ICONS, x, y, thirstIconFrom.xTextureOffset, thirstIconFrom.yTextureOffset, 9, 9);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alphaPreview);
        gui.m_280218_(ICONS, x, y, thirstIconTo.xTextureOffset, thirstIconTo.yTextureOffset, 9, 9);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void updateTimer() {
        if ((unclampedAlphaPreview += (float)alphaDirection * 0.125f) >= 1.5f) {
            alphaDirection = -1;
        } else if (unclampedAlphaPreview <= -0.5f) {
            alphaDirection = 1;
        }
        alphaPreview = Mth.m_14036_((float)unclampedAlphaPreview, (float)0.0f, (float)1.0f);
    }

    public static void resetFlash() {
        alphaPreview = 0.0f;
        unclampedAlphaPreview = 0.0f;
        alphaDirection = 1;
    }

    static {
        alphaDirection = 1;
        THIRST_GUI = (forgeGui, guiGraphics, partialTicks, width, height) -> {
            LocalPlayer player;
            if (Config.Baked.thirstEnabled && Config.Baked.showHydrationBar && !Minecraft.m_91087_().f_91066_.f_92062_ && forgeGui.shouldDrawSurvivalElements() && (player = forgeGui.getMinecraft().f_91074_) != null) {
                if (!ThirstUtil.isThirstActive((Player)player)) {
                    return;
                }
                rand.setSeed((long)player.f_19797_ * 445L);
                forgeGui.setupOverlayRenderState(true, false);
                RenderSystem.disableDepthTest();
                RenderSystem.depthMask((boolean)false);
                Minecraft.m_91087_().m_91307_().m_6180_("thirst_gui");
                RenderThirstGui.drawHydrationBar(forgeGui, guiGraphics, (Player)player, width, height);
                Minecraft.m_91087_().m_91307_().m_7238_();
                RenderSystem.depthMask((boolean)true);
                RenderSystem.enableDepthTest();
                forgeGui.rightHeight += 10;
            }
        };
    }

    public static enum ThirstEffect {
        NONE(0, 0, 54),
        THIRST(27, 0, 72),
        HEAT_THIRST(0, 9, 72),
        BOTH(27, 9, 126);

        private final int xTextureOffset;
        private final int yTextureOffset;
        private final int xTextureOffsetSaturation;

        private ThirstEffect(int xTextureOffset, int yTextureOffset, int xTextureOffsetSaturation) {
            this.xTextureOffset = xTextureOffset;
            this.yTextureOffset = yTextureOffset;
            this.xTextureOffsetSaturation = xTextureOffsetSaturation;
        }

        public int getXTextureOffset(boolean isHalfIcon, boolean isContainer) {
            return isHalfIcon ? this.xTextureOffset + 18 : (isContainer ? this.xTextureOffset : this.xTextureOffset + 9);
        }

        public int getYTextureOffset() {
            return this.yTextureOffset;
        }

        public int getXTextureOffsetSaturation(boolean isHalfIcon) {
            return isHalfIcon ? this.xTextureOffsetSaturation + 9 : this.xTextureOffsetSaturation;
        }

        public static ThirstEffect getEffect(boolean hasThirstEffect, boolean hasHeatThirstEffect) {
            if (hasThirstEffect && hasHeatThirstEffect) {
                return BOTH;
            }
            if (hasThirstEffect) {
                return THIRST;
            }
            if (hasHeatThirstEffect) {
                return HEAT_THIRST;
            }
            return NONE;
        }
    }

    public record ThirstIcon(int xTextureOffset, int yTextureOffset) {
    }
}

