/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.client.render;

import java.util.Objects;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import sfiomn.legendarysurvivaloverhaul.LegendarySurvivalOverhaul;
import sfiomn.legendarysurvivaloverhaul.api.temperature.TemperatureDisplayEnum;
import sfiomn.legendarysurvivaloverhaul.api.temperature.TemperatureEnum;
import sfiomn.legendarysurvivaloverhaul.api.temperature.TemperatureUtil;
import sfiomn.legendarysurvivaloverhaul.common.capabilities.temperature.TemperatureCapability;
import sfiomn.legendarysurvivaloverhaul.common.integration.curios.CuriosUtil;
import sfiomn.legendarysurvivaloverhaul.config.Config;
import sfiomn.legendarysurvivaloverhaul.registry.MobEffectRegistry;
import sfiomn.legendarysurvivaloverhaul.util.CapabilityUtil;
import sfiomn.legendarysurvivaloverhaul.util.MathUtil;
import sfiomn.legendarysurvivaloverhaul.util.WorldUtil;

public class RenderTemperatureGui {
    private static TemperatureCapability TEMPERATURE_CAP = null;
    private static final Random rand = new Random();
    private static final ResourceLocation ICONS = new ResourceLocation("legendarysurvivaloverhaul", "textures/gui/overlay.png");
    private static final int TEMPERATURE_TEXTURE_POS_Y = 48;
    private static final int TEMPERATURE_TEXTURE_WIDTH = 16;
    private static final int TEMPERATURE_TEXTURE_HEIGHT = 16;
    private static final int BODY_TEMPERATURE_ICON_TEXTURE_POS_X = 22;
    private static final int BODY_TEMPERATURE_ICON_TEXTURE_POS_Y = 202;
    private static final int BODY_TEMPERATURE_ICON_TEXTURE_WIDTH = 10;
    private static final int BODY_TEMPERATURE_ICON_TEXTURE_HEIGHT = 22;
    private static final int BODY_TEMPERATURE_FRAME_TEXTURE_POS_Y = 211;
    private static final int BODY_TEMPERATURE_FRAME_TEXTURE_WIDTH = 23;
    private static final int BODY_TEMPERATURE_FRAME_TEXTURE_HEIGHT = 13;
    private static final int BODY_TEMPERATURE_NUMBER_TEXTURE_WIDTH = 3;
    private static final int BODY_TEMPERATURE_NUMBER_TEXTURE_HEIGHT = 5;
    private static final int HUNGER_TEXTURE_WIDTH = 9;
    private static final int HUNGER_TEXTURE_HEIGHT = 9;
    private static int frameCounter = -1;
    private static int delay = 0;
    private static boolean risingTemperature = false;
    private static boolean startAnimation = false;
    private static int flashCounter = -1;
    private static boolean shakeSide = false;
    public static IGuiOverlay TEMPERATURE_GUI = (forgeGui, guiGraphics, partialTicks, width, height) -> {
        LocalPlayer player;
        if (Config.Baked.temperatureEnabled && !Minecraft.m_91087_().f_91066_.f_92062_ && forgeGui.shouldDrawSurvivalElements() && (player = forgeGui.getMinecraft().f_91074_) != null) {
            rand.setSeed((long)player.f_19797_ * 445L);
            forgeGui.setupOverlayRenderState(true, false);
            if (Objects.requireNonNull(Config.Baked.temperatureDisplayMode) == TemperatureDisplayEnum.SYMBOL && !CuriosUtil.isThermometerEquipped) {
                Minecraft.m_91087_().m_91307_().m_6180_("temperature_gui");
                RenderTemperatureGui.drawTemperatureAsSymbol(guiGraphics, (Player)player, width, height);
                Minecraft.m_91087_().m_91307_().m_7238_();
            }
            if (LegendarySurvivalOverhaul.curiosLoaded && CuriosUtil.isThermometerEquipped) {
                Minecraft.m_91087_().m_91307_().m_6180_("body_temperature_gui");
                RenderTemperatureGui.drawBodyTemperature(guiGraphics, (Player)player, width, height);
                Minecraft.m_91087_().m_91307_().m_7238_();
            }
        }
    };
    public static IGuiOverlay FOOD_BAR_COLD_EFFECT_GUI = (forgeGui, guiGraphics, partialTicks, width, height) -> {
        LocalPlayer player;
        if (!Minecraft.m_91087_().f_91066_.f_92062_ && forgeGui.shouldDrawSurvivalElements() && (player = forgeGui.getMinecraft().f_91074_) != null && player.m_21023_((MobEffect)MobEffectRegistry.COLD_HUNGER.get())) {
            forgeGui.setupOverlayRenderState(true, false);
            Minecraft.m_91087_().m_91307_().m_6180_("temperature_gui");
            RenderTemperatureGui.drawFoodBarColdEffect(guiGraphics, (Player)player, width, height);
            Minecraft.m_91087_().m_91307_().m_7238_();
            forgeGui.rightHeight += 10;
        }
    };

    public static void drawTemperatureAsSymbol(GuiGraphics gui, Player player, int width, int height) {
        boolean isDying;
        IconPair icon;
        if (TEMPERATURE_CAP == null || player.f_19797_ % 20 == 0) {
            TEMPERATURE_CAP = CapabilityUtil.getTempCapability(player);
        }
        int x = width / 2 - 8;
        int y = height - 52;
        int xOffset = 0;
        int yOffset = 0;
        float temperature = TEMPERATURE_CAP.getTemperatureLevel();
        float targetTemperature = TEMPERATURE_CAP.getTargetTemperatureLevel();
        TemperatureEnum tempEnum = TEMPERATURE_CAP.getTemperatureEnum();
        int shakeFrequency = 0;
        switch (tempEnum) {
            case HEAT_STROKE: {
                icon = IconPair.FIRE;
                if ((int)temperature == TemperatureEnum.HEAT_STROKE.getLowerBound()) {
                    shakeFrequency = 0;
                    break;
                }
                if (temperature >= TemperatureEnum.HEAT_STROKE.getMiddle()) {
                    shakeFrequency = 1;
                    break;
                }
                shakeFrequency = 2;
                break;
            }
            case HOT: {
                icon = IconPair.ABOVE_NORMAL;
                break;
            }
            case NORMAL: {
                icon = IconPair.NORMAL;
                break;
            }
            case COLD: {
                icon = IconPair.BELOW_NORMAL;
                break;
            }
            case FROSTBITE: {
                icon = IconPair.SNOWFLAKE;
                if ((int)temperature == TemperatureEnum.FROSTBITE.getUpperBound()) {
                    shakeFrequency = 0;
                    break;
                }
                if (temperature > TemperatureEnum.FROSTBITE.getMiddle() + 1.0f) {
                    shakeFrequency = 2;
                    break;
                }
                shakeFrequency = 1;
                break;
            }
            default: {
                icon = IconPair.UNKNOWN;
            }
        }
        boolean bl = isDying = TemperatureEnum.FROSTBITE.getMiddle() >= TEMPERATURE_CAP.getTemperatureLevel() || TemperatureEnum.HEAT_STROKE.getMiddle() < TEMPERATURE_CAP.getTemperatureLevel();
        if (shakeFrequency > 0) {
            if (player.f_19797_ % shakeFrequency == 0 && !isDying) {
                int shakeCheck = player.f_19797_ / shakeFrequency;
                shakeSide = shakeCheck % 2 == 0;
                xOffset = shakeSide ? 1 : -1;
            } else if (isDying) {
                xOffset = rand.nextFloat() > 0.5f ? 1 : -1;
                yOffset = rand.nextFloat() > 0.5f ? 1 : -1;
            }
        }
        xOffset += Config.Baked.temperatureDisplayOffsetX;
        yOffset += Config.Baked.temperatureDisplayOffsetY;
        if (frameCounter >= 22) {
            icon = icon.getFlashVariant();
        }
        gui.m_280218_(ICONS, x + xOffset, y + yOffset, 16 * icon.getIconIndex(), 48, 16, 16);
        gui.m_280218_(ICONS, x + xOffset, y + yOffset, 16 * icon.getIconHolder(), 48, 16, 16);
        if (delay == 0) {
            if ((int)targetTemperature != (int)temperature) {
                risingTemperature = targetTemperature > temperature;
                startAnimation = true;
                delay = 80;
            }
        } else if (frameCounter == -1) {
            --delay;
        }
        int ovrXOffset = 16 * (frameCounter / 2 - 1);
        int ovrYOffset = 48 + 16 * (risingTemperature ? 1 : 2);
        gui.m_280218_(ICONS, x + xOffset, y + yOffset, ovrXOffset, ovrYOffset, 16, 16);
    }

    public static void drawBodyTemperature(GuiGraphics gui, Player player, int width, int height) {
        if (TEMPERATURE_CAP == null || player.f_19797_ % 20 == 0) {
            TEMPERATURE_CAP = CapabilityUtil.getTempCapability(player);
        }
        int x = width / 2 - 92 - 32 + Config.Baked.bodyTemperatureDisplayOffsetX;
        int y = height - 14 + Config.Baked.bodyTemperatureDisplayOffsetY;
        if (!player.m_21206_().m_41619_() && player.m_5737_() == HumanoidArm.RIGHT && Config.Baked.bodyTemperatureDisplayOffsetX == 0 && Config.Baked.bodyTemperatureDisplayOffsetY == 0) {
            x -= 31;
        }
        float bodyTemperature = TemperatureUtil.clampTemperature(TEMPERATURE_CAP.getTemperatureLevel());
        float tempRatio = (bodyTemperature - (float)TemperatureEnum.FROSTBITE.getLowerBound()) / (float)(TemperatureEnum.HEAT_STROKE.getUpperBound() - TemperatureEnum.FROSTBITE.getLowerBound());
        gui.m_280218_(ICONS, x, y, 0, 211, 23, 13);
        if (Config.Baked.renderTemperatureInFahrenheit) {
            bodyTemperature = Math.min(WorldUtil.toFahrenheit(bodyTemperature), 99.9f);
        }
        String bodyTemperatureString = Float.toString(MathUtil.round(bodyTemperature, 1));
        BodyTemperatureNumber number1 = BodyTemperatureNumber.get('0');
        if (bodyTemperatureString.length() == 4) {
            number1 = BodyTemperatureNumber.get(bodyTemperatureString.charAt(0));
        }
        gui.m_280218_(ICONS, x + 5, y + 4, number1.iconIndexX, number1.iconIndexY, 3, 5);
        BodyTemperatureNumber number2 = BodyTemperatureNumber.get(bodyTemperatureString.charAt(bodyTemperatureString.length() - 3));
        gui.m_280218_(ICONS, x + 9, y + 4, number2.iconIndexX, number2.iconIndexY, 3, 5);
        BodyTemperatureNumber number3 = BodyTemperatureNumber.get(bodyTemperatureString.charAt(bodyTemperatureString.length() - 1));
        gui.m_280218_(ICONS, x + 15, y + 4, number3.iconIndexX, number3.iconIndexY, 3, 5);
        gui.m_280218_(ICONS, x + 22, y - 10, 22 + 10 * BodyTemperatureIcon.EMPTY.iconIndexX, 202, 10, 22);
        int thermometerActualHeight = (int)(tempRatio * 17.0f);
        gui.m_280218_(ICONS, x + 22, y - 10 + 17 - thermometerActualHeight, 22 + 10 * BodyTemperatureIcon.get((float)tempRatio).iconIndexX, 219 - thermometerActualHeight, 10, thermometerActualHeight + 5);
    }

    public static void drawFoodBarColdEffect(GuiGraphics gui, Player player, int width, int height) {
        int foodLevel = player.m_36324_().m_38702_();
        float saturationLevelInt = (int)player.m_36324_().m_38722_();
        int left = width / 2 + 91;
        int top = height - 39;
        for (int i = 0; i < 10; ++i) {
            int halfIcon = i * 2 + 1;
            int x = left - i * 8 - 9;
            int y = top;
            int yOffset = 0;
            if (Config.Baked.showVanillaBarAnimationOverlay && player.m_36324_().m_38722_() <= 0.0f && player.f_19797_ % (player.m_36324_().m_38702_() * 3 + 1) == 0) {
                yOffset = rand.nextInt(3) - 1;
            }
            int xTextureOffset = 54;
            int yTextureOffset = 9;
            if (player.m_21023_(MobEffects.f_19612_)) {
                xTextureOffset += 27;
            }
            if (halfIcon < foodLevel) {
                gui.m_280218_(ICONS, x, y + yOffset, xTextureOffset + 9, yTextureOffset, 9, 9);
            } else if (halfIcon == foodLevel) {
                gui.m_280218_(ICONS, x, y + yOffset, xTextureOffset + 18, yTextureOffset, 9, 9);
            } else {
                gui.m_280218_(ICONS, x, y + yOffset, xTextureOffset, yTextureOffset, 9, 9);
            }
            xTextureOffset = 108;
            if (!(saturationLevelInt > 0.0f) || !Config.Baked.foodSaturationDisplayed) continue;
            if ((float)halfIcon < saturationLevelInt) {
                gui.m_280218_(ICONS, x, y + yOffset, xTextureOffset, yTextureOffset, 9, 9);
                continue;
            }
            if ((float)halfIcon != saturationLevelInt) continue;
            gui.m_280218_(ICONS, x, y + yOffset, xTextureOffset + 9, yTextureOffset, 9, 9);
        }
    }

    public static void updateTimer() {
        if (frameCounter >= 0) {
            --frameCounter;
        }
        if (flashCounter >= 0) {
            --flashCounter;
        }
        if (startAnimation) {
            frameCounter = 24;
            startAnimation = false;
        }
    }

    private static enum IconPair {
        NORMAL(0, 3),
        FIRE(1, 4),
        SNOWFLAKE(2, 5),
        ABOVE_NORMAL(0, 11),
        BELOW_NORMAL(0, 12),
        NORMAL_FLASH(0, 6),
        FIRE_FLASH(1, 7),
        SNOWFLAKE_FLASH(2, 8),
        ABOVE_NORMAL_FLASH(0, 9),
        BELOW_NORMAL_FLASH(0, 10),
        UNKNOWN(0, 13);

        private final int iconIndex;
        private final int iconHolder;

        private IconPair(int iconIndex, int iconHolder) {
            this.iconIndex = iconIndex;
            this.iconHolder = iconHolder;
        }

        public int getIconIndex() {
            return this.iconIndex;
        }

        public int getIconHolder() {
            return this.iconHolder;
        }

        public IconPair getFlashVariant() {
            switch (this) {
                case NORMAL: {
                    return NORMAL_FLASH;
                }
                case FIRE: {
                    return FIRE_FLASH;
                }
                case SNOWFLAKE: {
                    return SNOWFLAKE_FLASH;
                }
                case ABOVE_NORMAL: {
                    return ABOVE_NORMAL_FLASH;
                }
                case BELOW_NORMAL: {
                    return BELOW_NORMAL_FLASH;
                }
            }
            return this;
        }
    }

    private static enum BodyTemperatureNumber {
        ZERO(17, 231),
        ONE(1, 225),
        TWO(5, 225),
        THREE(9, 225),
        FOUR(13, 225),
        FIVE(17, 225),
        SIX(1, 231),
        SEVEN(5, 231),
        HEIGHT(9, 231),
        NINE(13, 231);

        public final int iconIndexX;
        public final int iconIndexY;

        private BodyTemperatureNumber(int iconIndexX, int iconIndexY) {
            this.iconIndexX = iconIndexX;
            this.iconIndexY = iconIndexY;
        }

        public static BodyTemperatureNumber get(char charNum) {
            return BodyTemperatureNumber.values()[Character.getNumericValue(charNum)];
        }
    }

    private static enum BodyTemperatureIcon {
        EMPTY(0),
        COLD_0(1),
        COLD_1(2),
        COLD_2(3),
        TEMPERATE_0(4),
        TEMPERATE_1(5),
        TEMPERATE_2(6),
        HOT_0(7),
        HOT_1(8),
        HOT_2(9);

        public final int iconIndexX;

        private BodyTemperatureIcon(int iconIndexX) {
            this.iconIndexX = iconIndexX;
        }

        public static BodyTemperatureIcon get(float tempRatio) {
            return BodyTemperatureIcon.values()[Math.min(1 + (int)(tempRatio * 9.0f), 9)];
        }
    }
}

