/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.api.data.providers;

import com.google.gson.JsonElement;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import sfiomn.legendarysurvivaloverhaul.api.data.builder.ITemperatureBiomeOverrideData;
import sfiomn.legendarysurvivaloverhaul.api.data.builder.ITemperatureBlockData;
import sfiomn.legendarysurvivaloverhaul.api.data.builder.ITemperatureBlockDataHolder;
import sfiomn.legendarysurvivaloverhaul.api.data.builder.ITemperatureConsumableBlockData;
import sfiomn.legendarysurvivaloverhaul.api.data.builder.ITemperatureConsumableBlockDataHolder;
import sfiomn.legendarysurvivaloverhaul.api.data.builder.ITemperatureConsumableData;
import sfiomn.legendarysurvivaloverhaul.api.data.builder.ITemperatureConsumableDataHolder;
import sfiomn.legendarysurvivaloverhaul.api.data.builder.ITemperatureData;
import sfiomn.legendarysurvivaloverhaul.api.data.builder.ITemperatureDimensionData;
import sfiomn.legendarysurvivaloverhaul.api.data.builder.ITemperatureFuelItemData;
import sfiomn.legendarysurvivaloverhaul.api.data.builder.ITemperatureResistanceData;
import sfiomn.legendarysurvivaloverhaul.api.temperature.TemporaryModifierGroupEnum;
import sfiomn.legendarysurvivaloverhaul.data.builders.TemperatureBiomeOverrideData;
import sfiomn.legendarysurvivaloverhaul.data.builders.TemperatureBlockData;
import sfiomn.legendarysurvivaloverhaul.data.builders.TemperatureBlockDataHolder;
import sfiomn.legendarysurvivaloverhaul.data.builders.TemperatureConsumableBlockData;
import sfiomn.legendarysurvivaloverhaul.data.builders.TemperatureConsumableBlockDataHolder;
import sfiomn.legendarysurvivaloverhaul.data.builders.TemperatureConsumableData;
import sfiomn.legendarysurvivaloverhaul.data.builders.TemperatureConsumableDataHolder;
import sfiomn.legendarysurvivaloverhaul.data.builders.TemperatureData;
import sfiomn.legendarysurvivaloverhaul.data.builders.TemperatureDimensionData;
import sfiomn.legendarysurvivaloverhaul.data.builders.TemperatureFuelItemData;
import sfiomn.legendarysurvivaloverhaul.data.builders.TemperatureResistanceData;

public abstract class TemperatureDataProvider
implements DataProvider {
    private final String modId;
    private final CompletableFuture<HolderLookup.Provider> lookupProvider;
    private final PackOutput.PathProvider consumablesPathProvider;
    private final PackOutput.PathProvider consumableBlocksPathProvider;
    private final PackOutput.PathProvider blocksPathProvider;
    private final PackOutput.PathProvider itemsPathProvider;
    private final PackOutput.PathProvider biomesPathProvider;
    private final PackOutput.PathProvider fuelItemPathProvider;
    private final PackOutput.PathProvider dimensionPathProvider;
    private final PackOutput.PathProvider mountPathProvider;
    private final PackOutput.PathProvider originPathProvider;
    private final Map<String, ITemperatureConsumableDataHolder> consumableBuilders = new HashMap<String, ITemperatureConsumableDataHolder>();
    private final Map<String, ITemperatureConsumableBlockDataHolder> consumableBlockBuilders = new HashMap<String, ITemperatureConsumableBlockDataHolder>();
    private final Map<String, ITemperatureBlockDataHolder> blockBuilders = new HashMap<String, ITemperatureBlockDataHolder>();
    private final Map<String, ITemperatureResistanceData> itemBuilders = new HashMap<String, ITemperatureResistanceData>();
    private final Map<String, ITemperatureBiomeOverrideData> biomeBuilders = new HashMap<String, ITemperatureBiomeOverrideData>();
    private final Map<String, ITemperatureFuelItemData> fuelItemBuilders = new HashMap<String, ITemperatureFuelItemData>();
    private final Map<String, ITemperatureDimensionData> dimensionBuilders = new HashMap<String, ITemperatureDimensionData>();
    private final Map<String, ITemperatureData> mountBuilders = new HashMap<String, ITemperatureData>();
    private final Map<String, ITemperatureResistanceData> originBuilders = new HashMap<String, ITemperatureResistanceData>();
    private final ExistingFileHelper fileHelper;

    public TemperatureDataProvider(String modId, PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, ExistingFileHelper fileHelper) {
        this.modId = modId;
        this.fileHelper = fileHelper;
        this.consumablesPathProvider = output.m_245269_(PackOutput.Target.DATA_PACK, "legendarysurvivaloverhaul/temperature/consumables");
        this.consumableBlocksPathProvider = output.m_245269_(PackOutput.Target.DATA_PACK, "legendarysurvivaloverhaul/temperature/consumable_blocks");
        this.blocksPathProvider = output.m_245269_(PackOutput.Target.DATA_PACK, "legendarysurvivaloverhaul/temperature/blocks");
        this.itemsPathProvider = output.m_245269_(PackOutput.Target.DATA_PACK, "legendarysurvivaloverhaul/temperature/items");
        this.biomesPathProvider = output.m_245269_(PackOutput.Target.DATA_PACK, "legendarysurvivaloverhaul/temperature/biomes");
        this.fuelItemPathProvider = output.m_245269_(PackOutput.Target.DATA_PACK, "legendarysurvivaloverhaul/temperature/fuel_items");
        this.dimensionPathProvider = output.m_245269_(PackOutput.Target.DATA_PACK, "legendarysurvivaloverhaul/temperature/dimensions");
        this.mountPathProvider = output.m_245269_(PackOutput.Target.DATA_PACK, "legendarysurvivaloverhaul/temperature/mounts");
        this.originPathProvider = output.m_245269_(PackOutput.Target.DATA_PACK, "legendarysurvivaloverhaul/temperature/origins");
        this.lookupProvider = lookupProvider;
    }

    public abstract void generate(HolderLookup.Provider var1, ExistingFileHelper var2);

    @Nonnull
    public CompletableFuture<?> m_213708_(@Nonnull CachedOutput pOutput) {
        return this.lookupProvider.thenCompose(p_255484_ -> {
            ArrayList list = new ArrayList();
            this.generate((HolderLookup.Provider)p_255484_, this.fileHelper);
            this.consumableBuilders.forEach((consumable, builder) -> {
                ResourceLocation jsonKey = consumable.split(":").length == 1 ? new ResourceLocation(this.modId, consumable.toLowerCase()) : new ResourceLocation(consumable);
                list.add(DataProvider.m_253162_((CachedOutput)pOutput, (JsonElement)builder.build(), (Path)this.consumablesPathProvider.m_245731_(jsonKey)));
            });
            this.consumableBlockBuilders.forEach((consumableBlock, builder) -> {
                ResourceLocation jsonKey = consumableBlock.split(":").length == 1 ? new ResourceLocation(this.modId, consumableBlock.toLowerCase()) : new ResourceLocation(consumableBlock);
                list.add(DataProvider.m_253162_((CachedOutput)pOutput, (JsonElement)builder.build(), (Path)this.consumableBlocksPathProvider.m_245731_(jsonKey)));
            });
            this.blockBuilders.forEach((block, builder) -> {
                ResourceLocation jsonKey = block.split(":").length == 1 ? new ResourceLocation(this.modId, block.toLowerCase()) : new ResourceLocation(block);
                list.add(DataProvider.m_253162_((CachedOutput)pOutput, (JsonElement)builder.build(), (Path)this.blocksPathProvider.m_245731_(jsonKey)));
            });
            this.itemBuilders.forEach((item, builder) -> {
                ResourceLocation jsonKey = item.split(":").length == 1 ? new ResourceLocation(this.modId, item.toLowerCase()) : new ResourceLocation(item);
                list.add(DataProvider.m_253162_((CachedOutput)pOutput, (JsonElement)builder.build(), (Path)this.itemsPathProvider.m_245731_(jsonKey)));
            });
            this.biomeBuilders.forEach((biome, builder) -> {
                Path path = this.biomesPathProvider.m_245731_(new ResourceLocation(this.modId, biome.toLowerCase()));
                list.add(DataProvider.m_253162_((CachedOutput)pOutput, (JsonElement)builder.build(), (Path)path));
            });
            this.fuelItemBuilders.forEach((fuelItem, builder) -> {
                ResourceLocation jsonKey = fuelItem.split(":").length == 1 ? new ResourceLocation(this.modId, fuelItem.toLowerCase()) : new ResourceLocation(fuelItem);
                list.add(DataProvider.m_253162_((CachedOutput)pOutput, (JsonElement)builder.build(), (Path)this.fuelItemPathProvider.m_245731_(jsonKey)));
            });
            this.dimensionBuilders.forEach((dimension, builder) -> {
                Path path = this.dimensionPathProvider.m_245731_(new ResourceLocation(this.modId, dimension.toLowerCase()));
                list.add(DataProvider.m_253162_((CachedOutput)pOutput, (JsonElement)builder.build(), (Path)path));
            });
            this.mountBuilders.forEach((mount, builder) -> {
                Path path = this.mountPathProvider.m_245731_(new ResourceLocation(this.modId, mount.toLowerCase()));
                list.add(DataProvider.m_253162_((CachedOutput)pOutput, (JsonElement)builder.build(), (Path)path));
            });
            this.originBuilders.forEach((origin, builder) -> {
                Path path = this.originPathProvider.m_245731_(new ResourceLocation(this.modId, origin.toLowerCase()));
                list.add(DataProvider.m_253162_((CachedOutput)pOutput, (JsonElement)builder.build(), (Path)path));
            });
            return CompletableFuture.allOf((CompletableFuture[])list.toArray(CompletableFuture[]::new));
        });
    }

    public final ITemperatureConsumableDataHolder consumable(String id) {
        return this.consumableBuilders.computeIfAbsent(id, k -> new TemperatureConsumableDataHolder());
    }

    public final ITemperatureConsumableDataHolder consumable(Item item) {
        ResourceLocation itemRegistryName = ForgeRegistries.ITEMS.getKey((Object)item);
        assert (itemRegistryName != null);
        return this.consumableBuilders.computeIfAbsent(itemRegistryName.toString(), k -> new TemperatureConsumableDataHolder());
    }

    public final ITemperatureConsumableData temperatureConsumable(TemporaryModifierGroupEnum group) {
        return new TemperatureConsumableData().group(group);
    }

    public final ITemperatureConsumableBlockDataHolder consumableBlock(String id) {
        return this.consumableBlockBuilders.computeIfAbsent(id, k -> new TemperatureConsumableBlockDataHolder());
    }

    public final ITemperatureConsumableBlockDataHolder consumableAndConsumableBlock(String id, ITemperatureConsumableData data) {
        this.consumableBuilders.computeIfAbsent(id, k -> new TemperatureConsumableDataHolder().addTemperature(data));
        return this.consumableBlockBuilders.computeIfAbsent(id, k -> new TemperatureConsumableBlockDataHolder().addTemperature(data.asBlock()));
    }

    public final ITemperatureConsumableBlockData temperatureConsumableBlock(TemporaryModifierGroupEnum group) {
        return new TemperatureConsumableBlockData().group(group);
    }

    public final ITemperatureBlockDataHolder block(String id) {
        return this.blockBuilders.computeIfAbsent(id, k -> new TemperatureBlockDataHolder());
    }

    public final ITemperatureBlockDataHolder block(Block block) {
        ResourceLocation blockRegistryName = ForgeRegistries.BLOCKS.getKey((Object)block);
        assert (blockRegistryName != null);
        return this.blockBuilders.computeIfAbsent(blockRegistryName.toString(), k -> new TemperatureBlockDataHolder());
    }

    public final ITemperatureBlockData temperatureBlock(float temperatureValue) {
        return new TemperatureBlockData().temperature(temperatureValue);
    }

    public final ITemperatureResistanceData item(String id) {
        return this.itemBuilders.computeIfAbsent(id, k -> new TemperatureResistanceData());
    }

    public final ITemperatureResistanceData item(Item item) {
        ResourceLocation itemRegistryName = ForgeRegistries.ITEMS.getKey((Object)item);
        assert (itemRegistryName != null);
        return this.itemBuilders.computeIfAbsent(itemRegistryName.toString(), k -> new TemperatureResistanceData());
    }

    public final ITemperatureBiomeOverrideData biome(String id) {
        return this.biomeBuilders.computeIfAbsent(id, k -> new TemperatureBiomeOverrideData());
    }

    public final ITemperatureFuelItemData fuelItem(String id) {
        return this.fuelItemBuilders.computeIfAbsent(id, k -> new TemperatureFuelItemData());
    }

    public final ITemperatureDimensionData dimension(String id) {
        return this.dimensionBuilders.computeIfAbsent(id, k -> new TemperatureDimensionData());
    }

    public final ITemperatureData mount(String id) {
        return this.mountBuilders.computeIfAbsent(id, k -> new TemperatureData());
    }

    public final ITemperatureResistanceData origin(String id) {
        return this.originBuilders.computeIfAbsent(id, k -> new TemperatureResistanceData());
    }

    @Nonnull
    public final String m_6055_() {
        return "Temperature for " + this.modId;
    }
}

