/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.api.data.json;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import sfiomn.legendarysurvivaloverhaul.LegendarySurvivalOverhaul;
import sfiomn.legendarysurvivaloverhaul.api.data.json.JsonMobEffect;

public class JsonThirstConsumable {
    public static final Codec<JsonThirstConsumable> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.INT.fieldOf("hydration").forGetter(c -> c.hydration), (App)Codec.FLOAT.fieldOf("saturation").forGetter(c -> Float.valueOf(c.saturation)), (App)JsonMobEffect.LIST_CODEC.optionalFieldOf("effects", new ArrayList()).forGetter(c -> c.effects), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.STRING).optionalFieldOf("properties", new HashMap()).forGetter(c -> c.properties)).apply((Applicative)inst, JsonThirstConsumable::new));
    public static final Codec<List<JsonThirstConsumable>> LIST_CODEC = CODEC.listOf();
    public int hydration;
    public float saturation;
    public List<JsonMobEffect> effects;
    public Map<String, String> properties;

    public JsonThirstConsumable(int hydration, float saturation, List<JsonMobEffect> effects, Map<String, String> properties) {
        this.hydration = hydration;
        this.saturation = saturation;
        this.effects = new ArrayList<JsonMobEffect>();
        this.effects.addAll(effects);
        this.properties = new HashMap<String, String>();
        this.properties.putAll(properties);
    }

    public boolean isDefault() {
        return this.properties.isEmpty();
    }

    public boolean matchesNbt(ItemStack itemStack) {
        if (itemStack.m_41782_() == this.properties.isEmpty()) {
            return false;
        }
        CompoundTag itemStackTag = itemStack.m_41783_();
        if (itemStackTag == null && this.properties.isEmpty()) {
            return true;
        }
        assert (itemStackTag != null);
        for (Map.Entry<String, String> nbtEntry : this.properties.entrySet()) {
            if (!itemStackTag.m_128441_(nbtEntry.getKey())) {
                return false;
            }
            byte tagType = itemStackTag.m_128435_(nbtEntry.getKey());
            if (tagType == 8) {
                if (itemStackTag.m_128461_(nbtEntry.getKey()).equals(nbtEntry.getValue())) continue;
                return false;
            }
            if (tagType == 1 || tagType == 2 || tagType == 3 || tagType == 4 || tagType == 5 || tagType == 6) {
                if (itemStackTag.m_128459_(nbtEntry.getKey()) == Double.parseDouble(nbtEntry.getValue())) continue;
                return false;
            }
            LegendarySurvivalOverhaul.LOGGER.error("Error while matching nbt for {} : Tag type {} not taken into account.\nIt can either be a String (tag type 8) or a numeric (tag type in [1-6])", (Object)itemStack.m_41778_(), (Object)tagType);
        }
        return true;
    }
}

