/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul;

import java.nio.file.Path;
import java.nio.file.Paths;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import sfiomn.legendarysurvivaloverhaul.api.bodydamage.BodyDamageUtil;
import sfiomn.legendarysurvivaloverhaul.api.data.manager.BodyDamageDataManager;
import sfiomn.legendarysurvivaloverhaul.api.data.manager.TemperatureDataManager;
import sfiomn.legendarysurvivaloverhaul.api.data.manager.ThirstDataManager;
import sfiomn.legendarysurvivaloverhaul.api.health.HealthUtil;
import sfiomn.legendarysurvivaloverhaul.api.temperature.TemperatureUtil;
import sfiomn.legendarysurvivaloverhaul.api.thirst.ThirstUtil;
import sfiomn.legendarysurvivaloverhaul.api.wetness.WetnessUtil;
import sfiomn.legendarysurvivaloverhaul.client.itemproperties.CanteenProperty;
import sfiomn.legendarysurvivaloverhaul.client.itemproperties.SeasonalCalendarSeasonTypeProperty;
import sfiomn.legendarysurvivaloverhaul.client.itemproperties.SeasonalCalendarTimeProperty;
import sfiomn.legendarysurvivaloverhaul.client.itemproperties.ThermometerProperty;
import sfiomn.legendarysurvivaloverhaul.client.screens.SewingTableScreen;
import sfiomn.legendarysurvivaloverhaul.client.screens.ThermalScreen;
import sfiomn.legendarysurvivaloverhaul.common.capabilities.bodydamage.BodyDamageCapability;
import sfiomn.legendarysurvivaloverhaul.common.capabilities.food.FoodCapability;
import sfiomn.legendarysurvivaloverhaul.common.capabilities.health.HealthCapability;
import sfiomn.legendarysurvivaloverhaul.common.capabilities.temperature.TemperatureCapability;
import sfiomn.legendarysurvivaloverhaul.common.capabilities.temperature.TemperatureItemCapability;
import sfiomn.legendarysurvivaloverhaul.common.capabilities.thirst.ThirstCapability;
import sfiomn.legendarysurvivaloverhaul.common.capabilities.wetness.WetnessCapability;
import sfiomn.legendarysurvivaloverhaul.common.integration.curios.CuriosEvents;
import sfiomn.legendarysurvivaloverhaul.common.integration.eclipticseasons.EclipticSeasonsUtil;
import sfiomn.legendarysurvivaloverhaul.common.integration.jsonConfig.JsonIntegrationConfigRegistration;
import sfiomn.legendarysurvivaloverhaul.common.integration.origins.OriginsEvents;
import sfiomn.legendarysurvivaloverhaul.common.integration.sereneseasons.SereneSeasonsUtil;
import sfiomn.legendarysurvivaloverhaul.common.integration.vampirism.VampirismEvents;
import sfiomn.legendarysurvivaloverhaul.common.listeners.BodyDamageHealingConsumableListener;
import sfiomn.legendarysurvivaloverhaul.common.listeners.BodyPartResistanceItemListener;
import sfiomn.legendarysurvivaloverhaul.common.listeners.BodyPartsDamageSourceListener;
import sfiomn.legendarysurvivaloverhaul.common.listeners.TemperatureBiomeListener;
import sfiomn.legendarysurvivaloverhaul.common.listeners.TemperatureBlockListener;
import sfiomn.legendarysurvivaloverhaul.common.listeners.TemperatureConsumableBlockListener;
import sfiomn.legendarysurvivaloverhaul.common.listeners.TemperatureConsumableListener;
import sfiomn.legendarysurvivaloverhaul.common.listeners.TemperatureDimensionListener;
import sfiomn.legendarysurvivaloverhaul.common.listeners.TemperatureFuelItemListener;
import sfiomn.legendarysurvivaloverhaul.common.listeners.TemperatureItemListener;
import sfiomn.legendarysurvivaloverhaul.common.listeners.TemperatureMountListener;
import sfiomn.legendarysurvivaloverhaul.common.listeners.TemperatureOriginListener;
import sfiomn.legendarysurvivaloverhaul.common.listeners.ThirstBlockListener;
import sfiomn.legendarysurvivaloverhaul.common.listeners.ThirstConsumableListener;
import sfiomn.legendarysurvivaloverhaul.config.Config;
import sfiomn.legendarysurvivaloverhaul.network.NetworkHandler;
import sfiomn.legendarysurvivaloverhaul.registry.AttributeRegistry;
import sfiomn.legendarysurvivaloverhaul.registry.BlockEntityRegistry;
import sfiomn.legendarysurvivaloverhaul.registry.BlockRegistry;
import sfiomn.legendarysurvivaloverhaul.registry.CommandRegistry;
import sfiomn.legendarysurvivaloverhaul.registry.ContainerRegistry;
import sfiomn.legendarysurvivaloverhaul.registry.CreativeTabRegistry;
import sfiomn.legendarysurvivaloverhaul.registry.FeatureRegistry;
import sfiomn.legendarysurvivaloverhaul.registry.ItemRegistry;
import sfiomn.legendarysurvivaloverhaul.registry.LootModifierRegistry;
import sfiomn.legendarysurvivaloverhaul.registry.MobEffectRegistry;
import sfiomn.legendarysurvivaloverhaul.registry.ParticleTypeRegistry;
import sfiomn.legendarysurvivaloverhaul.registry.RecipeRegistry;
import sfiomn.legendarysurvivaloverhaul.registry.SoundRegistry;
import sfiomn.legendarysurvivaloverhaul.registry.TemperatureModifierRegistry;
import sfiomn.legendarysurvivaloverhaul.util.internal.BodyDamageUtilInternal;
import sfiomn.legendarysurvivaloverhaul.util.internal.HealthUtilInternal;
import sfiomn.legendarysurvivaloverhaul.util.internal.TemperatureUtilInternal;
import sfiomn.legendarysurvivaloverhaul.util.internal.ThirstUtilInternal;
import sfiomn.legendarysurvivaloverhaul.util.internal.WetnessUtilInternal;

@Mod(value="legendarysurvivaloverhaul")
public class LegendarySurvivalOverhaul {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String MOD_ID = "legendarysurvivaloverhaul";
    public static boolean betterWeatherLoaded = false;
    public static boolean sereneSeasonsLoaded = false;
    public static boolean eclipticSeasonsLoaded = false;
    public static boolean terraFirmaCraftLoaded = false;
    public static boolean surviveLoaded = false;
    public static boolean curiosLoaded = false;
    public static boolean vampirismLoaded = false;
    public static boolean originsLoaded = false;
    public static boolean mutantMonstersLoaded = false;
    public static boolean supplementariesLoaded = false;
    public static boolean artifactsLoaded = false;
    public static boolean beachpartyLoaded = false;
    public static boolean meadowLoaded = false;
    public static boolean overflowingbarsLoaded = false;
    public static boolean weather2Loaded = false;
    public static boolean medsandherbsLoaded = false;
    public static Path configPath = FMLPaths.CONFIGDIR.get();
    public static Path modConfigPath = Paths.get(configPath.toAbsolutePath().toString(), "legendarysurvivaloverhaul");
    public static Path modConfigJsons = Paths.get(modConfigPath.toString(), "json");
    public static Path modIntegrationConfigJsons = Paths.get(modConfigJsons.toString(), "integration");

    public LegendarySurvivalOverhaul() {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        modBus.addListener(this::commonSetup);
        modBus.addListener(this::onModConfigLoadEvent);
        modBus.addListener(this::onLoadComplete);
        forgeBus.addListener(this::addReloadListenerEvent);
        Config.register();
        AttributeRegistry.register(modBus);
        ItemRegistry.register(modBus);
        MobEffectRegistry.register(modBus);
        LootModifierRegistry.register(modBus);
        BlockRegistry.register(modBus);
        ContainerRegistry.register(modBus);
        ParticleTypeRegistry.register(modBus);
        RecipeRegistry.register(modBus);
        SoundRegistry.register(modBus);
        TemperatureModifierRegistry.register(modBus);
        BlockEntityRegistry.register(modBus);
        FeatureRegistry.register(modBus);
        CreativeTabRegistry.register(modBus);
        forgeBus.addListener(CommandRegistry::registerCommandsEvent);
        forgeBus.addListener(this::registerCapabilities);
        forgeBus.register((Object)this);
        this.modIntegration(forgeBus);
    }

    private void modIntegration(IEventBus forgeBus) {
        sereneSeasonsLoaded = ModList.get().isLoaded("sereneseasons");
        eclipticSeasonsLoaded = ModList.get().isLoaded("eclipticseasons");
        curiosLoaded = ModList.get().isLoaded("curios");
        terraFirmaCraftLoaded = ModList.get().isLoaded("tfc");
        vampirismLoaded = ModList.get().isLoaded("vampirism");
        originsLoaded = ModList.get().isLoaded("origins");
        mutantMonstersLoaded = ModList.get().isLoaded("mutantmonsters");
        supplementariesLoaded = ModList.get().isLoaded("supplementaries");
        artifactsLoaded = ModList.get().isLoaded("artifacts");
        beachpartyLoaded = ModList.get().isLoaded("beachparty");
        meadowLoaded = ModList.get().isLoaded("meadow");
        overflowingbarsLoaded = ModList.get().isLoaded("overflowingbars");
        medsandherbsLoaded = ModList.get().isLoaded("meds_and_herbs");
        weather2Loaded = ModList.get().isLoaded("weather2");
        surviveLoaded = ModList.get().isLoaded("survive");
        if (sereneSeasonsLoaded) {
            LOGGER.debug("Serene Seasons is loaded, enabling compatibility");
        }
        if (eclipticSeasonsLoaded) {
            if (sereneSeasonsLoaded) {
                LOGGER.debug("Ecliptic Seasons and Serene Seasons are loaded, please choose one over the other");
            } else {
                LOGGER.debug("Ecliptic Seasons is loaded, enabling compatibility");
            }
        }
        if (terraFirmaCraftLoaded) {
            LOGGER.debug("TerraFirmaCraft is loaded, enabling compatibility");
        }
        if (mutantMonstersLoaded) {
            LOGGER.debug("Mutant Monsters is loaded, enabling compatibility");
        }
        if (curiosLoaded) {
            LOGGER.debug("Curios is loaded, enabling compatibility");
            forgeBus.register(CuriosEvents.class);
        }
        if (vampirismLoaded) {
            LOGGER.debug("Vampirism is loaded, enabling compatibility");
            forgeBus.register(VampirismEvents.class);
        }
        if (originsLoaded) {
            LOGGER.debug("Origins is loaded, enabling compatibility");
            forgeBus.register(OriginsEvents.class);
        }
        if (supplementariesLoaded) {
            LOGGER.debug("Supplementarie is loaded, enabling compatibility");
        }
        if (artifactsLoaded) {
            LOGGER.debug("Artifacts is loaded, enabling compatibility");
        }
        if (beachpartyLoaded) {
            LOGGER.debug("Let's do Beachparty is loaded, enabling compatibility");
        }
        if (meadowLoaded) {
            LOGGER.debug("Let's do Meadow is loaded, enabling compatibility");
        }
        if (overflowingbarsLoaded) {
            LOGGER.debug("Overflowing Bars is loaded, enabling compatibility");
        }
        if (medsandherbsLoaded) {
            LOGGER.debug("Meds And Herbs is loaded, enabling compatibility");
        }
        if (weather2Loaded) {
            LOGGER.debug("Weather2 is loaded, no compatibility for now");
        }
        if (surviveLoaded) {
            LOGGER.debug("Survive is loaded, I hope you know what you're doing");
        }
        JsonIntegrationConfigRegistration.init(modIntegrationConfigJsons.toFile());
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            NetworkHandler.register();
            TemperatureUtil.internal = new TemperatureUtilInternal();
            ThirstUtil.internal = new ThirstUtilInternal();
            BodyDamageUtil.internal = new BodyDamageUtilInternal();
            WetnessUtil.internal = new WetnessUtilInternal();
            HealthUtil.internal = new HealthUtilInternal();
            TemperatureDataManager.internalConsumable = new TemperatureConsumableListener();
            TemperatureDataManager.internalConsumableBlock = new TemperatureConsumableBlockListener();
            TemperatureDataManager.internalBlock = new TemperatureBlockListener();
            TemperatureDataManager.internalItem = new TemperatureItemListener();
            TemperatureDataManager.internalBiome = new TemperatureBiomeListener();
            TemperatureDataManager.internalFuelItem = new TemperatureFuelItemListener();
            TemperatureDataManager.internalDimension = new TemperatureDimensionListener();
            TemperatureDataManager.internalMount = new TemperatureMountListener();
            TemperatureDataManager.internalOrigin = new TemperatureOriginListener();
            ThirstDataManager.internalConsumable = new ThirstConsumableListener();
            ThirstDataManager.internalBlock = new ThirstBlockListener();
            BodyDamageDataManager.internalBodyPartsDamageSource = new BodyPartsDamageSourceListener();
            BodyDamageDataManager.internalHealingConsumable = new BodyDamageHealingConsumableListener();
            BodyDamageDataManager.internalBodyResistanceItem = new BodyPartResistanceItemListener();
        });
    }

    private void onLoadComplete(FMLLoadCompleteEvent event) {
        event.enqueueWork(() -> {
            BodyDamageUtilInternal.initMalusConfig();
            BodyDamageUtilInternal.initFirstAidSuppliesBoostingEffects();
            if (sereneSeasonsLoaded) {
                SereneSeasonsUtil.initAverageTemperatures();
            }
            if (eclipticSeasonsLoaded) {
                EclipticSeasonsUtil.initAverageTemperatures();
            }
            if (Config.Baked.temperatureEnabled) {
                MobEffectRegistry.registerBrewingRecipes();
            }
        });
    }

    private void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.register(TemperatureCapability.class);
        event.register(WetnessCapability.class);
        event.register(ThirstCapability.class);
        event.register(HealthCapability.class);
        event.register(TemperatureItemCapability.class);
        event.register(FoodCapability.class);
        event.register(BodyDamageCapability.class);
    }

    private void onModConfigLoadEvent(ModConfigEvent.Loading event) {
        ModConfig config = event.getConfig();
        if (config.getSpec() == Config.CLIENT_SPEC) {
            Config.Baked.bakeClient();
        }
        if (config.getSpec() == Config.COMMON_SPEC) {
            Config.Baked.bakeCommon();
        }
    }

    private void onModConfigReloadEvent(ModConfigEvent.Reloading event) {
        ModConfig config = event.getConfig();
        if (config.getSpec() == Config.CLIENT_SPEC) {
            Config.Baked.bakeClient();
        }
    }

    private void addReloadListenerEvent(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)TemperatureDataManager.internalConsumable);
        event.addListener((PreparableReloadListener)TemperatureDataManager.internalConsumableBlock);
        event.addListener((PreparableReloadListener)TemperatureDataManager.internalBlock);
        event.addListener((PreparableReloadListener)TemperatureDataManager.internalItem);
        event.addListener((PreparableReloadListener)TemperatureDataManager.internalBiome);
        event.addListener((PreparableReloadListener)TemperatureDataManager.internalFuelItem);
        event.addListener((PreparableReloadListener)TemperatureDataManager.internalDimension);
        event.addListener((PreparableReloadListener)TemperatureDataManager.internalMount);
        event.addListener((PreparableReloadListener)TemperatureDataManager.internalOrigin);
        event.addListener((PreparableReloadListener)ThirstDataManager.internalConsumable);
        event.addListener((PreparableReloadListener)ThirstDataManager.internalBlock);
        event.addListener((PreparableReloadListener)BodyDamageDataManager.internalBodyPartsDamageSource);
        event.addListener((PreparableReloadListener)BodyDamageDataManager.internalHealingConsumable);
        event.addListener((PreparableReloadListener)BodyDamageDataManager.internalBodyResistanceItem);
    }

    @Mod.EventBusSubscriber(modid="legendarysurvivaloverhaul", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            Config.Baked.bakeClient();
            MenuScreens.m_96206_((MenuType)((MenuType)ContainerRegistry.COOLER_CONTAINER.get()), ThermalScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)ContainerRegistry.HEATER_CONTAINER.get()), ThermalScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)ContainerRegistry.SEWING_TABLE_CONTAINER.get()), SewingTableScreen::new);
            ItemProperties.register((Item)((Item)ItemRegistry.THERMOMETER.get()), (ResourceLocation)new ResourceLocation(LegendarySurvivalOverhaul.MOD_ID, "temperature"), (ItemPropertyFunction)new ThermometerProperty());
            ItemProperties.register((Item)((Item)ItemRegistry.CANTEEN.get()), (ResourceLocation)new ResourceLocation(LegendarySurvivalOverhaul.MOD_ID, "thirstenum"), (ItemPropertyFunction)new CanteenProperty());
            ItemProperties.register((Item)((Item)ItemRegistry.LARGE_CANTEEN.get()), (ResourceLocation)new ResourceLocation(LegendarySurvivalOverhaul.MOD_ID, "thirstenum"), (ItemPropertyFunction)new CanteenProperty());
            if (sereneSeasonsLoaded || eclipticSeasonsLoaded) {
                ItemProperties.register((Item)((Item)ItemRegistry.SEASONAL_CALENDAR.get()), (ResourceLocation)new ResourceLocation(LegendarySurvivalOverhaul.MOD_ID, "time"), (ItemPropertyFunction)new SeasonalCalendarTimeProperty());
                ItemProperties.register((Item)((Item)ItemRegistry.SEASONAL_CALENDAR.get()), (ResourceLocation)new ResourceLocation(LegendarySurvivalOverhaul.MOD_ID, "seasontype"), (ItemPropertyFunction)new SeasonalCalendarSeasonTypeProperty());
            }
        }
    }
}

