/*
 * Decompiled with CFR 0.152.
 */
package net.irisshaders.iris.compat.sodium.impl.vertex_format.terrain_xhfp;

import me.jellysquid.mods.sodium.client.render.chunk.terrain.material.Material;
import me.jellysquid.mods.sodium.client.render.chunk.vertex.format.ChunkVertexEncoder;
import net.irisshaders.iris.compat.sodium.impl.block_context.BlockContextHolder;
import net.irisshaders.iris.compat.sodium.impl.block_context.ContextAwareVertexWriter;
import net.irisshaders.iris.compat.sodium.impl.vertex_format.terrain_xhfp.QuadViewTerrain;
import net.irisshaders.iris.compat.sodium.impl.vertex_format.terrain_xhfp.XHFPModelVertexType;
import net.irisshaders.iris.vertices.ExtendedDataHelper;
import net.irisshaders.iris.vertices.NormI8;
import net.irisshaders.iris.vertices.NormalHelper;
import org.joml.Vector3f;
import org.lwjgl.system.MemoryUtil;

public class XHFPTerrainVertex
implements ChunkVertexEncoder,
ContextAwareVertexWriter {
    private final QuadViewTerrain quad = new QuadViewTerrain();
    private final Vector3f normal = new Vector3f();
    private BlockContextHolder contextHolder;
    private boolean flipUpcomingNormal;

    @Override
    public void iris$setContextHolder(BlockContextHolder holder) {
        this.contextHolder = holder;
    }

    @Override
    public void flipUpcomingQuadNormal() {
        this.flipUpcomingNormal = true;
    }

    public long write(long ptr, Material material, ChunkVertexEncoder.Vertex[] vertices, int section) {
        this.quad.set(vertices);
        float texCentroidU = 0.0f;
        float texCentroidV = 0.0f;
        for (ChunkVertexEncoder.Vertex vertex : vertices) {
            texCentroidU += vertex.u;
            texCentroidV += vertex.v;
        }
        int midUV = XHFPModelVertexType.encodeTextureOld(texCentroidU *= 0.25f, texCentroidV *= 0.25f);
        if (this.flipUpcomingNormal) {
            NormalHelper.computeFaceNormalFlipped(this.normal, this.quad);
            this.flipUpcomingNormal = false;
        } else {
            NormalHelper.computeFaceNormal(this.normal, this.quad);
        }
        int normalV = NormI8.pack(this.normal);
        int tangent = NormalHelper.computeTangent(this.normal.x, this.normal.y, this.normal.z, this.quad);
        for (int i = 0; i < 4; ++i) {
            ChunkVertexEncoder.Vertex vertex = vertices[i];
            int x = XHFPModelVertexType.quantizePosition(vertex.x);
            int y = XHFPModelVertexType.quantizePosition(vertex.y);
            int z = XHFPModelVertexType.quantizePosition(vertex.z);
            int u = XHFPModelVertexType.encodeTexture(texCentroidU, vertex.u);
            int v = XHFPModelVertexType.encodeTexture(texCentroidV, vertex.v);
            int light = XHFPModelVertexType.encodeLight(vertex.light);
            MemoryUtil.memPutInt((long)(ptr + 0L), (int)XHFPModelVertexType.packPositionHi(x, y, z));
            MemoryUtil.memPutInt((long)(ptr + 4L), (int)XHFPModelVertexType.packPositionLo(x, y, z));
            MemoryUtil.memPutInt((long)(ptr + 8L), (int)vertex.color);
            MemoryUtil.memPutInt((long)(ptr + 12L), (int)XHFPModelVertexType.packTexture(u, v));
            MemoryUtil.memPutInt((long)(ptr + 16L), (int)XHFPModelVertexType.packLightAndData(light, material.bits(), section));
            MemoryUtil.memPutInt((long)(ptr + 20L), (int)midUV);
            MemoryUtil.memPutInt((long)(ptr + 24L), (int)tangent);
            MemoryUtil.memPutInt((long)(ptr + 28L), (int)normalV);
            MemoryUtil.memPutShort((long)(ptr + 32L), (short)this.contextHolder.blockId);
            MemoryUtil.memPutShort((long)(ptr + 34L), (short)this.contextHolder.renderType);
            MemoryUtil.memPutInt((long)(ptr + 36L), (int)(this.contextHolder.ignoreMidBlock ? 0 : ExtendedDataHelper.computeMidBlock(vertex.x, vertex.y, vertex.z, this.contextHolder.localPosX, this.contextHolder.localPosY, this.contextHolder.localPosZ)));
            MemoryUtil.memPutByte((long)(ptr + 39L), (byte)this.contextHolder.lightValue);
            ptr += 40L;
        }
        return ptr;
    }
}

