/*
 * Decompiled with CFR 0.152.
 */
package com.raiiiden.warborn.mixin.client;

import com.raiiiden.warborn.client.event.ClientKeyEvents;
import com.raiiiden.warborn.common.item.WBArmorItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PlayerModel.class})
public abstract class PlayerModelMixin<T extends LivingEntity> {
    @Inject(method={"setupAnim(Lnet/minecraft/world/entity/LivingEntity;FFFFF)V"}, at={@At(value="TAIL")})
    public void warborn$injectArmAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, CallbackInfo ci) {
        WBArmorItem hi;
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        Minecraft mc = Minecraft.m_91087_();
        if (player == mc.f_91075_ && mc.f_91066_.m_92176_().m_90612_()) {
            return;
        }
        ItemStack helmet = player.m_6844_(EquipmentSlot.HEAD);
        if (!helmet.m_204117_(ClientKeyEvents.HAS_TOGGLE_TAG)) {
            return;
        }
        int animTick = player.getPersistentData().m_128451_("NVG_ANIM_TICK");
        if (animTick <= 0) {
            return;
        }
        PlayerModel model = (PlayerModel)this;
        if (animTick == 1) {
            player.getPersistentData().m_128350_("NVG_ANIM_START_X", model.f_102812_.f_104203_);
            player.getPersistentData().m_128350_("NVG_ANIM_START_Y", model.f_102812_.f_104204_);
        }
        float startX = player.getPersistentData().m_128457_("NVG_ANIM_START_X");
        float startY = player.getPersistentData().m_128457_("NVG_ANIM_START_Y");
        float duration = 16.0f;
        float half = 8.0f;
        float progress = (float)animTick <= half ? (float)animTick / half : (16.0f - (float)animTick) / half;
        progress = PlayerModelMixin.cubicEase(progress);
        Item item = helmet.m_41720_();
        float baseRot = item instanceof WBArmorItem && (hi = (WBArmorItem)item).isTopOpen(helmet) ? -160.0f : -130.0f;
        float targetX = (float)Math.toRadians(headPitch + baseRot);
        targetX = PlayerModelMixin.clamp(targetX, (float)Math.toRadians(-220.0), (float)Math.toRadians(130.0));
        float newX = startX + (targetX - startX) * progress;
        float maxSway = 30.0f;
        float targetY = (float)Math.toRadians(netHeadYaw * 0.5f);
        targetY = PlayerModelMixin.clamp(targetY, (float)Math.toRadians(-maxSway), (float)Math.toRadians(maxSway));
        float newY = startY + (targetY - startY) * progress;
        float newZ = 0.0f;
        model.f_102812_.f_104203_ = newX;
        model.f_102812_.f_104204_ = newY;
        model.f_102812_.f_104205_ = newZ;
        model.f_103374_.f_104203_ = newX;
        model.f_103374_.f_104204_ = newY;
        model.f_103374_.f_104205_ = newZ;
    }

    private static float clamp(float value, float min, float max) {
        return Math.max(min, Math.min(max, value));
    }

    private static float cubicEase(float t) {
        return t * t * (3.0f - 2.0f * t);
    }
}

