/*
 * Decompiled with CFR 0.152.
 */
package com.raiiiden.warborn.mixin;

import com.raiiiden.warborn.common.item.WBArmorItem;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.entity.ReloadState;
import com.tacz.guns.api.item.IAmmo;
import com.tacz.guns.api.item.IAmmoBox;
import com.tacz.guns.api.item.gun.AbstractGunItem;
import com.tacz.guns.entity.shooter.ShooterDataHolder;
import com.tacz.guns.resource.index.CommonGunIndex;
import com.tacz.guns.resource.pojo.data.gun.GunData;
import com.tacz.guns.util.AttachmentDataUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(targets={"com.tacz.guns.item.ModernKineticGunItem"}, remap=false)
public class ChestplateTickReloadHoldMixin {
    @Inject(method={"tickReload"}, at={@At(value="RETURN")}, cancellable=true)
    private void warborn$holdFeedingWhenChestplateHasAmmo(ShooterDataHolder dataHolder, ItemStack gunItem, LivingEntity shooter, CallbackInfoReturnable<ReloadState> cir) {
        int max;
        ReloadState out = (ReloadState)cir.getReturnValue();
        ReloadState.StateType prev = dataHolder.reloadStateType;
        if (prev != ReloadState.StateType.EMPTY_RELOAD_FEEDING && prev != ReloadState.StateType.TACTICAL_RELOAD_FEEDING) {
            return;
        }
        if (out.getStateType() != ReloadState.StateType.NOT_RELOADING) {
            return;
        }
        Item item = gunItem.m_41720_();
        if (!(item instanceof AbstractGunItem)) {
            return;
        }
        AbstractGunItem gun = (AbstractGunItem)item;
        CommonGunIndex idx = TimelessAPI.getCommonGunIndex((ResourceLocation)gun.getGunId(gunItem)).orElse(null);
        if (idx == null) {
            return;
        }
        int current = gun.getCurrentAmmoCount(gunItem);
        if (current >= (max = AttachmentDataUtils.getAmmoCountWithAttachment((ItemStack)gunItem, (GunData)idx.getGunData()))) {
            return;
        }
        if (!(shooter instanceof Player)) {
            return;
        }
        Player p = (Player)shooter;
        ItemStack chest = p.m_150109_().m_36052_(2);
        if (!(chest.m_41720_() instanceof WBArmorItem) || !WBArmorItem.isChestplateItem(chest)) {
            return;
        }
        boolean hasChestAmmo = chest.getCapability(ForgeCapabilities.ITEM_HANDLER).map(h -> {
            for (int i = 0; i < h.getSlots(); ++i) {
                IAmmoBox ib;
                IAmmo ia;
                ItemStack s = h.getStackInSlot(i);
                if (s.m_41619_()) continue;
                Item patt2501$temp = s.m_41720_();
                if (patt2501$temp instanceof IAmmo && (ia = (IAmmo)patt2501$temp).isAmmoOfGun(gunItem, s)) {
                    return true;
                }
                Item patt2598$temp = s.m_41720_();
                if (!(patt2598$temp instanceof IAmmoBox) || !(ib = (IAmmoBox)patt2598$temp).isAmmoBoxOfGun(gunItem, s) || ib.getAmmoCount(s) <= 0) continue;
                return true;
            }
            return false;
        }).orElse(false);
        if (!hasChestAmmo) {
            return;
        }
        ReloadState keep = new ReloadState();
        keep.setStateType(prev);
        keep.setCountDown(50L);
        cir.setReturnValue((Object)keep);
    }
}

