/*
 * Decompiled with CFR 0.152.
 */
package com.raiiiden.warborn.common.util;

import com.raiiiden.warborn.common.object.capability.PlateHolderProvider;
import com.raiiiden.warborn.common.object.plate.MaterialType;
import com.raiiiden.warborn.common.object.plate.Plate;
import com.raiiiden.warborn.common.object.plate.ProtectionTier;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.ItemStack;

public final class PlateTooltip {
    private static final String KEY_PREFIX_TOOLTIP = "tooltip.warborn.";
    private static final String KEY_PREFIX_ITEM = "item.warborn.";
    private static final String KEY_PLATE_RATING = "tooltip.warborn.plate.rating";
    private static final String KEY_PLATE_MATERIAL = "tooltip.warborn.plate.material";
    private static final String KEY_PLATE_DURABILITY = "tooltip.warborn.plate.durability";
    private static final String KEY_PLATE_MOVEMENT = "tooltip.warborn.plate.movement";
    private static final String KEY_PLATE_MOVEMENT_SUFFIX = "tooltip.warborn.plate.movement.suffix";
    private static final String KEY_PLATE_VEST_ONLY = "tooltip.warborn.plate.vest_only";
    private static final String KEY_VEST_COMPATIBLE = "tooltip.warborn.vest.compatible";
    private static final String KEY_VEST_FRONT = "tooltip.warborn.vest.front";
    private static final String KEY_VEST_BACK = "tooltip.warborn.vest.back";
    private static final String KEY_VEST_SPEED = "tooltip.warborn.vest.speed";

    private PlateTooltip() {
    }

    public static void addPlate(List<Component> tip, ProtectionTier tier, MaterialType material, ItemStack stack) {
        int maxDur = material.getBaseDurability();
        int curDur = maxDur - stack.m_41773_();
        tip.add((Component)Component.m_237110_((String)KEY_PLATE_RATING, (Object[])new Object[]{tier.getDisplayName()}).m_130940_(ChatFormatting.GRAY));
        tip.add((Component)Component.m_237110_((String)KEY_PLATE_MATERIAL, (Object[])new Object[]{material.getDisplayName()}).m_130940_(ChatFormatting.GRAY));
        Style durabilityStyle = PlateTooltip.getDurabilityColor(curDur, maxDur);
        tip.add((Component)Component.m_237110_((String)KEY_PLATE_DURABILITY, (Object[])new Object[]{Component.m_237113_((String)String.valueOf(curDur)).m_130948_(durabilityStyle), Component.m_237113_((String)String.valueOf(maxDur)).m_130940_(ChatFormatting.GRAY)}).m_130940_(ChatFormatting.GRAY));
        float speed = material.getSpeedModifier();
        String pct = String.format("%+.1f%%", Float.valueOf(speed * 100.0f));
        ChatFormatting speedColour = speed >= 0.0f ? ChatFormatting.GREEN : ChatFormatting.RED;
        tip.add((Component)Component.m_237110_((String)KEY_PLATE_MOVEMENT, (Object[])new Object[]{Component.m_237113_((String)pct).m_130940_(speedColour)}).m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237115_((String)KEY_PLATE_MOVEMENT_SUFFIX).m_130940_(ChatFormatting.DARK_GRAY)));
        tip.add((Component)Component.m_237115_((String)KEY_PLATE_VEST_ONLY).m_130940_(ChatFormatting.RED));
    }

    public static void addChestplate(List<Component> list, ItemStack stack) {
        list.add((Component)Component.m_237115_((String)KEY_VEST_COMPATIBLE).m_130938_(style -> style.m_178520_(0xFFAA00)));
        stack.getCapability(PlateHolderProvider.CAP).ifPresent(cap -> {
            Plate back;
            float totalSpeed = 0.0f;
            int count = 0;
            Plate front = cap.hasFrontPlate() ? cap.getFrontPlate() : null;
            Plate plate = back = cap.hasBackPlate() ? cap.getBackPlate() : null;
            if (front != null && !front.isBroken()) {
                list.add((Component)Component.m_237110_((String)KEY_VEST_FRONT, (Object[])new Object[]{front.getMaterial().getDisplayName(), front.getTier().getDisplayName()}).m_130940_(ChatFormatting.GRAY));
                totalSpeed += front.getSpeedModifier();
                ++count;
            }
            if (back != null && !back.isBroken()) {
                list.add((Component)Component.m_237110_((String)KEY_VEST_BACK, (Object[])new Object[]{back.getMaterial().getDisplayName(), back.getTier().getDisplayName()}).m_130940_(ChatFormatting.GRAY));
                totalSpeed += back.getSpeedModifier();
                ++count;
            }
            if (count > 0) {
                float avg = totalSpeed / (float)count;
                String pct = String.format("%+.1f%%", Float.valueOf(avg * 100.0f));
                ChatFormatting colour = avg >= 0.0f ? ChatFormatting.GREEN : ChatFormatting.RED;
                list.add((Component)Component.m_237110_((String)KEY_VEST_SPEED, (Object[])new Object[]{Component.m_237113_((String)pct).m_130940_(colour)}).m_130940_(ChatFormatting.GRAY));
            }
        });
    }

    private static Style getDurabilityColor(int current, int max) {
        double percentage = (double)current / (double)max;
        if (percentage > 0.6) {
            return Style.f_131099_.m_131157_(ChatFormatting.GREEN);
        }
        if (percentage > 0.25) {
            return Style.f_131099_.m_131157_(ChatFormatting.YELLOW);
        }
        return Style.f_131099_.m_131157_(ChatFormatting.RED);
    }
}

