/*
 * Decompiled with CFR 0.152.
 */
package com.raiiiden.warborn.common.util;

import com.raiiiden.warborn.client.shader.ClientVisionState;
import com.raiiiden.warborn.client.shader.ShaderRegistry;
import com.raiiiden.warborn.common.item.WBArmorItem;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HelmetVisionHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String NVG_SHADER_ID = "nvg";
    private static final String SIMPLE_NVG_SHADER_ID = "snvg";
    private static final String THERMAL_SHADER_ID = "tvg";
    private static final String DIGITAL_SHADER_ID = "dvg";
    private static final boolean DEBUG_MODE = false;

    public static boolean isAllowedHelmet(ItemStack helmet) {
        return WBArmorItem.hasVisionCapability(helmet);
    }

    public static String getShaderIdFromVisionType(String visionType) {
        return switch (visionType) {
            case NVG_SHADER_ID -> NVG_SHADER_ID;
            case "simple_nvg" -> SIMPLE_NVG_SHADER_ID;
            case "thermal" -> THERMAL_SHADER_ID;
            case "digital" -> DIGITAL_SHADER_ID;
            default -> "";
        };
    }

    public static String getActiveVisionType(ItemStack helmet) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return "";
        }
        return ClientVisionState.getActive(player.m_20148_());
    }

    public static void setActiveVisionType(ItemStack helmet, String visionType) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        ClientVisionState.setActive(player.m_20148_(), visionType);
    }

    public static boolean hasVisionType(ItemStack helmet, String visionType) {
        if (!HelmetVisionHandler.isAllowedHelmet(helmet)) {
            return false;
        }
        if (helmet.m_41783_() != null && helmet.m_41783_().m_128441_(visionType)) {
            return true;
        }
        if (helmet.m_41619_() || !(helmet.m_41720_() instanceof ArmorItem)) {
            return false;
        }
        ResourceLocation tagId = new ResourceLocation("fracturepoint", "has_" + visionType);
        boolean hasTag = helmet.m_204117_(TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)tagId));
        return hasTag;
    }

    public static boolean toggleVision(Player player) {
        ItemStack helmet = player.m_6844_(EquipmentSlot.HEAD);
        LOGGER.info("TOGGLE VISION called with helmet: {}", (Object)helmet);
        if (!HelmetVisionHandler.isAllowedHelmet(helmet)) {
            LOGGER.debug("No suitable helmet equipped");
            return false;
        }
        String currentType = HelmetVisionHandler.getActiveVisionType(helmet);
        if (!currentType.isEmpty()) {
            LOGGER.info("Disabling vision mode: {}", (Object)currentType);
            HelmetVisionHandler.disableVisionShader(currentType);
            HelmetVisionHandler.setActiveVisionType(helmet, "");
            return true;
        }
        String primaryVisionType = HelmetVisionHandler.getPrimaryVisionType(helmet);
        if (!primaryVisionType.isEmpty()) {
            LOGGER.info("*** ACTIVATING VISION: {} ***", (Object)primaryVisionType);
            HelmetVisionHandler.enableVisionShader(primaryVisionType);
            HelmetVisionHandler.setActiveVisionType(helmet, primaryVisionType);
            LOGGER.info("Enabled vision mode: {}", (Object)primaryVisionType);
            String shaderId = HelmetVisionHandler.visionTypeToShaderId(primaryVisionType);
            boolean enabled = ShaderRegistry.getInstance().isShaderForceEnabled(shaderId);
            LOGGER.info("Shader {} force enabled: {}", (Object)shaderId, (Object)enabled);
            return true;
        }
        LOGGER.debug("No vision types available on helmet");
        return false;
    }

    private static String getPrimaryVisionType(ItemStack helmet) {
        if (HelmetVisionHandler.hasVisionType(helmet, "digital")) {
            LOGGER.info("Helmet has digital vision capability");
            return "digital";
        }
        if (HelmetVisionHandler.hasVisionType(helmet, "thermal")) {
            LOGGER.info("Helmet has thermal vision capability");
            return "thermal";
        }
        if (HelmetVisionHandler.hasVisionType(helmet, NVG_SHADER_ID)) {
            LOGGER.info("Helmet has standard NVG capability");
            return NVG_SHADER_ID;
        }
        if (HelmetVisionHandler.hasVisionType(helmet, "simple_nvg")) {
            LOGGER.info("Helmet has simple NVG capability");
            return "simple_nvg";
        }
        LOGGER.warn("Helmet has no vision capabilities");
        return "";
    }

    private static String visionTypeToShaderId(String visionType) {
        return switch (visionType) {
            case NVG_SHADER_ID -> NVG_SHADER_ID;
            case "simple_nvg" -> SIMPLE_NVG_SHADER_ID;
            case "thermal" -> THERMAL_SHADER_ID;
            case "digital" -> DIGITAL_SHADER_ID;
            default -> "";
        };
    }

    private static void enableVisionShader(String visionType) {
        HelmetVisionHandler.disableAllShaders();
        String shaderId = HelmetVisionHandler.visionTypeToShaderId(visionType);
        boolean result = ShaderRegistry.getInstance().setShaderEnabled(shaderId, true);
        Set<String> allShaders = ShaderRegistry.getInstance().getRegisteredShaderIds();
        if (allShaders.contains(shaderId)) {
            boolean shaderActive = ShaderRegistry.getInstance().isShaderForceEnabled(shaderId);
            LOGGER.info("After enabling: shader {} is force enabled: {}", (Object)shaderId, (Object)shaderActive);
        } else {
            LOGGER.error("SHADER NOT FOUND: {} is not registered!", (Object)shaderId);
        }
    }

    private static void disableVisionShader(String visionType) {
        String shaderId = HelmetVisionHandler.visionTypeToShaderId(visionType);
        ShaderRegistry.getInstance().setShaderEnabled(shaderId, false);
    }

    private static void disableAllShaders() {
        ShaderRegistry.getInstance().setShaderEnabled(NVG_SHADER_ID, false);
        ShaderRegistry.getInstance().setShaderEnabled(SIMPLE_NVG_SHADER_ID, false);
        ShaderRegistry.getInstance().setShaderEnabled(THERMAL_SHADER_ID, false);
        ShaderRegistry.getInstance().setShaderEnabled(DIGITAL_SHADER_ID, false);
    }

    public static boolean isVisionActive(Minecraft mc, String visionType) {
        if (mc.f_91074_ == null) {
            return false;
        }
        return ClientVisionState.isActive(mc.f_91074_.m_20148_(), visionType);
    }

    public static String getDebugInfo(Player player) {
        StringBuilder info = new StringBuilder();
        info.append("=== Vision System Debug ===\n");
        ItemStack helmet = player.m_6844_(EquipmentSlot.HEAD);
        info.append("Current helmet: ").append(helmet.m_41619_() ? "NONE" : helmet.m_41611_().getString()).append("\n");
        if (!helmet.m_41619_()) {
            info.append("Is allowed helmet: ").append(HelmetVisionHandler.isAllowedHelmet(helmet)).append("\n");
            info.append("Has NVG: ").append(HelmetVisionHandler.hasVisionType(helmet, NVG_SHADER_ID)).append("\n");
            info.append("Has Simple NVG: ").append(HelmetVisionHandler.hasVisionType(helmet, "simple_nvg")).append("\n");
            info.append("Has Thermal: ").append(HelmetVisionHandler.hasVisionType(helmet, "thermal")).append("\n");
            info.append("Has Digital: ").append(HelmetVisionHandler.hasVisionType(helmet, "digital")).append("\n");
            String activeType = HelmetVisionHandler.getActiveVisionType(helmet);
            info.append("Active vision: ").append(activeType.isEmpty() ? "NONE" : activeType).append("\n");
        }
        info.append("\nRegistered shaders:\n");
        Set<String> shaderIds = ShaderRegistry.getInstance().getRegisteredShaderIds();
        for (String id : shaderIds) {
            boolean active = ShaderRegistry.getInstance().isShaderActive(id);
            info.append("- ").append(id).append(": ").append(active ? "ACTIVE" : "inactive").append("\n");
        }
        return info.toString();
    }
}

