/*
 * Decompiled with CFR 0.152.
 */
package com.raiiiden.warborn.common.util;

import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.util.Mth;

public class Color {
    public static final Color DEFAULT = new Color(51, 51, 51);
    public static final Color STEEL = new Color(80, 80, 80);
    public static final Color CERAMIC = new Color(255, 255, 255);
    public static final Color SOFT_KEVLAR = new Color(212, 212, 212);
    public static final Color POLYETHYLENE = new Color(85, 170, 85);
    public static final Color COMPOSITE = new Color(255, 170, 0);
    public static final Color TIER_IIA = new Color(159, 197, 232);
    public static final Color TIER_II = new Color(111, 168, 220);
    public static final Color TIER_IIIA = new Color(61, 133, 198);
    public static final Color TIER_III = new Color(11, 83, 148);
    public static final Color TIER_IV = new Color(7, 55, 99);
    private final int r;
    private final int g;
    private final int b;
    private final int rgb;

    public Color(int r, int g, int b) {
        this.r = Mth.m_14045_((int)r, (int)0, (int)255);
        this.g = Mth.m_14045_((int)g, (int)0, (int)255);
        this.b = Mth.m_14045_((int)b, (int)0, (int)255);
        this.rgb = r << 16 | g << 8 | b;
    }

    public Color(int rgb) {
        this.rgb = rgb;
        this.r = rgb >> 16 & 0xFF;
        this.g = rgb >> 8 & 0xFF;
        this.b = rgb & 0xFF;
    }

    public static Color fromHex(String hex) {
        if (hex.startsWith("#")) {
            hex = hex.substring(1);
        }
        try {
            int rgb = Integer.parseInt(hex, 16);
            return new Color(rgb);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid hex color: " + hex, e);
        }
    }

    public int getRed() {
        return this.r;
    }

    public int getGreen() {
        return this.g;
    }

    public int getBlue() {
        return this.b;
    }

    public int getRGB() {
        return this.rgb;
    }

    public int getARGB() {
        return 0xFF000000 | this.rgb;
    }

    public String toHexString() {
        return String.format("#%06X", this.rgb);
    }

    public Color lighter(float factor) {
        factor = Mth.m_14036_((float)factor, (float)0.0f, (float)1.0f);
        int newR = this.r + (int)((float)(255 - this.r) * factor);
        int newG = this.g + (int)((float)(255 - this.g) * factor);
        int newB = this.b + (int)((float)(255 - this.b) * factor);
        return new Color(newR, newG, newB);
    }

    public Color darker(float factor) {
        factor = Mth.m_14036_((float)factor, (float)0.0f, (float)1.0f);
        int newR = (int)((float)this.r * (1.0f - factor));
        int newG = (int)((float)this.g * (1.0f - factor));
        int newB = (int)((float)this.b * (1.0f - factor));
        return new Color(newR, newG, newB);
    }

    public Color blend(Color other, float ratio) {
        ratio = Mth.m_14036_((float)ratio, (float)0.0f, (float)1.0f);
        int newR = (int)((float)this.r * (1.0f - ratio) + (float)other.r * ratio);
        int newG = (int)((float)this.g * (1.0f - ratio) + (float)other.g * ratio);
        int newB = (int)((float)this.b * (1.0f - ratio) + (float)other.b * ratio);
        return new Color(newR, newG, newB);
    }

    public Component colorize(String text) {
        return Component.m_237113_((String)text).m_130948_(Style.f_131099_.m_178520_(this.getRGB()));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Color color = (Color)obj;
        return this.rgb == color.rgb;
    }

    public int hashCode() {
        return this.rgb;
    }

    public String toString() {
        return String.format("Color[r=%d,g=%d,b=%d,hex=%s]", this.r, this.g, this.b, this.toHexString());
    }
}

