/*
 * Decompiled with CFR 0.152.
 */
package com.raiiiden.warborn.common.object.plate;

import com.raiiiden.warborn.common.util.Color;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ProtectionTier {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Map<String, ProtectionTier> REGISTRY = new HashMap<String, ProtectionTier>();
    private static final String KEY_PREFIX_TIER = "tier.warborn.";
    public static final ProtectionTier DEFAULT = ProtectionTier.register("default", "tier.warborn.default", 0, 0, 0.0f, 0.0f, 0.0f, Color.DEFAULT);
    public static final ProtectionTier LEVEL_IIA = ProtectionTier.register("level_iia", "tier.warborn.level_iia", 1, 3, 0.7f, 0.2f, 0.05f, Color.TIER_IIA);
    public static final ProtectionTier LEVEL_II = ProtectionTier.register("level_ii", "tier.warborn.level_ii", 3, 5, 0.8f, 0.35f, 0.12f, Color.TIER_II);
    public static final ProtectionTier LEVEL_IIIA = ProtectionTier.register("level_iiia", "tier.warborn.level_iiia", 5, 7, 0.88f, 0.6f, 0.22f, Color.TIER_IIIA);
    public static final ProtectionTier LEVEL_III = ProtectionTier.register("level_iii", "tier.warborn.level_iii", 7, 10, 0.95f, 0.8f, 0.4f, Color.TIER_III);
    public static final ProtectionTier LEVEL_IV = ProtectionTier.register("level_iv", "tier.warborn.level_iv", 10, 15, 1.0f, 0.95f, 0.5f, Color.TIER_IV);
    private final String internalName;
    private final String translationKey;
    private final int lowerThreshold;
    private final int upperThreshold;
    private final float thresholdProtection;
    private final float partialProtection;
    private final float minimalProtection;
    private final Color color;

    private ProtectionTier(String internalName, String translationKey, int lowerThreshold, int upperThreshold, float thresholdProtection, float partialProtection, float minimalProtection, Color color) {
        this.internalName = internalName;
        this.translationKey = translationKey;
        this.lowerThreshold = lowerThreshold;
        this.upperThreshold = upperThreshold;
        this.thresholdProtection = thresholdProtection;
        this.partialProtection = partialProtection;
        this.minimalProtection = minimalProtection;
        this.color = color;
    }

    public static ProtectionTier valueOf(String name) {
        ProtectionTier tier = REGISTRY.get(name.toLowerCase());
        if (tier == null) {
            LOGGER.warn("Unknown ProtectionTier name: {}, defaulting to LEVEL_III", (Object)name);
            return LEVEL_III;
        }
        return tier;
    }

    public static ProtectionTier register(String internalName, String translationKey, int lowerThreshold, int upperThreshold, float thresholdProtection, float partialProtection, float minimalProtection, Color color) {
        String key = internalName.toLowerCase();
        if (REGISTRY.containsKey(key)) {
            throw new IllegalArgumentException("Already registered tier with internal name: " + internalName);
        }
        ProtectionTier tier = new ProtectionTier(internalName, translationKey, lowerThreshold, upperThreshold, thresholdProtection, partialProtection, minimalProtection, color);
        REGISTRY.put(key, tier);
        return tier;
    }

    public String getInternalName() {
        return this.internalName;
    }

    @Deprecated
    public String name() {
        return this.internalName.toUpperCase();
    }

    public Component getDisplayName() {
        MutableComponent textComponent = Component.m_237115_((String)this.translationKey);
        int rgbColor = this.color.getRGB();
        return textComponent.m_6881_().m_130938_(style -> style.m_131148_(TextColor.m_131266_((int)rgbColor)));
    }

    public Color getColor() {
        return this.color;
    }

    public int getLowerThreshold() {
        return this.lowerThreshold;
    }

    public int getUpperThreshold() {
        return this.upperThreshold;
    }

    public float getThresholdProtection() {
        return this.thresholdProtection;
    }

    public float getPartialProtection() {
        return this.partialProtection;
    }

    public float getMinimalProtection() {
        return this.minimalProtection;
    }
}

