/*
 * Decompiled with CFR 0.152.
 */
package com.raiiiden.warborn.common.object.plate;

import com.raiiiden.warborn.common.object.plate.MaterialType;
import com.raiiiden.warborn.common.object.plate.ProtectionTier;
import net.minecraft.nbt.CompoundTag;

public class Plate {
    private final ProtectionTier tier;
    private final MaterialType material;
    private final float maxDurability;
    private float currentDurability;

    public Plate(ProtectionTier tier, MaterialType material) {
        this.tier = tier;
        this.material = material;
        this.currentDurability = this.maxDurability = (float)material.getBaseDurability();
    }

    public Plate(CompoundTag tag) {
        this.tier = ProtectionTier.valueOf(tag.m_128461_("Tier"));
        this.material = MaterialType.valueOf(tag.m_128461_("Material"));
        this.maxDurability = tag.m_128457_("MaxDurability");
        this.currentDurability = tag.m_128457_("CurrentDurability");
    }

    public CompoundTag save() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("Tier", this.tier.name());
        tag.m_128359_("Material", this.material.name());
        tag.m_128350_("MaxDurability", this.maxDurability);
        tag.m_128350_("CurrentDurability", this.currentDurability);
        return tag;
    }

    public ProtectionTier getTier() {
        return this.tier;
    }

    public MaterialType getMaterial() {
        return this.material;
    }

    public float getCurrentDurability() {
        return this.currentDurability;
    }

    public void setCurrentDurability(float durability) {
        this.currentDurability = Math.max(0.0f, Math.min(durability, this.maxDurability));
    }

    public float getMaxDurability() {
        return this.maxDurability;
    }

    public float getIntegrity() {
        return this.currentDurability / this.maxDurability;
    }

    public boolean isBroken() {
        return this.currentDurability <= 0.0f;
    }

    public float calculateDamageReduction(float incomingDamage) {
        if (this.isBroken()) {
            return 0.0f;
        }
        float durabilityRatio = this.getCurrentDurability() / this.getMaxDurability();
        float baseProtection = incomingDamage < (float)this.tier.getLowerThreshold() ? this.tier.getThresholdProtection() : (incomingDamage < (float)this.tier.getUpperThreshold() ? this.tier.getPartialProtection() : this.tier.getMinimalProtection());
        if (durabilityRatio >= 0.05f) {
            return baseProtection;
        }
        return baseProtection * 0.2f;
    }

    public void damage(float damageAmount) {
        if (this.isBroken()) {
            return;
        }
        this.currentDurability = Math.max(0.0f, this.material.calculateRemainingDurability(this.currentDurability, damageAmount));
    }

    public float getSpeedModifier() {
        return this.material.getSpeedModifier();
    }
}

