/*
 * Decompiled with CFR 0.152.
 */
package com.raiiiden.warborn.common.object.plate;

import com.raiiiden.warborn.common.util.Color;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MaterialType {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Map<String, MaterialType> REGISTRY = new HashMap<String, MaterialType>();
    private static final String KEY_PREFIX_MATERIAL = "material.warborn.";
    public static final MaterialType DEFAULT = MaterialType.register("default", "material.warborn.default", 0, 0.0f, (durability, damage) -> Float.valueOf(durability.floatValue() - damage.floatValue()), (damagePercent, baseProtection) -> baseProtection, Color.DEFAULT);
    public static final MaterialType SOFT_KEVLAR = MaterialType.register("soft_kevlar", "material.warborn.soft_kevlar", 51, -0.015f, (durability, damage) -> Float.valueOf(durability.floatValue() - damage.floatValue()), (damagePercent, baseProtection) -> baseProtection, Color.SOFT_KEVLAR);
    public static final MaterialType STEEL = MaterialType.register("steel", "material.warborn.steel", 90, -0.075f, (durability, damage) -> Float.valueOf(durability.floatValue() - damage.floatValue()), (damagePercent, baseProtection) -> baseProtection, Color.STEEL);
    public static final MaterialType CERAMIC = MaterialType.register("ceramic", "material.warborn.ceramic", 61, -0.05f, (durability, damage) -> Float.valueOf(durability.floatValue() - damage.floatValue()), (damagePercent, baseProtection) -> baseProtection, Color.CERAMIC);
    public static final MaterialType POLYETHYLENE = MaterialType.register("polyethylene", "material.warborn.polyethylene", 75, -0.025f, (durability, damage) -> Float.valueOf(durability.floatValue() - damage.floatValue()), (damagePercent, baseProtection) -> baseProtection, Color.POLYETHYLENE);
    public static final MaterialType COMPOSITE = MaterialType.register("composite", "material.warborn.composite", 124, -0.06f, (durability, damage) -> Float.valueOf(durability.floatValue() - damage.floatValue()), (damagePercent, baseProtection) -> baseProtection, Color.COMPOSITE);
    private final String internalName;
    private final String translationKey;
    private final int baseDurability;
    private final float speedModifier;
    private final BiFunction<Float, Float, Float> durabilityConsumer;
    private final BiFunction<Float, Float, Float> protectionConsumer;
    private final Color color;

    private MaterialType(String internalName, String translationKey, int baseDurability, float speedModifier, BiFunction<Float, Float, Float> durabilityConsumer, BiFunction<Float, Float, Float> protectionConsumer, Color color) {
        this.internalName = internalName;
        this.translationKey = translationKey;
        this.baseDurability = baseDurability;
        this.speedModifier = speedModifier;
        this.durabilityConsumer = durabilityConsumer;
        this.protectionConsumer = protectionConsumer;
        this.color = color;
    }

    public static MaterialType valueOf(String name) {
        MaterialType material = REGISTRY.get(name.toLowerCase());
        if (material == null) {
            LOGGER.warn("Null material: {}, defaulting to STEEL", (Object)name);
            return STEEL;
        }
        return material;
    }

    public static MaterialType register(String internalName, String translationKey, int baseDurability, float speedModifier, BiFunction<Float, Float, Float> durabilityConsumer, BiFunction<Float, Float, Float> protectionConsumer, Color color) {
        String key = internalName.toLowerCase();
        if (REGISTRY.containsKey(key)) {
            throw new IllegalArgumentException("Already registered material with internal name: " + internalName + ", dummy...");
        }
        MaterialType material = new MaterialType(internalName, translationKey, baseDurability, speedModifier, durabilityConsumer, protectionConsumer, color);
        REGISTRY.put(key, material);
        return material;
    }

    public int getBaseDurability() {
        return this.baseDurability;
    }

    public float getSpeedModifier() {
        return this.speedModifier;
    }

    public String getInternalName() {
        return this.internalName;
    }

    public Component getDisplayName() {
        MutableComponent textComponent = Component.m_237115_((String)this.translationKey);
        int rgbColor = this.color.getRGB();
        return textComponent.m_6881_().m_130938_(style -> style.m_131148_(TextColor.m_131266_((int)rgbColor)));
    }

    @Deprecated
    public String name() {
        return this.internalName.toUpperCase();
    }

    public Color getColor() {
        return this.color;
    }

    public float calculateRemainingDurability(float currentDurability, float damageAmount) {
        return this.durabilityConsumer.apply(Float.valueOf(currentDurability), Float.valueOf(damageAmount)).floatValue();
    }

    public float calculateEffectiveProtection(float currentDurability, float maxDurability, float baseProtection) {
        float damagePercent = 1.0f - currentDurability / maxDurability;
        return this.protectionConsumer.apply(Float.valueOf(damagePercent), Float.valueOf(baseProtection)).floatValue();
    }
}

