/*
 * Decompiled with CFR 0.152.
 */
package com.raiiiden.warborn.common.object.capability;

import com.raiiiden.warborn.common.object.capability.PlateHolderCapability;
import com.raiiiden.warborn.common.object.plate.MaterialType;
import com.raiiiden.warborn.common.object.plate.Plate;
import com.raiiiden.warborn.common.object.plate.ProtectionTier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PlateHolderImpl
implements PlateHolderCapability {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ItemStack chestplate;

    public PlateHolderImpl(ItemStack chestplate) {
        this.chestplate = chestplate;
    }

    private CompoundTag getPlateData() {
        CompoundTag tag = this.chestplate.m_41784_();
        if (!tag.m_128441_("PlateData")) {
            tag.m_128365_("PlateData", (Tag)new CompoundTag());
        }
        return tag.m_128469_("PlateData");
    }

    private void setPlateData(CompoundTag plateData) {
        this.chestplate.m_41784_().m_128365_("PlateData", (Tag)plateData);
    }

    private Plate readPlate(String key) {
        CompoundTag plateData = this.getPlateData();
        if (plateData.m_128441_(key)) {
            return new Plate(plateData.m_128469_(key));
        }
        return null;
    }

    private void writePlate(String key, Plate plate) {
        CompoundTag plateData = this.getPlateData();
        if (plate != null) {
            plateData.m_128365_(key, (Tag)plate.save());
        } else {
            plateData.m_128473_(key);
        }
        this.setPlateData(plateData);
    }

    private void damagePlate(String key, float amount) {
        Plate plate = this.readPlate(key);
        if (plate != null && !plate.isBroken()) {
            plate.damage(amount);
            this.writePlate(key, plate);
            LOGGER.info("Damaged {}. Remaining: {}/{}", (Object)key, (Object)Float.valueOf(plate.getCurrentDurability()), (Object)Float.valueOf(plate.getMaxDurability()));
        }
    }

    @Override
    public boolean hasFrontPlate() {
        Plate plate = this.readPlate("FrontPlate");
        return plate != null && !plate.isBroken();
    }

    @Override
    public boolean hasBackPlate() {
        Plate plate = this.readPlate("BackPlate");
        return plate != null && !plate.isBroken();
    }

    @Override
    public Plate getFrontPlate() {
        return this.readPlate("FrontPlate");
    }

    @Override
    public Plate getBackPlate() {
        return this.readPlate("BackPlate");
    }

    @Override
    public void insertFrontPlate(Plate plate) {
        this.writePlate("FrontPlate", plate);
    }

    @Override
    public void insertBackPlate(Plate plate) {
        this.writePlate("BackPlate", plate);
    }

    @Override
    public void insertFrontPlate(ProtectionTier tier, MaterialType material) {
        this.insertFrontPlate(new Plate(tier, material));
    }

    @Override
    public void insertBackPlate(ProtectionTier tier, MaterialType material) {
        this.insertBackPlate(new Plate(tier, material));
    }

    @Override
    public void damageFrontPlate(float damageAmount) {
        this.damagePlate("FrontPlate", damageAmount);
    }

    @Override
    public void damageBackPlate(float damageAmount) {
        this.damagePlate("BackPlate", damageAmount);
    }

    @Override
    public void removeFrontPlate() {
        this.writePlate("FrontPlate", null);
    }

    @Override
    public void removeBackPlate() {
        this.writePlate("BackPlate", null);
    }
}

