/*
 * Decompiled with CFR 0.152.
 */
package com.raiiiden.warborn.common.object.capability;

import com.raiiiden.warborn.common.item.WBArmorItem;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class ChestplateBundleHandler
extends ItemStackHandler {
    public static final int MAX_SLOTS = 4;
    public static final int MAX_STACK_SIZE = 100;
    private final ItemStack chestplate;

    public ChestplateBundleHandler(ItemStack chestplate) {
        super(4);
        this.chestplate = chestplate;
        this.loadFromItem(chestplate);
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        return stack.m_41720_().m_142095_() && !WBArmorItem.isArmor(stack);
    }

    public int getStackLimit(int slot, @NotNull ItemStack stack) {
        int naturalMax = stack.m_41741_();
        return naturalMax > 1 ? 100 : 1;
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        return super.getStackInSlot(slot);
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        ItemStack result = super.extractItem(slot, amount, simulate);
        if (!simulate && !result.m_41619_()) {
            this.saveToItem(this.chestplate);
        }
        return result;
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        ItemStack result = super.insertItem(slot, stack, simulate);
        if (!simulate && !ItemStack.m_41728_((ItemStack)result, (ItemStack)stack)) {
            this.saveToItem(this.chestplate);
        }
        return result;
    }

    public void loadFromItem(ItemStack chestplate) {
        CompoundTag tag = chestplate.m_41784_();
        if (tag.m_128425_("Items", 9)) {
            CompoundTag container = new CompoundTag();
            container.m_128365_("Items", (Tag)tag.m_128437_("Items", 10));
            this.deserializeNBT(container);
        }
    }

    public void saveToItem(ItemStack chestplate) {
        CompoundTag container = this.serializeNBT();
        if (container.m_128425_("Items", 9)) {
            chestplate.m_41784_().m_128365_("Items", (Tag)container.m_128437_("Items", 10));
        }
    }

    public void clearEmptySlots() {
        for (int i = 0; i < this.getSlots(); ++i) {
            if (!this.getStackInSlot(i).m_41619_()) continue;
            this.setStackInSlot(i, ItemStack.f_41583_);
        }
        this.saveToItem(this.chestplate);
    }
}

