/*
 * Decompiled with CFR 0.152.
 */
package com.raiiiden.warborn.common.object;

import com.raiiiden.warborn.common.init.MenuTypeInit;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class BackpackMenu
extends AbstractContainerMenu {
    private final ItemStack itemStack;

    public BackpackMenu(int containerId, Inventory inventory, FriendlyByteBuf buf) {
        this(containerId, inventory, buf.m_130267_());
    }

    public BackpackMenu(int containerId, Inventory inventory, ItemStack itemStack) {
        super((MenuType)MenuTypeInit.BACKPACK_MENU.get(), containerId);
        int col;
        this.itemStack = itemStack;
        IItemHandler handler = (IItemHandler)itemStack.getCapability(ForgeCapabilities.ITEM_HANDLER).orElse(null);
        if (handler == null) {
            return;
        }
        int startX = 8;
        int backpackStartY = 18;
        for (int row = 0; row < 3; ++row) {
            for (col = 0; col < 9; ++col) {
                int index = col + row * 9;
                this.m_38897_((Slot)new SlotItemHandler(handler, index, startX + col * 18, backpackStartY + row * 18));
            }
        }
        int inventoryStartY = backpackStartY + 66;
        for (int row = 0; row < 3; ++row) {
            for (int col2 = 0; col2 < 9; ++col2) {
                this.m_38897_(new Slot((Container)inventory, col2 + row * 9 + 9, 8 + col2 * 18, inventoryStartY + row * 18));
            }
        }
        for (col = 0; col < 9; ++col) {
            this.m_38897_(new Slot((Container)inventory, col, 8 + col * 18, inventoryStartY + 58));
        }
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        if (!player.m_9236_().f_46443_) {
            this.itemStack.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(cap -> {
                if (cap instanceof INBTSerializable) {
                    INBTSerializable serializable = (INBTSerializable)cap;
                    CompoundTag tag = this.itemStack.m_41784_();
                    tag.m_128365_("BackpackCap", serializable.serializeNBT());
                    this.itemStack.m_41751_(tag);
                }
            });
        }
    }

    public boolean m_6875_(Player player) {
        return true;
    }

    public ItemStack m_7648_(Player player, int index) {
        IItemHandler handler = (IItemHandler)this.itemStack.getCapability(ForgeCapabilities.ITEM_HANDLER).orElse(null);
        if (handler == null) {
            return ItemStack.f_41583_;
        }
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack current = slot.m_7993_();
            itemstack = current.m_41777_();
            if (index < handler.getSlots() ? !this.m_38903_(current, handler.getSlots(), this.f_38839_.size(), true) : !this.m_38903_(current, 0, handler.getSlots(), false)) {
                return ItemStack.f_41583_;
            }
            if (current.m_41619_()) {
                slot.m_269060_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return itemstack;
    }
}

