/*
 * Decompiled with CFR 0.152.
 */
package com.raiiiden.warborn.common.network;

import com.raiiiden.warborn.common.item.ArmorPlateItem;
import com.raiiiden.warborn.common.network.ClientboundPhantomPlatePacket;
import com.raiiiden.warborn.common.network.ModNetworking;
import com.raiiiden.warborn.common.object.capability.PlateHolderProvider;
import com.raiiiden.warborn.common.object.plate.Plate;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import software.bernie.geckolib.animatable.GeoItem;

public class RemovePlatePacket {
    private final boolean front;

    public RemovePlatePacket(boolean front) {
        this.front = front;
    }

    public RemovePlatePacket(FriendlyByteBuf buf) {
        this.front = buf.readBoolean();
    }

    public static void handle(RemovePlatePacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Level patt1211$temp;
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null || !((patt1211$temp = player.m_9236_()) instanceof ServerLevel)) {
                return;
            }
            ServerLevel serverLevel = (ServerLevel)patt1211$temp;
            ItemStack main = player.m_21205_();
            ItemStack off = player.m_21206_();
            ItemStack chest = player.m_6844_(EquipmentSlot.CHEST);
            if (chest.m_41619_() || !ArmorPlateItem.isPlateCompatible(chest)) {
                return;
            }
            if (player.getPersistentData().m_128471_("warborn_processing_removal") || player.getPersistentData().m_128471_("warborn_processing_insert")) {
                player.m_5661_((Component)Component.m_237113_((String)"Please wait for current operation to complete").m_130940_(ChatFormatting.YELLOW), true);
                return;
            }
            if (main.m_41782_() && (main.m_41783_().m_128471_("warborn_pending_insert") || main.m_41783_().m_128471_("warborn_pending_remove"))) {
                return;
            }
            if (off.m_41782_() && (off.m_41783_().m_128471_("warborn_pending_insert") || off.m_41783_().m_128471_("warborn_pending_remove"))) {
                return;
            }
            Plate plateToRemove = chest.getCapability(PlateHolderProvider.CAP).map(cap -> packet.front ? cap.getFrontPlate() : cap.getBackPlate()).orElse(null);
            if (plateToRemove == null) {
                return;
            }
            player.getPersistentData().m_128379_("warborn_processing_removal", true);
            int animationDuration = 55;
            ClientboundPhantomPlatePacket phantomPacket = new ClientboundPhantomPlatePacket(plateToRemove, animationDuration, player.m_20148_());
            ModNetworking.PACKET_CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)phantomPacket);
            boolean isHoldingPlate = false;
            ItemStack heldPlate = null;
            if (main.m_41720_() instanceof ArmorPlateItem) {
                isHoldingPlate = true;
                heldPlate = main;
            } else if (off.m_41720_() instanceof ArmorPlateItem) {
                isHoldingPlate = true;
                heldPlate = off;
            }
            if (isHoldingPlate && heldPlate != null) {
                Item patt4367$temp = heldPlate.m_41720_();
                if (patt4367$temp instanceof ArmorPlateItem) {
                    ArmorPlateItem plateItem = (ArmorPlateItem)patt4367$temp;
                    plateItem.startRemoveAnimation((Player)player, heldPlate, packet.front, serverLevel);
                }
            } else {
                ItemStack tempPlate = ArmorPlateItem.createPlateWithHitsRemaining(plateToRemove.getTier(), plateToRemove.getMaterial(), (int)plateToRemove.getCurrentDurability());
                CompoundTag tag = tempPlate.m_41784_();
                tag.m_128379_("warborn_pending_remove", true);
                tag.m_128405_("warborn_remove_delay", 55);
                tag.m_128379_("warborn_remove_front", packet.front);
                GeoItem.getOrAssignId((ItemStack)tempPlate, (ServerLevel)serverLevel);
                Item patt5565$temp = tempPlate.m_41720_();
                if (patt5565$temp instanceof ArmorPlateItem) {
                    ArmorPlateItem plateItem = (ArmorPlateItem)patt5565$temp;
                    plateItem.startRemoveAnimation((Player)player, tempPlate, packet.front, serverLevel);
                }
                player.getPersistentData().m_128365_("warborn_temp_plate", (Tag)tempPlate.m_41739_(new CompoundTag()));
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeBoolean(this.front);
    }
}

