/*
 * Decompiled with CFR 0.152.
 */
package com.raiiiden.warborn.common.network;

import com.raiiiden.warborn.client.network.ClientPacketHandler;
import com.raiiiden.warborn.common.object.plate.Plate;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class ClientboundPhantomPlatePacket {
    private final String tierName;
    private final String materialName;
    private final float currentDurability;
    private final int durationTicks;
    private final UUID playerUUID;

    public ClientboundPhantomPlatePacket(Plate plate, int durationTicks, UUID playerUUID) {
        this.tierName = plate.getTier().name();
        this.materialName = plate.getMaterial().name();
        this.currentDurability = plate.getCurrentDurability();
        this.durationTicks = durationTicks;
        this.playerUUID = playerUUID;
    }

    public ClientboundPhantomPlatePacket(FriendlyByteBuf buf) {
        this.tierName = buf.m_130277_();
        this.materialName = buf.m_130277_();
        this.currentDurability = buf.readFloat();
        this.durationTicks = buf.readInt();
        this.playerUUID = buf.m_130259_();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130070_(this.tierName);
        buf.m_130070_(this.materialName);
        buf.writeFloat(this.currentDurability);
        buf.writeInt(this.durationTicks);
        buf.m_130077_(this.playerUUID);
    }

    public String getTierName() {
        return this.tierName;
    }

    public String getMaterialName() {
        return this.materialName;
    }

    public float getCurrentDurability() {
        return this.currentDurability;
    }

    public int getDurationTicks() {
        return this.durationTicks;
    }

    public UUID getPlayerUUID() {
        return this.playerUUID;
    }

    public static void handle(ClientboundPhantomPlatePacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ClientPacketHandler.handlePhantomPlate(packet)));
        ctx.get().setPacketHandled(true);
    }
}

