/*
 * Decompiled with CFR 0.152.
 */
package com.raiiiden.warborn.common.item;

import com.raiiiden.warborn.client.event.ClientKeyEvents;
import com.raiiiden.warborn.client.renderer.armor.WarbornGenericArmorRenderer;
import com.raiiiden.warborn.common.object.capability.ChestplateBundleCapabilityProvider;
import com.raiiiden.warborn.common.object.capability.ChestplateBundleHandler;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.BundleTooltip;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.renderer.GeoArmorRenderer;
import software.bernie.geckolib.util.GeckoLibUtil;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class WBArmorItem
extends ArmorItem
implements GeoItem,
ICurioItem {
    public static final String TAG_GOGGLE = "goggle";
    public static final String TAG_NVG = "nvg";
    public static final String TAG_SIMPLE_NVG = "simple_nvg";
    public static final String TAG_THERMAL = "thermal";
    public static final String TAG_DIGITAL = "digital";
    public static final TagKey<Item> PLATE_COMPATIBLE = ItemTags.create((ResourceLocation)new ResourceLocation("warborn", "plate_compatible"));
    private static final int MAX_STACK_SIZE = 100;
    private static final int MAX_SLOTS = 4;
    private static final int BAR_COLOR = Mth.m_14159_((float)0.4f, (float)0.4f, (float)1.0f);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final String armorType;

    public WBArmorItem(ArmorMaterial armorMaterial, ArmorItem.Type type, Item.Properties properties, String armorType) {
        super(armorMaterial, type, properties.m_41499_(armorMaterial.m_266425_(type)));
        this.armorType = armorType;
    }

    public static boolean isChestplateItem(ItemStack stack) {
        ResourceLocation id = BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_());
        return id.m_135815_().toLowerCase().contains("chestplate");
    }

    public static int getTotalStoredItems(ItemStack chestplate) {
        return chestplate.getCapability(ForgeCapabilities.ITEM_HANDLER).map(handler -> {
            int total = 0;
            for (int i = 0; i < handler.getSlots(); ++i) {
                total += handler.getStackInSlot(i).m_41613_();
            }
            return total;
        }).orElse(0);
    }

    public static boolean isValidInsert(ItemStack stack) {
        return stack.m_41720_().m_142095_() && !WBArmorItem.isArmor(stack);
    }

    public static Optional<ItemStack> removeItem(ItemStack chestplate) {
        if (!WBArmorItem.isChestplateItem(chestplate)) {
            return Optional.empty();
        }
        return chestplate.getCapability(ForgeCapabilities.ITEM_HANDLER).map(handler -> {
            for (int i = handler.getSlots() - 1; i >= 0; --i) {
                ItemStack inSlot = handler.getStackInSlot(i);
                if (inSlot.m_41619_()) continue;
                ItemStack removed = handler.extractItem(i, inSlot.m_41613_(), false);
                if (handler instanceof ChestplateBundleHandler) {
                    ChestplateBundleHandler cbh = (ChestplateBundleHandler)((Object)handler);
                    cbh.saveToItem(chestplate);
                }
                return removed;
            }
            return ItemStack.f_41583_;
        }).filter(stack -> !stack.m_41619_());
    }

    private static Stream<ItemStack> getContents(ItemStack stack) {
        return stack.getCapability(ForgeCapabilities.ITEM_HANDLER).map(handler -> IntStream.range(0, handler.getSlots()).mapToObj(arg_0 -> ((IItemHandler)handler).getStackInSlot(arg_0)).filter(s -> !s.m_41619_())).orElse(Stream.empty());
    }

    public static boolean isArmor(ItemStack stack) {
        return stack.m_41720_() instanceof ArmorItem;
    }

    public static boolean hasVisionCapability(ItemStack stack) {
        if (stack.m_41619_() || !(stack.m_41720_() instanceof ArmorItem)) {
            return false;
        }
        if (((ArmorItem)stack.m_41720_()).m_266204_() != ArmorItem.Type.HELMET) {
            return false;
        }
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128441_(TAG_GOGGLE)) {
            return true;
        }
        ResourceLocation goggleTagId = new ResourceLocation("fracturepoint", "has_goggle");
        ResourceLocation nvgTagId = new ResourceLocation("fracturepoint", "has_nvg");
        ResourceLocation simpleNvgTagId = new ResourceLocation("fracturepoint", "has_simple_nvg");
        ResourceLocation thermalTagId = new ResourceLocation("fracturepoint", "has_thermal");
        ResourceLocation digitalTagId = new ResourceLocation("fracturepoint", "has_digital");
        return stack.m_204117_(TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)goggleTagId)) || stack.m_204117_(TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)nvgTagId)) || stack.m_204117_(TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)simpleNvgTagId)) || stack.m_204117_(TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)thermalTagId)) || stack.m_204117_(TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)digitalTagId));
    }

    public static boolean hasVisionMode(ItemStack stack, String visionTag) {
        if (!WBArmorItem.hasVisionCapability(stack)) {
            return false;
        }
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128441_(visionTag)) {
            return true;
        }
        if (stack.m_41619_() || !(stack.m_41720_() instanceof ArmorItem)) {
            return false;
        }
        ResourceLocation tagId = new ResourceLocation("fracturepoint", "has_" + visionTag);
        return stack.m_204117_(TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)tagId));
    }

    public static void addVisionCapability(ItemStack stack, String visionTag) {
        if (stack.m_41619_() || !(stack.m_41720_() instanceof ArmorItem)) {
            return;
        }
        if (((ArmorItem)stack.m_41720_()).m_266204_() != ArmorItem.Type.HELMET) {
            return;
        }
        CompoundTag tag = stack.m_41784_();
        tag.m_128379_(TAG_GOGGLE, true);
        tag.m_128379_(visionTag, true);
    }

    public static boolean isPlateCompatible(ItemStack stack) {
        if (stack.m_41619_() || !(stack.m_41720_() instanceof ArmorItem)) {
            return false;
        }
        if (((ArmorItem)stack.m_41720_()).m_266204_() != ArmorItem.Type.CHESTPLATE) {
            return false;
        }
        return stack.m_204117_(PLATE_COMPATIBLE);
    }

    private static boolean isAnimatedHelmet(WBArmorItem item) {
        Set<String> animatedHelmets = Set.of("insurgency_commander", "beta7_nvg", "beta7_nvg_ash", "beta7_nvg_slate", "nato_sqad_leader", "nato_sqad_leader_woodland", "nato_ukr", "nato_ukr_woodland", "killa", "tagilla");
        return animatedHelmets.contains(item.getArmorType());
    }

    public boolean m_142095_() {
        return true;
    }

    public boolean m_142207_(ItemStack chestplate, Slot slot, ClickAction action, Player player) {
        if (!(chestplate.m_41720_() instanceof WBArmorItem) || !WBArmorItem.isChestplateItem(chestplate)) {
            return false;
        }
        if (action != ClickAction.SECONDARY) {
            return false;
        }
        ItemStack slotStack = slot.m_7993_();
        if (slotStack.m_41619_()) {
            Optional<ItemStack> extracted;
            if (player.m_6144_() && (extracted = WBArmorItem.removeItem(chestplate)).isPresent()) {
                ItemStack result = extracted.get();
                slot.m_5852_(result);
                this.playRemoveOneSound((Entity)player);
                return true;
            }
        } else {
            if (!WBArmorItem.isValidInsert(slotStack)) {
                return false;
            }
            chestplate.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(handler -> {
                ItemStack remaining = slotStack.m_41777_();
                for (int i = 0; i < handler.getSlots() && !remaining.m_41619_(); ++i) {
                    ItemStack leftover = handler.insertItem(i, remaining.m_41777_(), false);
                    int inserted = remaining.m_41613_() - leftover.m_41613_();
                    remaining.m_41774_(inserted);
                    if (inserted <= 0) continue;
                    this.playInsertSound((Entity)player);
                    if (!(handler instanceof ChestplateBundleHandler)) continue;
                    ChestplateBundleHandler cbh = (ChestplateBundleHandler)((Object)handler);
                    cbh.saveToItem(chestplate);
                }
                slot.m_5852_(remaining.m_41619_() ? ItemStack.f_41583_ : remaining);
            });
            return true;
        }
        return false;
    }

    public boolean m_142305_(ItemStack chestplate, ItemStack itemBeingMoved, Slot slot, ClickAction action, Player player, SlotAccess access) {
        if (!(chestplate.m_41720_() instanceof WBArmorItem) || !WBArmorItem.isChestplateItem(chestplate)) {
            return false;
        }
        if (action != ClickAction.SECONDARY || !slot.m_150651_(player)) {
            return false;
        }
        if (itemBeingMoved.m_41619_()) {
            WBArmorItem.removeItem(chestplate).ifPresent(removed -> {
                access.m_142104_(removed);
                this.playRemoveOneSound((Entity)player);
            });
            return true;
        }
        if (!WBArmorItem.isValidInsert(itemBeingMoved)) {
            return false;
        }
        chestplate.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(handler -> {
            ItemStack remaining = itemBeingMoved.m_41777_();
            for (int i = 0; i < handler.getSlots() && !remaining.m_41619_(); ++i) {
                ItemStack leftover = handler.insertItem(i, remaining.m_41777_(), false);
                int inserted = remaining.m_41613_() - leftover.m_41613_();
                remaining.m_41774_(inserted);
                if (inserted <= 0) continue;
                this.playInsertSound((Entity)player);
                if (!(handler instanceof ChestplateBundleHandler)) continue;
                ChestplateBundleHandler cbh = (ChestplateBundleHandler)((Object)handler);
                cbh.saveToItem(chestplate);
            }
            access.m_142104_(remaining.m_41619_() ? ItemStack.f_41583_ : remaining);
        });
        return true;
    }

    public Optional<TooltipComponent> m_142422_(ItemStack stack) {
        if (!WBArmorItem.isChestplateItem(stack)) {
            return Optional.empty();
        }
        List<ItemStack> contents = WBArmorItem.getContents(stack).limit(4L).toList();
        NonNullList result = NonNullList.m_122779_();
        result.addAll(contents);
        int totalWeight = contents.stream().mapToInt(ItemStack::m_41613_).sum();
        return Optional.of(new BundleTooltip(result, totalWeight));
    }

    public boolean m_142522_(ItemStack stack) {
        if (WBArmorItem.isChestplateItem(stack)) {
            return WBArmorItem.getContents(stack).findAny().isPresent();
        }
        return super.m_142522_(stack);
    }

    public int m_142158_(ItemStack stack) {
        if (WBArmorItem.isChestplateItem(stack)) {
            int total = WBArmorItem.getContents(stack).mapToInt(ItemStack::m_41613_).sum();
            int max = 400;
            return Math.min(13, 1 + (int)(12.0 * ((double)total / (double)max)));
        }
        return super.m_142158_(stack);
    }

    public int m_142159_(ItemStack stack) {
        if (WBArmorItem.isChestplateItem(stack)) {
            return BAR_COLOR;
        }
        return super.m_142159_(stack);
    }

    private void playRemoveOneSound(Entity entity) {
        entity.m_5496_(SoundEvents.f_184216_, 0.8f, 0.8f + entity.m_9236_().m_213780_().m_188501_() * 0.4f);
    }

    private void playInsertSound(Entity entity) {
        entity.m_5496_(SoundEvents.f_184215_, 0.8f, 0.8f + entity.m_9236_().m_213780_().m_188501_() * 0.4f);
    }

    public String getArmorType() {
        return this.armorType;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        EquipmentSlot slot = this.m_40402_();
        ItemStack equipped = player.m_6844_(slot);
        if (equipped.m_41619_()) {
            player.m_8061_(slot, stack.m_41620_(1));
            return InteractionResultHolder.m_19090_((Object)player.m_21120_(hand));
        }
        return super.m_7203_(level, player, hand);
    }

    private void playDropContentsSound(Entity entity) {
        entity.m_5496_(SoundEvents.f_184214_, 0.8f, 0.8f + entity.m_9236_().m_213780_().m_188501_() * 0.4f);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private GeoArmorRenderer<?> renderer;

            @NotNull
            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity entity, ItemStack stack, EquipmentSlot slot, HumanoidModel<?> original) {
                if (this.renderer == null) {
                    this.renderer = new WarbornGenericArmorRenderer(WBArmorItem.this);
                }
                this.renderer.prepForRender((Entity)entity, stack, slot, original);
                return this.renderer;
            }
        });
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "helmet_toggle", 0, state -> {
            LivingEntity entity;
            ItemStack stack = (ItemStack)state.getData(DataTickets.ITEMSTACK);
            Entity rawEntity = (Entity)state.getData(DataTickets.ENTITY);
            if (!(rawEntity instanceof LivingEntity) || (entity = (LivingEntity)rawEntity) instanceof ArmorStand) {
                return PlayState.STOP;
            }
            if (stack == null || !stack.m_41782_() || !stack.m_204117_(ClientKeyEvents.HAS_TOGGLE_TAG)) {
                return PlayState.STOP;
            }
            boolean open = stack.m_41784_().m_128471_("helmet_top_open");
            String animationName = open ? "helmet_open" : "helmet_closed";
            state.setAnimation(RawAnimation.begin().then(animationName, Animation.LoopType.HOLD_ON_LAST_FRAME));
            return PlayState.CONTINUE;
        })});
    }

    public void setTopOpen(ItemStack stack, boolean open) {
        stack.m_41784_().m_128379_("helmet_top_open", open);
    }

    public boolean isTopOpen(ItemStack stack) {
        return stack.m_41784_().m_128471_("helmet_top_open");
    }

    public void curioTick(String identifier, int index, LivingEntity livingEntity, ItemStack stack) {
        if (!this.getArmorType().contains("shoulderpads")) {
            return;
        }
        AttributeInstance armorAttr = livingEntity.m_21204_().m_22146_(Attributes.f_22284_);
        if (armorAttr == null) {
            return;
        }
        UUID modifierId = UUID.nameUUIDFromBytes(("fracturepoint:shoulderpads_" + livingEntity.m_20148_() + index).getBytes());
        if (armorAttr.m_22111_(modifierId) == null) {
            int defense = this.m_40401_().m_7366_(this.m_266204_());
            armorAttr.m_22118_(new AttributeModifier(modifierId, "fracturepoint:shoulderpads", (double)defense, AttributeModifier.Operation.ADDITION));
        }
    }

    public void onUnequip(String identifier, int index, LivingEntity livingEntity, ItemStack stack) {
        if (!this.getArmorType().contains("shoulderpads")) {
            return;
        }
        AttributeInstance armorAttr = livingEntity.m_21204_().m_22146_(Attributes.f_22284_);
        if (armorAttr == null) {
            return;
        }
        UUID modifierId = UUID.nameUUIDFromBytes(("fracturepoint:shoulderpads_" + livingEntity.m_20148_() + index).getBytes());
        if (armorAttr.m_22111_(modifierId) != null) {
            armorAttr.m_22120_(modifierId);
        }
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        if (WBArmorItem.isChestplateItem(stack)) {
            return new ChestplateBundleCapabilityProvider(stack);
        }
        return super.initCapabilities(stack, nbt);
    }
}

