/*
 * Decompiled with CFR 0.152.
 */
package com.raiiiden.warborn.common.item;

import com.raiiiden.warborn.client.renderer.item.WarbornPlateRenderer;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class SyringeItem
extends Item
implements GeoItem {
    public static final RawAnimation USE_ANIMATION = RawAnimation.begin().thenPlay("animation.use");
    public static final RawAnimation IDLE_ANIMATION = RawAnimation.begin().thenLoop("animation.idle");
    private static final String CONTROLLER = "controller";
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public SyringeItem(Item.Properties props) {
        super(props.m_41487_(1));
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (player.m_20069_()) {
            player.m_5661_((Component)Component.m_237115_((String)"message.fracturepoint.syringe_fail").m_130940_(ChatFormatting.RED), true);
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        if (!level.f_46443_) {
            player.m_5634_(8.0f);
            stack.m_41774_(1);
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                this.triggerAnim((Entity)player, GeoItem.getOrAssignId((ItemStack)stack, (ServerLevel)serverLevel), CONTROLLER, "use");
            }
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    public void initializeClient(Consumer<IClientItemExtensions> cons) {
        cons.accept(new IClientItemExtensions(){
            private WarbornPlateRenderer renderer;

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                if (this.renderer == null) {
                    this.renderer = new WarbornPlateRenderer();
                }
                return this.renderer;
            }
        });
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar reg) {
        reg.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, CONTROLLER, 0, state -> {
            ItemDisplayContext context = (ItemDisplayContext)state.getData(DataTickets.ITEM_RENDER_PERSPECTIVE);
            if (context == ItemDisplayContext.GUI || context == ItemDisplayContext.GROUND || context == ItemDisplayContext.FIXED) {
                return PlayState.STOP;
            }
            if (state.isCurrentAnimation(USE_ANIMATION)) {
                return PlayState.CONTINUE;
            }
            state.setAnimation(IDLE_ANIMATION);
            return PlayState.CONTINUE;
        }).triggerableAnim("use", USE_ANIMATION)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public boolean isPerspectiveAware() {
        return true;
    }
}

