/*
 * Decompiled with CFR 0.152.
 */
package com.raiiiden.warborn.common.item;

import com.raiiiden.warborn.client.renderer.armor.WarbornBackpackRenderer;
import com.raiiiden.warborn.common.object.BackpackMenu;
import com.raiiiden.warborn.common.object.capability.BackpackCapabilityProvider;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.renderer.GeoArmorRenderer;
import software.bernie.geckolib.util.GeckoLibUtil;
import top.theillusivec4.curios.api.CuriosApi;

public class BackpackItem
extends ArmorItem
implements GeoItem {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final String armorType;

    public BackpackItem(ArmorMaterial material, ArmorItem.Type type, Item.Properties properties, String armorType) {
        super(material, type, properties);
        this.armorType = armorType;
    }

    public static boolean isBackpackItem(ItemStack stack) {
        return stack.m_41720_() instanceof BackpackItem;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (player.m_6144_()) {
            if (!level.f_46443_) {
                this.equipToCurios(player, stack);
            }
            return InteractionResultHolder.m_19092_((Object)stack, (boolean)level.f_46443_);
        }
        if (!level.f_46443_) {
            this.openBackpackScreen(player, stack);
        }
        return InteractionResultHolder.m_19092_((Object)stack, (boolean)level.f_46443_);
    }

    private void openBackpackScreen(Player player, ItemStack stack) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)new SimpleMenuProvider((id, inv, p) -> new BackpackMenu(id, inv, stack), (Component)Component.m_237113_((String)"Backpack")), buf -> buf.m_130055_(stack));
            this.playOpenSound((Entity)player);
        }
    }

    private void equipToCurios(Player player, ItemStack stack) {
        CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(curios -> curios.getCurios().forEach((id, handler) -> {
            if (!id.equals("backpack")) {
                return;
            }
            for (int i = 0; i < handler.getSlots(); ++i) {
                if (!handler.getStacks().getStackInSlot(i).m_41619_()) continue;
                handler.getStacks().setStackInSlot(i, stack.m_41777_());
                stack.m_41774_(1);
                player.m_5661_((Component)Component.m_237113_((String)"Equipped backpack to Curios Backpack slot").m_130940_(ChatFormatting.GRAY), true);
                this.playEquipSound((Entity)player);
                return;
            }
        }));
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new BackpackCapabilityProvider(stack);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> components, TooltipFlag flag) {
        super.m_7373_(stack, level, components, flag);
        components.add((Component)Component.m_237113_((String)"Right Click: Open Backpack").m_130940_(ChatFormatting.GRAY));
        components.add((Component)Component.m_237113_((String)"Shift+Right Click: Equip to Curios").m_130940_(ChatFormatting.GRAY));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, 20, state -> PlayState.CONTINUE)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private GeoArmorRenderer<?> renderer;

            @NotNull
            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity entity, ItemStack stack, EquipmentSlot slot, HumanoidModel<?> original) {
                if (this.renderer == null) {
                    this.renderer = new WarbornBackpackRenderer(BackpackItem.this);
                }
                this.renderer.prepForRender((Entity)entity, stack, slot, original);
                return this.renderer;
            }
        });
    }

    public String getArmorType() {
        return this.armorType;
    }

    private void playOpenSound(Entity entity) {
        entity.m_5496_(SoundEvents.f_11678_, 0.8f, 1.0f);
    }

    private void playEquipSound(Entity entity) {
        entity.m_5496_(SoundEvents.f_11675_, 0.8f, 1.0f);
    }

    private void playInsertSound(Entity entity) {
        entity.m_5496_(SoundEvents.f_184215_, 0.8f, 0.8f + entity.m_9236_().m_213780_().m_188501_() * 0.4f);
    }

    private void playRemoveOneSound(Entity entity) {
        entity.m_5496_(SoundEvents.f_184216_, 0.8f, 0.8f + entity.m_9236_().m_213780_().m_188501_() * 0.4f);
    }
}

