/*
 * Decompiled with CFR 0.152.
 */
package com.raiiiden.warborn.common.item;

import com.raiiiden.warborn.client.renderer.item.WarbornPlateRenderer;
import com.raiiiden.warborn.client.sound.WarbornClientSounds;
import com.raiiiden.warborn.common.init.ModItemRegistry;
import com.raiiiden.warborn.common.init.ModSoundEvents;
import com.raiiiden.warborn.common.object.capability.PlateHolderProvider;
import com.raiiiden.warborn.common.object.plate.MaterialType;
import com.raiiiden.warborn.common.object.plate.Plate;
import com.raiiiden.warborn.common.object.plate.ProtectionTier;
import com.raiiiden.warborn.common.util.PlateTooltip;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ArmorPlateItem
extends Item
implements GeoItem {
    public static final RawAnimation INSERT_ANIMATION = RawAnimation.begin().thenPlay("animation.use");
    public static final RawAnimation IDLE_ANIMATION = RawAnimation.begin().thenLoop("animation.idle");
    public static final RawAnimation REMOVE_ANIMATION = RawAnimation.begin().thenPlay("animation.remove");
    public static final RawAnimation SWAP_ANIMATION = RawAnimation.begin().thenPlay("animation.swap");
    public static final TagKey<Item> PLATE_COMPATIBLE = ItemTags.create((ResourceLocation)new ResourceLocation("fracturepoint", "plate_compatible"));
    private static final Logger LOGGER = LogManager.getLogger((String)"fracturepoint/ArmorPlateItem");
    public static final String CONTROLLER = "controller";
    public static final String PENDING_INSERT_TAG = "warborn_pending_insert";
    public static final String PENDING_REMOVE_TAG = "warborn_pending_remove";
    private static final String MSG_PREFIX = "message.fracturepoint.plate.";
    private static final String KEY_MSG_MISSING_CHEST = "message.fracturepoint.plate.missing_chestplate";
    private static final String KEY_MSG_INCOMPATIBLE_CHEST = "message.fracturepoint.plate.incompatible_chestplate";
    private static final String KEY_MSG_PLATE_BROKEN = "message.fracturepoint.plate.is_broken";
    private static final String KEY_MSG_FRONT_INSTALLED = "message.fracturepoint.plate.front_installed";
    private static final String KEY_MSG_BACK_INSTALLED = "message.fracturepoint.plate.back_installed";
    private static final String KEY_MSG_SLOTS_FULL = "message.fracturepoint.plate.slots_full";
    private static final Map<UUID, ArmorPlateSound> activeSounds = new HashMap<UUID, ArmorPlateSound>();
    private final ProtectionTier tier;
    private final MaterialType material;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public ArmorPlateItem(ProtectionTier tier, MaterialType material, Item.Properties props) {
        super(props.m_41503_(material.getBaseDurability()));
        this.tier = tier;
        this.material = material;
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    public static boolean isPlateCompatible(ItemStack chest) {
        return !chest.m_41619_() && chest.m_204117_(PLATE_COMPATIBLE);
    }

    public static ItemStack createPlateWithHitsRemaining(ProtectionTier t, MaterialType m, int currentDur) {
        ItemStack stack = new ItemStack((ItemLike)ModItemRegistry.getPlateItem(t, m));
        int damage = Math.max(0, m.getBaseDurability() - currentDur);
        stack.m_41721_(damage);
        return stack;
    }

    public int getMaxStackSize(@NotNull ItemStack stack) {
        return 2;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        int currentDur;
        ItemStack chest = player.m_6844_(EquipmentSlot.CHEST);
        ItemStack held = player.m_21120_(hand);
        CompoundTag tag = held.m_41784_();
        if (tag.m_128471_(PENDING_INSERT_TAG)) {
            return InteractionResultHolder.m_19098_((Object)held);
        }
        if (tag.m_128471_(PENDING_REMOVE_TAG)) {
            player.m_5661_((Component)Component.m_237113_((String)"Please wait for removal to complete").m_130940_(ChatFormatting.YELLOW), true);
            return InteractionResultHolder.m_19100_((Object)held);
        }
        if (!level.f_46443_ && ArmorPlateItem.hasAnyPendingOperations(player)) {
            player.m_5661_((Component)Component.m_237113_((String)"Please wait for current operation to complete").m_130940_(ChatFormatting.YELLOW), true);
            return InteractionResultHolder.m_19100_((Object)held);
        }
        if (chest.m_41619_()) {
            player.m_5661_((Component)Component.m_237115_((String)KEY_MSG_MISSING_CHEST).m_130940_(ChatFormatting.RED), true);
            return InteractionResultHolder.m_19100_((Object)held);
        }
        if (!ArmorPlateItem.isPlateCompatible(chest)) {
            player.m_5661_((Component)Component.m_237115_((String)KEY_MSG_INCOMPATIBLE_CHEST).m_130940_(ChatFormatting.RED), true);
            return InteractionResultHolder.m_19100_((Object)held);
        }
        AtomicBoolean canInsert = new AtomicBoolean(false);
        chest.getCapability(PlateHolderProvider.CAP).ifPresent(cap -> {
            if (!cap.hasFrontPlate() || !cap.hasBackPlate()) {
                canInsert.set(true);
            }
        });
        if (!canInsert.get()) {
            player.m_5661_((Component)Component.m_237115_((String)KEY_MSG_SLOTS_FULL).m_130940_(ChatFormatting.RED), true);
            return InteractionResultHolder.m_19100_((Object)held);
        }
        int maxDur = this.material.getBaseDurability();
        int n = currentDur = maxDur > 0 ? maxDur - held.m_41773_() : 0;
        if (currentDur <= 0) {
            player.m_5661_((Component)Component.m_237115_((String)KEY_MSG_PLATE_BROKEN).m_130940_(ChatFormatting.RED), true);
            return InteractionResultHolder.m_19100_((Object)held);
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            player.getPersistentData().m_128379_("warborn_processing_insert", true);
            tag.m_128379_(PENDING_INSERT_TAG, true);
            tag.m_128405_("warborn_insert_delay", 66);
            tag.m_128350_("InsertDurability", (float)currentDur);
            tag.m_128359_("InsertTier", this.tier.name());
            tag.m_128359_("InsertMaterial", this.material.getInternalName());
            this.triggerAnim((Entity)player, GeoItem.getOrAssignId((ItemStack)held, (ServerLevel)serverLevel), CONTROLLER, "use");
        }
        if (level.f_46443_) {
            WarbornClientSounds.playArmorInsertSound(player, this);
        }
        return level.f_46443_ ? InteractionResultHolder.m_19098_((Object)held) : InteractionResultHolder.m_19096_((Object)held);
    }

    public void startRemoveAnimation(Player player, ItemStack held, boolean removeFront, ServerLevel serverLevel) {
        CompoundTag tag = held.m_41784_();
        tag.m_128379_(PENDING_REMOVE_TAG, true);
        tag.m_128405_("warborn_remove_delay", 55);
        tag.m_128379_("warborn_remove_front", removeFront);
        this.triggerAnim((Entity)player, GeoItem.getOrAssignId((ItemStack)held, (ServerLevel)serverLevel), CONTROLLER, "remove");
        if (player.m_9236_().f_46443_) {
            WarbornClientSounds.playArmorRemoveSound(player, this);
        }
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slot, boolean selected) {
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (level.f_46443_) {
            return;
        }
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return;
        }
        if (tag.m_128471_(PENDING_INSERT_TAG)) {
            float durability;
            MaterialType material;
            ProtectionTier tier;
            if (!selected) {
                this.cancelPendingInsert(tag);
                player.getPersistentData().m_128473_("warborn_processing_insert");
                return;
            }
            int delay = tag.m_128451_("warborn_insert_delay") - 1;
            tag.m_128405_("warborn_insert_delay", delay);
            if (delay > 0) {
                return;
            }
            tag.m_128473_(PENDING_INSERT_TAG);
            tag.m_128473_("warborn_insert_delay");
            try {
                tier = ProtectionTier.valueOf(tag.m_128461_("InsertTier"));
                material = MaterialType.valueOf(tag.m_128461_("InsertMaterial"));
                durability = tag.m_128457_("InsertDurability");
            }
            catch (Exception e) {
                LOGGER.warn("Failed to parse plate insert data: {}", (Object)tag);
                this.cancelPendingInsert(tag);
                player.getPersistentData().m_128473_("warborn_processing_insert");
                return;
            }
            tag.m_128473_("InsertTier");
            tag.m_128473_("InsertMaterial");
            tag.m_128473_("InsertDurability");
            ItemStack chest = player.m_6844_(EquipmentSlot.CHEST);
            if (chest.m_41619_() || !ArmorPlateItem.isPlateCompatible(chest)) {
                player.getPersistentData().m_128473_("warborn_processing_insert");
                return;
            }
            Plate plate = new Plate(tier, material);
            plate.setCurrentDurability(durability);
            chest.getCapability(PlateHolderProvider.CAP).ifPresent(cap -> {
                boolean inserted = false;
                if (!cap.hasFrontPlate()) {
                    cap.insertFrontPlate(plate);
                    player.m_5661_((Component)Component.m_237115_((String)KEY_MSG_FRONT_INSTALLED).m_130940_(ChatFormatting.GREEN), true);
                    inserted = true;
                } else if (!cap.hasBackPlate()) {
                    cap.insertBackPlate(plate);
                    player.m_5661_((Component)Component.m_237115_((String)KEY_MSG_BACK_INSTALLED).m_130940_(ChatFormatting.GREEN), true);
                    inserted = true;
                }
                if (inserted && !player.m_7500_()) {
                    stack.m_41774_(1);
                }
            });
            player.getPersistentData().m_128473_("warborn_processing_insert");
            return;
        }
        if (tag.m_128471_(PENDING_REMOVE_TAG)) {
            int delay = tag.m_128451_("warborn_remove_delay") - 1;
            tag.m_128405_("warborn_remove_delay", delay);
            if (delay > 0) {
                return;
            }
            tag.m_128473_(PENDING_REMOVE_TAG);
            tag.m_128473_("warborn_remove_delay");
            boolean removeFront = tag.m_128471_("warborn_remove_front");
            tag.m_128473_("warborn_remove_front");
            ItemStack chest = player.m_6844_(EquipmentSlot.CHEST);
            if (chest.m_41619_() || !ArmorPlateItem.isPlateCompatible(chest)) {
                player.getPersistentData().m_128473_("warborn_processing_removal");
                return;
            }
            chest.getCapability(PlateHolderProvider.CAP).ifPresent(cap -> {
                Plate plate;
                if (removeFront && cap.hasFrontPlate()) {
                    Plate plate2 = cap.getFrontPlate();
                    if (plate2 != null) {
                        ItemStack plateStack = ArmorPlateItem.createPlateWithHitsRemaining(plate2.getTier(), plate2.getMaterial(), (int)plate2.getCurrentDurability());
                        player.m_36356_(plateStack);
                        cap.removeFrontPlate();
                        player.m_5661_((Component)Component.m_237113_((String)"Front plate removed").m_130940_(ChatFormatting.GREEN), true);
                    }
                } else if (!removeFront && cap.hasBackPlate() && (plate = cap.getBackPlate()) != null) {
                    ItemStack plateStack = ArmorPlateItem.createPlateWithHitsRemaining(plate.getTier(), plate.getMaterial(), (int)plate.getCurrentDurability());
                    player.m_36356_(plateStack);
                    cap.removeBackPlate();
                    player.m_5661_((Component)Component.m_237113_((String)"Back plate removed").m_130940_(ChatFormatting.GREEN), true);
                }
            });
            player.getPersistentData().m_128473_("warborn_processing_removal");
            return;
        }
        if (tag.m_128441_("inserting")) {
            tag.m_128473_("inserting");
        }
        if (tag.m_128441_("GeckoLibID")) {
            tag.m_128473_("GeckoLibID");
        }
        this.cancelPendingInsert(tag);
    }

    private void cancelPendingInsert(CompoundTag tag) {
        tag.m_128473_(PENDING_INSERT_TAG);
        tag.m_128473_("warborn_insert_delay");
        tag.m_128473_("InsertDurability");
        tag.m_128473_("InsertTier");
        tag.m_128473_("InsertMaterial");
    }

    public void initializeClient(Consumer<IClientItemExtensions> cons) {
        cons.accept(new IClientItemExtensions(){
            private WarbornPlateRenderer renderer;

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                if (this.renderer == null) {
                    this.renderer = new WarbornPlateRenderer();
                }
                return this.renderer;
            }
        });
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar reg) {
        reg.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, CONTROLLER, 0, state -> {
            ItemDisplayContext context = (ItemDisplayContext)state.getData(DataTickets.ITEM_RENDER_PERSPECTIVE);
            if (context == ItemDisplayContext.GUI || context == ItemDisplayContext.GROUND || context == ItemDisplayContext.FIXED) {
                return PlayState.STOP;
            }
            if (state.isCurrentAnimation(INSERT_ANIMATION) || state.isCurrentAnimation(REMOVE_ANIMATION) || state.isCurrentAnimation(SWAP_ANIMATION)) {
                return PlayState.CONTINUE;
            }
            state.setAnimation(IDLE_ANIMATION);
            return PlayState.CONTINUE;
        }).triggerableAnim("use", INSERT_ANIMATION).triggerableAnim("remove", REMOVE_ANIMATION).triggerableAnim("swap", SWAP_ANIMATION)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public boolean isPerspectiveAware() {
        return true;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        CompoundTag tag = oldStack.m_41783_();
        if (tag != null && tag.m_128471_(PENDING_INSERT_TAG)) {
            this.cancelPendingInsert(tag);
        }
        return slotChanged || oldStack.m_41720_() != newStack.m_41720_();
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, List<Component> tip, TooltipFlag flag) {
        PlateTooltip.addPlate(tip, this.tier, this.material, stack);
        super.m_7373_(stack, level, tip, flag);
    }

    public ProtectionTier getTier() {
        return this.tier;
    }

    public MaterialType getMaterial() {
        return this.material;
    }

    public static boolean hasAnyPendingOperations(Player player) {
        CompoundTag tag;
        if (player.getPersistentData().m_128471_("warborn_processing_removal") || player.getPersistentData().m_128471_("warborn_processing_insert")) {
            return true;
        }
        for (ItemStack stack : player.m_150109_().f_35974_) {
            CompoundTag tag2;
            if (!(stack.m_41720_() instanceof ArmorPlateItem) || !stack.m_41782_() || !(tag2 = stack.m_41783_()).m_128471_(PENDING_INSERT_TAG) && !tag2.m_128471_(PENDING_REMOVE_TAG)) continue;
            return true;
        }
        ItemStack offhand = player.m_21206_();
        return offhand.m_41720_() instanceof ArmorPlateItem && offhand.m_41782_() && ((tag = offhand.m_41783_()).m_128471_(PENDING_INSERT_TAG) || tag.m_128471_(PENDING_REMOVE_TAG));
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class ArmorPlateSound
    extends AbstractTickableSoundInstance {
        private final Player player;
        private final Item trackedItem;

        public ArmorPlateSound(Player player, Item trackedItem) {
            super((SoundEvent)ModSoundEvents.WARBORN_PLATE_INSERT.get(), SoundSource.PLAYERS, SoundInstance.m_235150_());
            this.player = player;
            this.trackedItem = trackedItem;
            this.f_119578_ = false;
            this.f_119573_ = 1.0f;
            this.f_119574_ = 1.0f;
            this.f_119575_ = player.m_20185_();
            this.f_119576_ = player.m_20186_();
            this.f_119577_ = player.m_20189_();
        }

        public void m_7788_() {
            if (!this.player.m_6084_() || !this.isHoldingPlate(this.player)) {
                this.m_119609_();
                activeSounds.remove(this.player.m_20148_());
            } else {
                this.f_119575_ = this.player.m_20185_();
                this.f_119576_ = this.player.m_20186_();
                this.f_119577_ = this.player.m_20189_();
            }
        }

        private boolean isHoldingPlate(Player player) {
            return player.m_21205_().m_150930_(this.trackedItem) || player.m_21206_().m_150930_(this.trackedItem);
        }

        public boolean m_7784_() {
            return false;
        }
    }
}

