/*
 * Decompiled with CFR 0.152.
 */
package com.raiiiden.warborn.common.event;

import com.raiiiden.warborn.common.object.capability.PlateHolderProvider;
import com.raiiiden.warborn.common.object.plate.Plate;
import java.util.UUID;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="fracturepoint")
public class PlateSpeedHandler {
    private static final UUID PLATE_SPEED_MODIFIER_UUID = UUID.fromString("d10a0ceb-f815-4b8c-8b41-b7c3b8612891");
    private static final String PLATE_SPEED_MODIFIER_NAME = "Armor Plate Speed Modifier";

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        Player player = event.player;
        if (player.m_5833_()) {
            PlateSpeedHandler.removeSpeedModifier(player);
            return;
        }
        ItemStack chestplate = player.m_6844_(EquipmentSlot.CHEST);
        if (chestplate.m_41619_()) {
            PlateSpeedHandler.removeSpeedModifier(player);
            return;
        }
        chestplate.getCapability(PlateHolderProvider.CAP).ifPresent(cap -> {
            Plate backPlate;
            Plate frontPlate;
            float totalSpeedMod = 0.0f;
            if (cap.hasFrontPlate() && (frontPlate = cap.getFrontPlate()) != null && !frontPlate.isBroken()) {
                totalSpeedMod += frontPlate.getSpeedModifier();
            }
            if (cap.hasBackPlate() && (backPlate = cap.getBackPlate()) != null && !backPlate.isBroken()) {
                totalSpeedMod += backPlate.getSpeedModifier();
            }
            if (Math.abs(totalSpeedMod) > 0.001f) {
                PlateSpeedHandler.applySpeedModifier(player, totalSpeedMod);
            } else {
                PlateSpeedHandler.removeSpeedModifier(player);
            }
        });
    }

    private static void applySpeedModifier(Player player, float speedModifier) {
        PlateSpeedHandler.removeSpeedModifier(player);
        AttributeModifier modifier = new AttributeModifier(PLATE_SPEED_MODIFIER_UUID, PLATE_SPEED_MODIFIER_NAME, (double)speedModifier, AttributeModifier.Operation.MULTIPLY_TOTAL);
        player.m_21051_(Attributes.f_22279_).m_22118_(modifier);
    }

    private static void removeSpeedModifier(Player player) {
        if (player.m_21051_(Attributes.f_22279_).m_22111_(PLATE_SPEED_MODIFIER_UUID) != null) {
            player.m_21051_(Attributes.f_22279_).m_22120_(PLATE_SPEED_MODIFIER_UUID);
        }
    }
}

