/*
 * Decompiled with CFR 0.152.
 */
package com.raiiiden.warborn.common.event;

import com.raiiiden.warborn.common.item.ArmorPlateItem;
import com.raiiiden.warborn.common.object.capability.PlateHolderProvider;
import com.raiiiden.warborn.common.object.plate.Plate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="fracturepoint", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class PhantomPlateServerHandler {
    private static final Logger LOGGER = LogManager.getLogger();

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = event.player;
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        CompoundTag playerData = serverPlayer.getPersistentData();
        if (!playerData.m_128471_("warborn_processing_removal")) {
            return;
        }
        if (!playerData.m_128441_("warborn_temp_plate")) {
            playerData.m_128473_("warborn_processing_removal");
            return;
        }
        CompoundTag plateNBT = playerData.m_128469_("warborn_temp_plate");
        ItemStack tempPlate = ItemStack.m_41712_((CompoundTag)plateNBT);
        if (tempPlate.m_41619_() || !(tempPlate.m_41720_() instanceof ArmorPlateItem)) {
            PhantomPlateServerHandler.cleanupPhantomRemoval((Player)serverPlayer);
            return;
        }
        CompoundTag tag = tempPlate.m_41783_();
        if (tag == null || !tag.m_128471_("warborn_pending_remove")) {
            PhantomPlateServerHandler.cleanupPhantomRemoval((Player)serverPlayer);
            return;
        }
        int delay = tag.m_128451_("warborn_remove_delay") - 1;
        tag.m_128405_("warborn_remove_delay", delay);
        if (delay > 0) {
            playerData.m_128365_("warborn_temp_plate", (Tag)tempPlate.m_41739_(new CompoundTag()));
            return;
        }
        boolean removeFront = tag.m_128471_("warborn_remove_front");
        ItemStack chest = serverPlayer.m_6844_(EquipmentSlot.CHEST);
        if (!chest.m_41619_() && ArmorPlateItem.isPlateCompatible(chest)) {
            chest.getCapability(PlateHolderProvider.CAP).ifPresent(cap -> {
                Plate plate;
                if (removeFront && cap.hasFrontPlate()) {
                    Plate plate2 = cap.getFrontPlate();
                    if (plate2 != null) {
                        ItemStack plateStack = ArmorPlateItem.createPlateWithHitsRemaining(plate2.getTier(), plate2.getMaterial(), (int)plate2.getCurrentDurability());
                        serverPlayer.m_36356_(plateStack);
                        cap.removeFrontPlate();
                    }
                } else if (!removeFront && cap.hasBackPlate() && (plate = cap.getBackPlate()) != null) {
                    ItemStack plateStack = ArmorPlateItem.createPlateWithHitsRemaining(plate.getTier(), plate.getMaterial(), (int)plate.getCurrentDurability());
                    serverPlayer.m_36356_(plateStack);
                    cap.removeBackPlate();
                }
            });
        }
        PhantomPlateServerHandler.cleanupPhantomRemoval((Player)serverPlayer);
    }

    private static void cleanupPhantomRemoval(Player player) {
        CompoundTag playerData = player.getPersistentData();
        playerData.m_128473_("warborn_temp_plate");
        playerData.m_128473_("warborn_processing_removal");
    }
}

