/*
 * Decompiled with CFR 0.152.
 */
package com.raiiiden.warborn.common.event;

import com.raiiiden.warborn.common.object.capability.PlateHolderProvider;
import com.raiiiden.warborn.common.object.plate.Plate;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber
public class DamageHandler {
    private static final Logger LOGGER = LogManager.getLogger();

    @SubscribeEvent
    public static void onPlayerHurt(LivingHurtEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        ItemStack chest = player.m_6844_(EquipmentSlot.CHEST);
        if (chest.m_41619_()) {
            return;
        }
        if (event.getSource().m_7639_() == null) {
            return;
        }
        chest.getCapability(PlateHolderProvider.CAP).ifPresent(cap -> {
            boolean hasPlate;
            float originalDamage = event.getAmount();
            Vec3 sourcePos = event.getSource().m_7639_().m_20182_();
            Vec3 playerPos = player.m_20182_();
            Vec3 attackVec = sourcePos.m_82546_(playerPos).m_82541_();
            Vec3 lookVec = player.m_20154_().m_82541_();
            double dot = lookVec.m_82526_(attackVec);
            boolean isFrontHit = dot > 0.0;
            Plate plateHit = isFrontHit ? cap.getFrontPlate() : cap.getBackPlate();
            boolean bl = hasPlate = isFrontHit ? cap.hasFrontPlate() : cap.hasBackPlate();
            if (hasPlate && plateHit != null) {
                float damageReduction = plateHit.calculateDamageReduction(originalDamage);
                float reducedDamage = originalDamage * (1.0f - damageReduction);
                if (isFrontHit) {
                    cap.damageFrontPlate(originalDamage);
                    LOGGER.info("Front plate absorbed {}% of {} damage. Remaining durability: {}/{}", (Object)Math.round(damageReduction * 100.0f), (Object)Float.valueOf(originalDamage), (Object)Float.valueOf(plateHit.getCurrentDurability()), (Object)Float.valueOf(plateHit.getMaxDurability()));
                } else {
                    cap.damageBackPlate(originalDamage);
                    LOGGER.info("Back plate absorbed {}% of {} damage. Remaining durability: {}/{}", (Object)Math.round(damageReduction * 100.0f), (Object)Float.valueOf(originalDamage), (Object)Float.valueOf(plateHit.getCurrentDurability()), (Object)Float.valueOf(plateHit.getMaxDurability()));
                }
                event.setAmount(reducedDamage);
                float speedModifier = plateHit.getSpeedModifier();
                if (speedModifier != 0.0f) {
                    LOGGER.info("Player speed affected by {}% due to plate material.", (Object)Float.valueOf(speedModifier * 100.0f));
                }
            } else {
                LOGGER.info("No plate in direction of hit or plate broken. Full damage taken.");
            }
        });
    }
}

