/*
 * Decompiled with CFR 0.152.
 */
package com.raiiiden.warborn.client.shader;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.systems.RenderSystem;
import com.raiiiden.warborn.common.item.WBArmorItem;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.client.renderer.PostPass;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ShaderRegistry {
    private static final ShaderRegistry INSTANCE = new ShaderRegistry();
    private static String cachedPassesFieldName = null;
    private final Map<String, ShaderEntry> shaders = new LinkedHashMap<String, ShaderEntry>();
    private String currentActiveShader = null;
    private boolean isProcessing = false;
    private long lastExternalShutdownAttempt = 0L;
    private int externalShutdownCount = 0;
    private static final long SHUTDOWN_ATTEMPT_WINDOW_MS = 5000L;
    private boolean suppressWarnings = false;

    private ShaderRegistry() {
    }

    public static ShaderRegistry getInstance() {
        return INSTANCE;
    }

    public static List<PostPass> getPasses(PostChain chain) {
        try {
            if (cachedPassesFieldName != null) {
                try {
                    Field f = PostChain.class.getDeclaredField(cachedPassesFieldName);
                    f.setAccessible(true);
                    Object v = f.get(chain);
                    if (v instanceof List) {
                        return (List)v;
                    }
                    cachedPassesFieldName = null;
                }
                catch (Throwable ignored) {
                    cachedPassesFieldName = null;
                }
            }
            String[] names = new String[]{"passes", "f_110007_", "m_110007_"};
            for (String name : names) {
                try {
                    Field f = PostChain.class.getDeclaredField(name);
                    f.setAccessible(true);
                    Object v = f.get(chain);
                    if (!(v instanceof List)) continue;
                    cachedPassesFieldName = name;
                    return (List)v;
                }
                catch (Throwable f) {
                    // empty catch block
                }
            }
            for (Field f : PostChain.class.getDeclaredFields()) {
                try {
                    List list;
                    if (!List.class.isAssignableFrom(f.getType())) continue;
                    f.setAccessible(true);
                    Object v = f.get(chain);
                    if (!(v instanceof List) || (list = (List)v).isEmpty() || !(list.get(0) instanceof PostPass)) continue;
                    cachedPassesFieldName = f.getName();
                    return (List)v;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return List.of();
    }

    public Set<String> getRegisteredShaderIds() {
        return new HashSet<String>(this.shaders.keySet());
    }

    public boolean isShaderActive(String id) {
        ShaderEntry entry = this.shaders.get(id);
        if (entry == null) {
            return false;
        }
        return entry.activationCondition.test(Minecraft.m_91087_());
    }

    public boolean isShaderForceEnabled(String id) {
        ShaderEntry entry = this.shaders.get(id);
        if (entry == null) {
            return false;
        }
        return Boolean.TRUE.equals(entry.forceEnabled);
    }

    public boolean setShaderEnabled(String id, boolean enabled) {
        ShaderEntry entry = this.shaders.get(id);
        if (entry == null) {
            return false;
        }
        entry.forceEnabled = enabled;
        if (!enabled && id.equals(this.currentActiveShader)) {
            try {
                Minecraft.m_91087_().f_91063_.m_109086_();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.currentActiveShader = null;
        }
        return true;
    }

    public int removeShadersByPrefix(String prefix) {
        ArrayList<String> toRemove = new ArrayList<String>();
        for (String id : this.shaders.keySet()) {
            if (!id.startsWith(prefix)) continue;
            toRemove.add(id);
        }
        for (String id : toRemove) {
            this.unregisterShader(id);
        }
        return toRemove.size();
    }

    public boolean registerShader(String id, ResourceLocation shaderLocation, Predicate<Minecraft> activationCondition, Consumer<PostChain> configurer) {
        if (this.shaders.containsKey(id)) {
            return false;
        }
        this.shaders.put(id, new ShaderEntry(shaderLocation, activationCondition, configurer));
        return true;
    }

    public void unregisterShader(String id) {
        ShaderEntry entry = this.shaders.remove(id);
        if (entry != null && id.equals(this.currentActiveShader)) {
            try {
                Minecraft.m_91087_().f_91063_.m_109086_();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.currentActiveShader = null;
        }
    }

    public void onExternalShutdownAttempt() {
        long now = System.currentTimeMillis();
        if (now - this.lastExternalShutdownAttempt > 5000L) {
            this.externalShutdownCount = 0;
            this.suppressWarnings = false;
        }
        this.lastExternalShutdownAttempt = now;
        ++this.externalShutdownCount;
        if (this.externalShutdownCount >= 1 && !this.suppressWarnings) {
            StackTraceElement[] stack;
            System.err.println("[Warborn] Shader shutdown attempts detected " + this.externalShutdownCount + " times. Suppressing further warnings for this session.");
            this.suppressWarnings = true;
            for (StackTraceElement element : stack = Thread.currentThread().getStackTrace()) {
                String className = element.getClassName();
                if (className.startsWith("com.raiiiden.warborn") || className.startsWith("net.minecraft") || className.startsWith("java.") || className.contains("EventBus") || className.contains("mixin")) continue;
                System.err.println("[Warborn] Likely culprit: " + className + "." + element.getMethodName());
                break;
            }
        } else if (!this.suppressWarnings) {
            System.err.println("[Warborn] External shader shutdown blocked (" + this.externalShutdownCount + " attempts)");
        }
    }

    public void processShaders() {
        if (this.isProcessing) {
            return;
        }
        this.isProcessing = true;
        try {
            this.processShaders_Internal();
        }
        finally {
            this.isProcessing = false;
        }
    }

    private void processShaders_Internal() {
        WBArmorItem wbArmorItem;
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null || mc.f_91074_ == null) {
            return;
        }
        GameRenderer renderer = mc.f_91063_;
        RenderTarget mainTarget = mc.m_91385_();
        ItemStack helmet = mc.f_91074_.m_6844_(EquipmentSlot.HEAD);
        Item item = helmet.m_41720_();
        if (item instanceof WBArmorItem && (wbArmorItem = (WBArmorItem)item).isTopOpen(helmet)) {
            if (this.currentActiveShader != null) {
                try {
                    renderer.m_109086_();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.currentActiveShader = null;
            }
            return;
        }
        String shaderToActivate = null;
        ShaderEntry entryToActivate = null;
        for (Map.Entry<String, ShaderEntry> e : this.shaders.entrySet()) {
            ShaderEntry se = e.getValue();
            boolean forceEnabled = Boolean.TRUE.equals(se.forceEnabled);
            boolean forceDisabled = Boolean.FALSE.equals(se.forceEnabled);
            boolean cond = se.activationCondition.test(mc);
            boolean shouldBeActive = cond && !forceDisabled || forceEnabled;
            if (!shouldBeActive) continue;
            shaderToActivate = e.getKey();
            entryToActivate = se;
            break;
        }
        if (shaderToActivate == null) {
            if (this.currentActiveShader != null) {
                try {
                    renderer.m_109086_();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.currentActiveShader = null;
            }
            return;
        }
        if (shaderToActivate.equals(this.currentActiveShader)) {
            return;
        }
        try {
            renderer.m_109086_();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            renderer.m_109128_(entryToActivate.shaderLocation);
        }
        catch (Throwable ignored) {
            this.currentActiveShader = null;
            return;
        }
        PostChain effect = renderer.m_109149_();
        if (effect != null) {
            try {
                entryToActivate.configurer.accept(effect);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        try {
            mainTarget.m_83947_(true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            RenderSystem.bindTextureForSetup((int)mainTarget.m_83975_());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            RenderSystem.bindTextureForSetup((int)mainTarget.m_83980_());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.currentActiveShader = shaderToActivate;
    }

    private static class ShaderEntry {
        final ResourceLocation shaderLocation;
        final Predicate<Minecraft> activationCondition;
        final Consumer<PostChain> configurer;
        Boolean forceEnabled = null;

        ShaderEntry(ResourceLocation shaderLocation, Predicate<Minecraft> activationCondition, Consumer<PostChain> configurer) {
            this.shaderLocation = shaderLocation;
            this.activationCondition = activationCondition;
            this.configurer = configurer;
        }
    }
}

