/*
 * Decompiled with CFR 0.152.
 */
package com.raiiiden.warborn.client.shader;

import com.raiiiden.warborn.client.shader.ShaderRegistry;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.client.renderer.PostPass;
import net.minecraft.resources.ResourceLocation;

public class ShaderPresets {
    public static final ResourceLocation NIGHT_VISION = new ResourceLocation("fracturepoint", "shaders/post/night-vision.json");
    public static final ResourceLocation SIMPLE_NIGHT_VISION = new ResourceLocation("fracturepoint", "shaders/post/simple-night-vision.json");
    public static final ResourceLocation DIGITAL_GREEN_VISION = new ResourceLocation("fracturepoint", "shaders/post/digital-green-vision.json");
    public static final ResourceLocation DIGITAL_WHITE_VISION = new ResourceLocation("fracturepoint", "shaders/post/digital-white-vision.json");
    public static final ResourceLocation THERMAL_VISION = new ResourceLocation("fracturepoint", "shaders/post/thermal-vision.json");

    public static Consumer<PostChain> nightVision(float brightness, float redTint, float greenTint, float blueTint) {
        return shader -> {
            List<PostPass> passes = ShaderRegistry.getPasses(shader);
            for (PostPass pass : passes) {
                if (pass.m_110074_().m_108952_("NightVisionEnabled") == null) continue;
                pass.m_110074_().m_108960_("NightVisionEnabled").m_5985_(1.0f);
                pass.m_110074_().m_108960_("Brightness").m_5985_(brightness);
                pass.m_110074_().m_108960_("RedValue").m_5985_(redTint);
                pass.m_110074_().m_108960_("GreenValue").m_5985_(greenTint);
                pass.m_110074_().m_108960_("BlueValue").m_5985_(blueTint);
            }
        };
    }

    public static Consumer<PostChain> greenDigitalVision(float intensity) {
        return shader -> {
            List<PostPass> passes = ShaderRegistry.getPasses(shader);
            for (PostPass pass : passes) {
                pass.m_110074_().m_108960_("Brightness").m_5985_(intensity);
                pass.m_110074_().m_108960_("NoiseAmplification").m_5985_(intensity);
            }
        };
    }

    public static Consumer<PostChain> whitePhosphorVision(float intensity) {
        return shader -> {
            List<PostPass> passes = ShaderRegistry.getPasses(shader);
            for (PostPass pass : passes) {
                pass.m_110074_().m_108960_("Brightness").m_5985_(intensity);
                pass.m_110074_().m_108960_("NoiseAmplification").m_5985_(intensity);
            }
        };
    }

    public static Consumer<PostChain> thermalVision(float intensity) {
        return shader -> {
            List<PostPass> passes = ShaderRegistry.getPasses(shader);
            for (PostPass pass : passes) {
                pass.m_110074_().m_108960_("Brightness").m_5985_(intensity);
                pass.m_110074_().m_108960_("NoiseAmplification").m_5985_(intensity);
            }
        };
    }

    public static Consumer<PostChain> greenNightVision(float intensity) {
        return ShaderPresets.nightVision(0.6f * intensity, 0.2f, 1.0f, 0.2f);
    }

    public static Consumer<PostChain> blueNightVision(float intensity) {
        return ShaderPresets.nightVision(0.5f * intensity, 0.2f, 0.5f, 1.0f);
    }

    public static Consumer<PostChain> whiteNightVision(float intensity) {
        return ShaderPresets.nightVision(0.8f * intensity, 0.9f, 0.9f, 0.9f);
    }
}

