/*
 * Decompiled with CFR 0.152.
 */
package com.raiiiden.warborn.client.shader;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.raiiiden.warborn.client.shader.ShaderPresets;
import com.raiiiden.warborn.client.shader.ShaderRegistry;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class ShaderCommand {
    private static final String TEMP_SHADER_PREFIX = "temp_";
    private static final SuggestionProvider<CommandSourceStack> SHADER_ID_SUGGESTIONS = (context, builder) -> {
        Set<String> shaderIds = ShaderRegistry.getInstance().getRegisteredShaderIds();
        return SharedSuggestionProvider.m_82970_(shaderIds, (SuggestionsBuilder)builder);
    };

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder shaderCommand = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"shader").requires(source -> source.m_6761_(2))).then(Commands.m_82127_((String)"list").executes(ShaderCommand::listShaders))).then(Commands.m_82127_((String)"enable").then(Commands.m_82129_((String)"shaderId", (ArgumentType)StringArgumentType.word()).suggests(SHADER_ID_SUGGESTIONS).executes(ShaderCommand::enableShader)))).then(Commands.m_82127_((String)"disable").then(Commands.m_82129_((String)"shaderId", (ArgumentType)StringArgumentType.word()).suggests(SHADER_ID_SUGGESTIONS).executes(ShaderCommand::disableShader)))).then(Commands.m_82127_((String)"test").then(Commands.m_82129_((String)"shaderLocation", (ArgumentType)ResourceLocationArgument.m_106984_()).executes(ShaderCommand::testShader)))).then(Commands.m_82127_((String)"cleartemp").executes(ShaderCommand::clearTempShaders));
        dispatcher.register(shaderCommand);
    }

    private static int listShaders(CommandContext<CommandSourceStack> ctx) {
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        ShaderRegistry registry = ShaderRegistry.getInstance();
        Set<String> shaderIds = registry.getRegisteredShaderIds();
        if (shaderIds.isEmpty()) {
            source.m_288197_(() -> Component.m_237113_((String)"No shaders are currently registered").m_130940_(ChatFormatting.YELLOW), false);
        } else {
            source.m_288197_(() -> Component.m_237113_((String)"Registered shaders:").m_130940_(ChatFormatting.GREEN), false);
            for (String id : shaderIds) {
                boolean isActive = registry.isShaderActive(id);
                ChatFormatting color = isActive ? ChatFormatting.GREEN : ChatFormatting.GRAY;
                source.m_288197_(() -> Component.m_237113_((String)("- " + id + (isActive ? " (ACTIVE)" : ""))).m_130940_(color), false);
            }
        }
        return shaderIds.size();
    }

    private static int enableShader(CommandContext<CommandSourceStack> ctx) {
        String shaderId = StringArgumentType.getString(ctx, (String)"shaderId");
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        if (ShaderRegistry.getInstance().setShaderEnabled(shaderId, true)) {
            source.m_288197_(() -> Component.m_237113_((String)("Enabled shader: " + shaderId)).m_130940_(ChatFormatting.GREEN), true);
            return 1;
        }
        source.m_81352_((Component)Component.m_237113_((String)("Shader not found: " + shaderId)));
        return 0;
    }

    private static int disableShader(CommandContext<CommandSourceStack> ctx) {
        String shaderId = StringArgumentType.getString(ctx, (String)"shaderId");
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        if (ShaderRegistry.getInstance().setShaderEnabled(shaderId, false)) {
            source.m_288197_(() -> Component.m_237113_((String)("Disabled shader: " + shaderId)).m_130940_(ChatFormatting.YELLOW), true);
            return 1;
        }
        source.m_81352_((Component)Component.m_237113_((String)("Shader not found: " + shaderId)));
        return 0;
    }

    private static int testNightVision(CommandContext<CommandSourceStack> ctx, String preset) {
        float intensity = FloatArgumentType.getFloat(ctx, (String)"intensity");
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        String tempId = "temp_nvg_" + preset + "_" + System.currentTimeMillis();
        switch (preset) {
            case "green": {
                ShaderCommand.registerTempShader(tempId, ShaderPresets.NIGHT_VISION, ShaderPresets.greenNightVision(intensity));
                break;
            }
            case "blue": {
                ShaderCommand.registerTempShader(tempId, ShaderPresets.NIGHT_VISION, ShaderPresets.blueNightVision(intensity));
                break;
            }
            case "white": {
                ShaderCommand.registerTempShader(tempId, ShaderPresets.NIGHT_VISION, ShaderPresets.whiteNightVision(intensity));
                break;
            }
            default: {
                source.m_81352_((Component)Component.m_237113_((String)("Unknown preset: " + preset)));
                return 0;
            }
        }
        source.m_288197_(() -> Component.m_237113_((String)("Testing " + preset + " night vision (intensity: " + intensity + ")")).m_130940_(ChatFormatting.GREEN), true);
        source.m_288197_(() -> Component.m_237113_((String)("Use '/shader toggle " + tempId + "' to turn it off")).m_130940_(ChatFormatting.YELLOW), false);
        return 1;
    }

    private static int testShader(CommandContext<CommandSourceStack> ctx) {
        ResourceLocation shaderLocation = ResourceLocationArgument.m_107011_(ctx, (String)"shaderLocation");
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        String tempId = "temp_custom_" + System.currentTimeMillis();
        ShaderCommand.registerTempShader(tempId, shaderLocation, postChain -> {});
        source.m_288197_(() -> Component.m_237113_((String)("Testing shader: " + shaderLocation)).m_130940_(ChatFormatting.GREEN), true);
        source.m_288197_(() -> Component.m_237113_((String)("Use '/shader toggle " + tempId + "' to turn it off")).m_130940_(ChatFormatting.YELLOW), false);
        return 1;
    }

    private static int clearTempShaders(CommandContext<CommandSourceStack> ctx) {
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        int count = ShaderRegistry.getInstance().removeShadersByPrefix(TEMP_SHADER_PREFIX);
        if (count > 0) {
            source.m_288197_(() -> Component.m_237113_((String)("Removed " + count + " temporary shader" + (count == 1 ? "" : "s"))).m_130940_(ChatFormatting.GREEN), true);
        } else {
            source.m_288197_(() -> Component.m_237113_((String)"No temporary shaders to remove").m_130940_(ChatFormatting.YELLOW), false);
        }
        return count;
    }

    private static void registerTempShader(String id, ResourceLocation location, Consumer<PostChain> configurer) {
        ShaderRegistry.getInstance().unregisterShader(id);
        ShaderRegistry.getInstance().registerShader(id, location, mc -> true, configurer);
    }
}

