/*
 * Decompiled with CFR 0.152.
 */
package com.raiiiden.warborn.client.screen;

import com.raiiiden.warborn.common.item.ArmorPlateItem;
import com.raiiiden.warborn.common.network.ModNetworking;
import com.raiiiden.warborn.common.object.capability.PlateHolderCapability;
import com.raiiiden.warborn.common.object.capability.PlateHolderProvider;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;

public class RemovePlateScreen
extends Screen {
    public RemovePlateScreen() {
        super((Component)Component.m_237113_((String)"Remove Plates"));
    }

    protected void m_7856_() {
        int centerX = this.f_96543_ / 2;
        int centerY = this.f_96544_ / 2;
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Remove Front Plate"), btn -> this.tryRemove(true)).m_252987_(centerX - 75, centerY - 20, 150, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Remove Back Plate"), btn -> this.tryRemove(false)).m_252987_(centerX - 75, centerY + 10, 150, 20).m_253136_());
    }

    private void tryRemove(boolean front) {
        PlateHolderCapability cap;
        LocalPlayer player = this.f_96541_.f_91074_;
        if (player == null) {
            return;
        }
        ItemStack chest = player.m_6844_(EquipmentSlot.CHEST);
        if (chest.m_41619_() || !ArmorPlateItem.isPlateCompatible(chest)) {
            player.m_5661_((Component)Component.m_237113_((String)"You must wear a compatible chestplate."), true);
            return;
        }
        boolean canRemove = false;
        LazyOptional capOpt = chest.getCapability(PlateHolderProvider.CAP);
        if (capOpt.isPresent() && (cap = (PlateHolderCapability)capOpt.orElse(null)) != null) {
            if (front && cap.hasFrontPlate()) {
                canRemove = true;
            } else if (!front && cap.hasBackPlate()) {
                canRemove = true;
            }
        }
        if (!canRemove) {
            String plateType = front ? "front" : "back";
            player.m_5661_((Component)Component.m_237113_((String)("No " + plateType + " plate to remove.")), true);
            return;
        }
        ModNetworking.sendRemovePlatePacket(front);
        this.m_7379_();
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        graphics.m_280137_(this.f_96547_, "Plate Removal", this.f_96543_ / 2, this.f_96544_ / 2 - 40, 0xFFFFFF);
    }

    public boolean m_7043_() {
        return false;
    }
}

