/*
 * Decompiled with CFR 0.152.
 */
package com.raiiiden.warborn.client.renderer.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.raiiiden.warborn.client.renderer.armor.WarbornBackpackRenderer;
import com.raiiiden.warborn.common.item.BackpackItem;
import java.util.List;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;

public class WarbornBackpackLayer<T extends LivingEntity, M extends HumanoidModel<T>>
extends RenderLayer<T, M> {
    public WarbornBackpackLayer(RenderLayerParent<T, M> renderer) {
        super(renderer);
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, T entity, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float netHeadYaw, float headPitch) {
        List backpacks = CuriosApi.getCuriosHelper().findCurios(entity, stack -> stack.m_41720_() instanceof BackpackItem);
        for (SlotResult slotResult : backpacks) {
            if (slotResult.slotContext().identifier().equals("backpack") && slotResult.slotContext().visible()) {
                this.renderBackpack(poseStack, bufferSource, packedLight, entity, (BackpackItem)slotResult.stack().m_41720_(), slotResult.stack());
            }
            if (!slotResult.slotContext().identifier().equals("back") || !slotResult.slotContext().visible()) continue;
            this.renderBackpack(poseStack, bufferSource, packedLight, entity, (BackpackItem)slotResult.stack().m_41720_(), slotResult.stack());
        }
    }

    private void renderBackpack(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, T entity, BackpackItem backpackItem, ItemStack stack) {
        WarbornBackpackRenderer renderer = new WarbornBackpackRenderer(backpackItem);
        ((HumanoidModel)this.m_117386_()).m_102872_((HumanoidModel)renderer);
        renderer.prepForRender((Entity)entity, stack, EquipmentSlot.CHEST, (HumanoidModel)renderer);
        renderer.m_7695_(poseStack, bufferSource.m_6299_(RenderType.m_110431_((ResourceLocation)renderer.getTextureLocation((GeoAnimatable)backpackItem))), packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
    }
}

