/*
 * Decompiled with CFR 0.152.
 */
package com.raiiiden.warborn.client.renderer.item;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.raiiiden.warborn.client.model.WarbornPlateModel;
import com.raiiiden.warborn.common.item.ArmorPlateItem;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoItemRenderer;
import software.bernie.geckolib.util.RenderUtils;

public class WarbornPlateRenderer
extends GeoItemRenderer<ArmorPlateItem> {
    private static final float SCALE_RECIPROCAL = 0.0625f;
    private static final String LEFT_BONE = "left_hand";
    private static final String RIGHT_BONE = "right_hand";
    private static final String NBT_INSERT = "inserting";
    private final Set<String> hiddenBones = new HashSet<String>();
    public ItemDisplayContext transformType;
    protected boolean renderArms = false;
    protected MultiBufferSource currentBuffer;
    protected RenderType renderType;
    protected ArmorPlateItem animatable;

    public WarbornPlateRenderer() {
        super((GeoModel)new WarbornPlateModel());
    }

    public static void renderPartOverBone(ModelPart model, GeoBone bone, PoseStack stack, VertexConsumer buffer, int packedLightIn, int packedOverlayIn, float alpha) {
        WarbornPlateRenderer.renderPartOverBone(model, bone, stack, buffer, packedLightIn, packedOverlayIn, 1.0f, 1.0f, 1.0f, alpha);
    }

    public static void renderPartOverBone(ModelPart model, GeoBone bone, PoseStack stack, VertexConsumer buffer, int packedLightIn, int packedOverlayIn, float r, float g, float b, float a) {
        WarbornPlateRenderer.setupModelFromBone(model, bone);
        model.m_104306_(stack, buffer, packedLightIn, packedOverlayIn, r, g, b, a);
    }

    public static void setupModelFromBone(ModelPart model, GeoBone bone) {
        model.m_104227_(bone.getPivotX(), bone.getPivotY(), bone.getPivotZ());
        model.f_104203_ = 0.0f;
        model.f_104204_ = 0.0f;
        model.f_104205_ = 0.0f;
    }

    public RenderType getRenderType(ArmorPlateItem anim, ResourceLocation tex, MultiBufferSource buf, float pt) {
        return RenderType.m_110473_((ResourceLocation)this.getTextureLocation(anim));
    }

    public void m_108829_(ItemStack stack, ItemDisplayContext ctx, PoseStack pose, MultiBufferSource buf, int light, int overlay) {
        this.transformType = ctx;
        if (ctx.m_269069_()) {
            this.renderArms = true;
            if (stack.m_41783_() == null || !stack.m_41783_().m_128441_(NBT_INSERT)) {
                stack.m_41784_().m_128379_(NBT_INSERT, true);
            }
        }
        super.m_108829_(stack, ctx, pose, buf, light, overlay);
    }

    public void actuallyRender(PoseStack pose, ArmorPlateItem anim, BakedGeoModel model, RenderType type, MultiBufferSource buf, VertexConsumer vc, boolean isRenderer, float pt, int light, int overlay, float r, float g, float b, float a) {
        this.currentBuffer = buf;
        this.renderType = type;
        this.animatable = anim;
        super.actuallyRender(pose, (Item)anim, model, type, buf, vc, isRenderer, pt, light, overlay, r, g, b, a);
        this.renderArms = true;
    }

    public void renderRecursively(PoseStack stack, ArmorPlateItem anim, GeoBone bone, RenderType type, MultiBufferSource buf, VertexConsumer vc, boolean isReRender, float pt, int light, int overlay, float r, float g, float b, float a) {
        String name = bone.getName();
        boolean isArmProxy = name.equals(LEFT_BONE) || name.equals(RIGHT_BONE);
        bone.setHidden(isArmProxy || this.hiddenBones.contains(name));
        if (this.transformType != null && this.transformType.m_269069_() && isArmProxy && this.renderArms) {
            Minecraft mc = Minecraft.m_91087_();
            LocalPlayer player = mc.f_91074_;
            if (player != null) {
                PlayerRenderer pr = (PlayerRenderer)mc.m_91290_().m_114382_((Entity)player);
                PlayerModel model = (PlayerModel)pr.m_7200_();
                float alpha = player.m_20145_() ? 0.15f : 1.0f;
                stack.m_85836_();
                RenderUtils.translateMatrixToBone((PoseStack)stack, (CoreGeoBone)bone);
                RenderUtils.translateToPivotPoint((PoseStack)stack, (CoreGeoBone)bone);
                RenderUtils.rotateMatrixAroundBone((PoseStack)stack, (CoreGeoBone)bone);
                RenderUtils.scaleMatrixForBone((PoseStack)stack, (CoreGeoBone)bone);
                RenderUtils.translateAwayFromPivotPoint((PoseStack)stack, (CoreGeoBone)bone);
                ResourceLocation skin = player.m_108560_();
                VertexConsumer armVC = this.currentBuffer.m_6299_(RenderType.m_110446_((ResourceLocation)skin));
                VertexConsumer sleeveVC = this.currentBuffer.m_6299_(RenderType.m_110473_((ResourceLocation)skin));
                if (name.equals(LEFT_BONE)) {
                    stack.m_252880_(-0.0625f, 0.125f, 0.0f);
                    WarbornPlateRenderer.renderPartOverBone(model.f_102812_, bone, stack, armVC, light, OverlayTexture.f_118083_, alpha);
                    WarbornPlateRenderer.renderPartOverBone(model.f_103374_, bone, stack, sleeveVC, light, OverlayTexture.f_118083_, alpha);
                } else {
                    stack.m_252880_(0.0625f, 0.125f, 0.0f);
                    WarbornPlateRenderer.renderPartOverBone(model.f_102811_, bone, stack, armVC, light, OverlayTexture.f_118083_, alpha);
                    WarbornPlateRenderer.renderPartOverBone(model.f_103375_, bone, stack, sleeveVC, light, OverlayTexture.f_118083_, alpha);
                }
                this.currentBuffer.m_6299_(this.renderType);
                stack.m_85849_();
            }
        }
        super.renderRecursively(stack, (Item)anim, bone, type, buf, vc, isReRender, pt, light, overlay, r, g, b, a);
    }

    public ResourceLocation getTextureLocation(ArmorPlateItem inst) {
        return super.getTextureLocation((Item)inst);
    }
}

