/*
 * Decompiled with CFR 0.152.
 */
package com.raiiiden.warborn.client.renderer;

import com.raiiiden.warborn.common.init.ModItemRegistry;
import com.raiiiden.warborn.common.object.plate.Plate;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PhantomPlateRenderManager {
    private static PhantomPlateRenderManager INSTANCE;
    private ItemStack phantomStack = ItemStack.f_41583_;
    private int remainingTicks = 0;
    private boolean isActive = false;
    private UUID playerUUID = null;

    private PhantomPlateRenderManager() {
    }

    public static PhantomPlateRenderManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new PhantomPlateRenderManager();
        }
        return INSTANCE;
    }

    public void startPhantomRender(Plate plate, int durationTicks, UUID playerUUID) {
        if (plate == null) {
            return;
        }
        this.phantomStack = ModItemRegistry.getPlateItem(plate.getTier(), plate.getMaterial()).m_7968_();
        CompoundTag tag = this.phantomStack.m_41784_();
        tag.m_128379_("warborn_phantom_render", true);
        tag.m_128379_("warborn_pending_remove", true);
        tag.m_128405_("warborn_remove_delay", 55);
        this.remainingTicks = durationTicks;
        this.isActive = true;
        this.playerUUID = playerUUID;
    }

    public void tick() {
        if (!this.isActive) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null || !player.m_20148_().equals(this.playerUUID)) {
            this.clear();
            return;
        }
        --this.remainingTicks;
        if (this.remainingTicks <= 0) {
            this.clear();
        }
    }

    public boolean shouldRenderPhantom(InteractionHand hand) {
        if (!this.isActive || this.phantomStack.m_41619_()) {
            return false;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return false;
        }
        return hand == InteractionHand.MAIN_HAND;
    }

    @Nullable
    public ItemStack getPhantomStack() {
        return this.isActive ? this.phantomStack : ItemStack.f_41583_;
    }

    public void clear() {
        this.phantomStack = ItemStack.f_41583_;
        this.remainingTicks = 0;
        this.isActive = false;
        this.playerUUID = null;
    }

    public boolean isActive() {
        return this.isActive;
    }
}

