/*
 * Decompiled with CFR 0.152.
 */
package com.raiiiden.warborn.client.network;

import com.raiiiden.warborn.client.renderer.PhantomPlateRenderManager;
import com.raiiiden.warborn.client.sound.WarbornClientSounds;
import com.raiiiden.warborn.common.item.ArmorPlateItem;
import com.raiiiden.warborn.common.network.ClientboundPhantomPlatePacket;
import com.raiiiden.warborn.common.object.plate.MaterialType;
import com.raiiiden.warborn.common.object.plate.Plate;
import com.raiiiden.warborn.common.object.plate.ProtectionTier;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;

public class ClientPacketHandler {
    public static void handlePhantomPlate(ClientboundPhantomPlatePacket packet) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return;
        }
        try {
            Item item;
            ProtectionTier tier = ProtectionTier.valueOf(packet.getTierName());
            MaterialType material = MaterialType.valueOf(packet.getMaterialName());
            Plate plate = new Plate(tier, material);
            plate.setCurrentDurability(packet.getCurrentDurability());
            PhantomPlateRenderManager.getInstance().startPhantomRender(plate, packet.getDurationTicks(), packet.getPlayerUUID());
            ItemStack phantomStack = PhantomPlateRenderManager.getInstance().getPhantomStack();
            if (!phantomStack.m_41619_() && (item = phantomStack.m_41720_()) instanceof ArmorPlateItem) {
                AnimationController controller;
                long geckoId;
                ArmorPlateItem plateItem = (ArmorPlateItem)item;
                CompoundTag tag = phantomStack.m_41784_();
                if (tag.m_128441_("GeckoLibID")) {
                    geckoId = tag.m_128454_("GeckoLibID");
                } else {
                    geckoId = GeoItem.getId((ItemStack)phantomStack);
                    tag.m_128356_("GeckoLibID", geckoId);
                }
                AnimatableManager animatableManager = plateItem.getAnimatableInstanceCache().getManagerForId(geckoId);
                if (animatableManager != null && (controller = (AnimationController)animatableManager.getAnimationControllers().get("controller")) != null) {
                    controller.forceAnimationReset();
                }
                plateItem.triggerAnim((Entity)mc.f_91074_, geckoId, "controller", "remove");
                WarbornClientSounds.playArmorRemoveSound((Player)mc.f_91074_, plateItem);
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            mc.f_91074_.m_5661_((Component)Component.m_237113_((String)"Error: Invalid plate data"), false);
        }
    }
}

