/*
 * Decompiled with CFR 0.152.
 */
package com.raiiiden.warborn.client.gui;

import com.raiiiden.warborn.common.object.capability.PlateHolderCapability;
import com.raiiiden.warborn.common.object.capability.PlateHolderProvider;
import com.raiiiden.warborn.common.object.plate.Plate;
import com.raiiiden.warborn.common.util.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="fracturepoint", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class PlateHudOverlay {
    private static final ResourceLocation PLATE_ICON = new ResourceLocation("fracturepoint", "textures/gui/plate_icon.png");
    private static final Color BAR_BACKGROUND = new Color(26, 26, 42);

    @SubscribeEvent
    public static void onRenderOverlay(RenderGuiOverlayEvent.Post event) {
        if (!event.getOverlay().id().toString().equals("minecraft:armor_level")) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null || player.m_7500_() || player.m_5833_()) {
            return;
        }
        ItemStack chest = player.m_6844_(EquipmentSlot.CHEST);
        if (chest.m_41619_()) {
            return;
        }
        GuiGraphics guiGraphics = event.getGuiGraphics();
        int screenWidth = mc.m_91268_().m_85445_();
        int screenHeight = mc.m_91268_().m_85446_();
        chest.getCapability(PlateHolderProvider.CAP).ifPresent(arg_0 -> PlateHudOverlay.lambda$onRenderOverlay$0((Player)player, screenWidth, screenHeight, guiGraphics, arg_0));
    }

    private static void drawPlateBar(GuiGraphics guiGraphics, int x, int y, float current, float max, Color color) {
        int width = 36;
        int height = 2;
        int filled = (int)(current / max * (float)width);
        guiGraphics.m_280509_(x, y, x + width, y + height, BAR_BACKGROUND.getARGB());
        guiGraphics.m_280509_(x, y, x + filled, y + height, color.getARGB());
    }

    private static /* synthetic */ void lambda$onRenderOverlay$0(Player player, int screenWidth, int screenHeight, GuiGraphics guiGraphics, PlateHolderCapability cap) {
        Plate plate;
        boolean hasOffhand = !player.m_6844_(EquipmentSlot.OFFHAND).m_41619_();
        int iconX = screenWidth / 2 - 110 - (hasOffhand ? 30 : 0);
        int iconY = screenHeight - 20;
        guiGraphics.m_280163_(PLATE_ICON, iconX, iconY, 0.0f, 0.0f, 18, 18, 18, 18);
        int barWidth = 36;
        int spacing = 4;
        int centerX = screenWidth / 2;
        int absorption = player.m_6103_() > 0.0f ? 1 : 0;
        int armor = player.m_21230_() > 0 ? 1 : 0;
        int baseY = screenHeight - 45;
        int offset = 9 * (absorption + armor);
        int barY = baseY - offset;
        int leftBarX = centerX - barWidth - spacing - 50;
        int rightBarX = centerX + spacing - 50;
        if (cap.hasFrontPlate()) {
            plate = cap.getFrontPlate();
            PlateHudOverlay.drawPlateBar(guiGraphics, leftBarX, barY, plate.getCurrentDurability(), plate.getMaxDurability(), plate.getMaterial().getColor());
        }
        if (cap.hasBackPlate()) {
            plate = cap.getBackPlate();
            PlateHudOverlay.drawPlateBar(guiGraphics, rightBarX, barY, plate.getCurrentDurability(), plate.getMaxDurability(), plate.getMaterial().getColor());
        }
    }
}

