/*
 * Decompiled with CFR 0.152.
 */
package com.raiiiden.warborn.client.event;

import com.raiiiden.warborn.client.event.ModKeybindings;
import com.raiiiden.warborn.client.screen.RemovePlateScreen;
import com.raiiiden.warborn.client.shader.ClientVisionState;
import com.raiiiden.warborn.client.shader.ShaderRegistry;
import com.raiiiden.warborn.common.init.ModSoundEvents;
import com.raiiiden.warborn.common.item.BackpackItem;
import com.raiiiden.warborn.common.network.ModNetworking;
import com.raiiiden.warborn.common.network.ServerboundNVGArmAnimationPacket;
import com.raiiiden.warborn.common.util.HelmetVisionHandler;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosApi;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="fracturepoint", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class ClientKeyEvents {
    private static Item lastHelmetItem = null;
    private static String lastVisionType = "";
    public static final TagKey<Item> HAS_TOGGLE_TAG = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation("fracturepoint", "has_toggle"));
    private static final TagKey<Item> BETA_7 = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation("fracturepoint", "is_beta7"));

    @SubscribeEvent
    public static void onKeyInput(InputEvent.Key event) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null || mc.f_91073_ == null) {
            return;
        }
        LocalPlayer player = mc.f_91074_;
        if (ModKeybindings.OPEN_BACKPACK.m_90859_()) {
            ItemStack chest = player.m_6844_(EquipmentSlot.CHEST);
            if (BackpackItem.isBackpackItem(chest)) {
                ModNetworking.openBackpack(chest);
                return;
            }
            CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(inv -> inv.getCurios().forEach((slotId, handler) -> {
                for (int i = 0; i < handler.getStacks().getSlots(); ++i) {
                    ItemStack stack = handler.getStacks().getStackInSlot(i);
                    if (!BackpackItem.isBackpackItem(stack)) continue;
                    ModNetworking.openBackpack(stack);
                    return;
                }
            }));
        }
        if (ModKeybindings.TOGGLE_HELMET_TOP.m_90859_()) {
            ModNetworking.sendToServer(new ServerboundNVGArmAnimationPacket(true));
        }
        if (ModKeybindings.TOGGLE_SPECIAL_VISION.m_90859_()) {
            if (HelmetVisionHandler.toggleVision((Player)player)) {
                ItemStack helmet = player.m_6844_(EquipmentSlot.HEAD);
                String activeVision = HelmetVisionHandler.getActiveVisionType(helmet);
                player.m_5496_((SoundEvent)ModSoundEvents.WARBORN_NVG_TOGGLE.get(), 1.0f, 1.0f);
                if (!activeVision.isEmpty()) {
                    String message;
                    ChatFormatting color = switch (activeVision) {
                        case "nvg" -> {
                            message = "Night Vision Mode";
                            yield ChatFormatting.GREEN;
                        }
                        case "simple_nvg" -> {
                            message = "Simple Night Vision Mode";
                            yield ChatFormatting.GREEN;
                        }
                        case "digital" -> {
                            message = "Digital Vision Mode";
                            yield ChatFormatting.WHITE;
                        }
                        case "thermal" -> {
                            message = "Thermal Vision Mode";
                            yield ChatFormatting.RED;
                        }
                        default -> {
                            message = "Vision Mode";
                            yield ChatFormatting.YELLOW;
                        }
                    };
                    player.m_5661_((Component)Component.m_237113_((String)(message + " Activated")).m_130940_(color), true);
                } else {
                    player.m_5661_((Component)Component.m_237113_((String)"Vision Mode Disabled").m_130940_(ChatFormatting.YELLOW), true);
                }
            } else {
                player.m_5661_((Component)Component.m_237113_((String)"No appropriate helmet equipped").m_130940_(ChatFormatting.RED), true);
            }
        }
        if (ModKeybindings.REMOVE_PLATE_MENU.m_90859_()) {
            Minecraft.m_91087_().m_91152_((Screen)new RemovePlateScreen());
        }
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null || mc.f_91073_ == null) {
            return;
        }
        LocalPlayer player = mc.f_91074_;
        ItemStack helmet = player.m_6844_(EquipmentSlot.HEAD);
        boolean isHelmetValid = HelmetVisionHandler.isAllowedHelmet(helmet);
        if (!isHelmetValid) {
            ClientKeyEvents.disableAllShaders((Player)player);
            lastHelmetItem = null;
            lastVisionType = "";
            return;
        }
        Item currentItem = helmet.m_41720_();
        String currentVision = HelmetVisionHandler.getActiveVisionType(helmet);
        if (lastHelmetItem != null && currentItem != lastHelmetItem && !lastVisionType.isEmpty()) {
            ShaderRegistry.getInstance().setShaderEnabled(HelmetVisionHandler.getShaderIdFromVisionType(lastVisionType), false);
            ClientVisionState.clear(player.m_20148_());
        }
        lastHelmetItem = currentItem;
        lastVisionType = currentVision;
    }

    private static void disableAllShaders(Player player) {
        String[] shaders = new String[]{"nvg", "snvg", "dvg", "dnvg", "tvg"};
        boolean wasActive = false;
        for (String id : shaders) {
            if (!ShaderRegistry.getInstance().isShaderActive(id) && !ShaderRegistry.getInstance().isShaderForceEnabled(id)) continue;
            ShaderRegistry.getInstance().setShaderEnabled(id, false);
            wasActive = true;
        }
        ClientVisionState.clear(player.m_20148_());
        if (wasActive) {
            player.m_5661_((Component)Component.m_237113_((String)"Vision mode disabled - helmet removed").m_130940_(ChatFormatting.YELLOW), true);
        }
    }
}

