/*
 * Decompiled with CFR 0.152.
 */
package com.raiiiden.warborn.client.compat.autohud;

import com.raiiiden.warborn.common.object.capability.PlateHolderProvider;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="fracturepoint", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class WarbornAutoHudCompat {
    private static final Logger LOGGER = LogManager.getLogger();

    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        if (!ModList.get().isLoaded("autohud")) {
            LOGGER.info("AutoHUD not found \u2014 skipping compat.");
            return;
        }
        try {
            Class<?> autoHudClass = Class.forName("mod.crend.autohud.AutoHud");
            Class<?> apiClass = Class.forName("mod.crend.autohud.api.AutoHudApi");
            Object apiInstance = Proxy.newProxyInstance(WarbornAutoHudCompat.class.getClassLoader(), new Class[]{apiClass}, (proxy, method, args) -> {
                switch (method.getName()) {
                    case "modId": {
                        return "warborn";
                    }
                    case "tickState": {
                        LocalPlayer player = (LocalPlayer)args[0];
                        if (player != null) {
                            player.m_6844_(EquipmentSlot.CHEST).getCapability(PlateHolderProvider.CAP).ifPresent(cap -> {
                                if (cap.hasFrontPlate() && cap.getFrontPlate().getCurrentDurability() < cap.getFrontPlate().getMaxDurability() || cap.hasBackPlate() && cap.getBackPlate().getCurrentDurability() < cap.getBackPlate().getMaxDurability()) {
                                    try {
                                        Class<?> components = Class.forName("mod.crend.autohud.component.Components$Health");
                                        components.getMethod("reveal", new Class[0]).invoke(null, new Object[0]);
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                            });
                        }
                        return null;
                    }
                    case "init": {
                        return null;
                    }
                }
                return null;
            });
            Method addApi = autoHudClass.getMethod("addApi", apiClass);
            addApi.invoke(null, apiInstance);
            LOGGER.info("AutoHUD compat initialized successfully.");
        }
        catch (Exception e) {
            LOGGER.error("Failed to initialize AutoHUD compat", (Throwable)e);
        }
    }
}

