/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server.net.clientbound;

import java.util.function.BiConsumer;
import me.paulf.fairylights.server.connection.HangingLightsConnection;
import me.paulf.fairylights.server.jingle.Jingle;
import me.paulf.fairylights.server.net.ClientMessageContext;
import me.paulf.fairylights.server.net.ConnectionMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;

public final class JingleMessage
extends ConnectionMessage {
    private int lightOffset;
    public Jingle jingle;

    public JingleMessage() {
    }

    public JingleMessage(HangingLightsConnection connection, int lightOffset, Jingle jingle) {
        super(connection);
        this.lightOffset = lightOffset;
        this.jingle = jingle;
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        super.encode(buf);
        buf.m_130130_(this.lightOffset);
        this.jingle.write(buf);
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        super.decode(buf);
        this.lightOffset = buf.m_130242_();
        this.jingle = Jingle.read(buf);
    }

    public static class Handler
    implements BiConsumer<JingleMessage, ClientMessageContext> {
        @Override
        public void accept(JingleMessage message, ClientMessageContext context) {
            Jingle jingle = message.jingle;
            if (jingle != null) {
                ConnectionMessage.getConnection(message, c -> c instanceof HangingLightsConnection, (Level)Minecraft.m_91087_().f_91073_).ifPresent(connection -> connection.play(jingle, message.lightOffset));
            }
        }
    }
}

