/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server.feature.light;

import me.paulf.fairylights.server.config.FLConfig;
import me.paulf.fairylights.server.feature.HangingFeature;
import me.paulf.fairylights.server.feature.light.LightBehavior;
import me.paulf.fairylights.server.item.LightVariant;
import me.paulf.fairylights.server.sound.FLSounds;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public final class Light<T extends LightBehavior>
extends HangingFeature {
    private static final int SWAY_RATE = 10;
    private static final int SWAY_PEAK_COUNT = 5;
    private static final int SWAY_CYCLE = 50;
    private final ItemStack item;
    private final LightVariant<T> variant;
    private final T behavior;
    private int sway;
    private boolean swaying;
    private boolean swayDirection;
    private int tick;
    private int lastJingledTick = -1;
    private boolean powered;

    public Light(int index, Vec3 point, float yaw, float pitch, ItemStack item, LightVariant<T> variant, float descent) {
        super(index, point, yaw, pitch, 0.0f, descent);
        this.item = item;
        this.variant = variant;
        this.behavior = variant.createBehavior(item);
    }

    public T getBehavior() {
        return this.behavior;
    }

    public ItemStack getItem() {
        return this.item;
    }

    public LightVariant<T> getVariant() {
        return this.variant;
    }

    public void jingle(Level world, Vec3 origin, int note) {
        this.jingle(world, origin, note, (ParticleOptions)ParticleTypes.f_123758_);
    }

    public void jingle(Level world, Vec3 origin, int note, ParticleOptions particle) {
        this.jingle(world, origin, note, (SoundEvent)FLSounds.JINGLE_BELL.get(), particle);
    }

    public void jingle(Level world, Vec3 origin, int note, SoundEvent sound, ParticleOptions ... particles) {
        if (world.m_5776_()) {
            double x = origin.f_82479_ + this.point.f_82479_;
            double y = origin.f_82480_ + this.point.f_82480_;
            double z = origin.f_82481_ + this.point.f_82481_;
            for (ParticleOptions particle : particles) {
                double vx = world.f_46441_.m_188583_();
                double vy = world.f_46441_.m_188583_();
                double vz = world.f_46441_.m_188583_();
                double t = world.f_46441_.m_188500_() * 0.2 + 0.2;
                double mag = t / Math.sqrt(vx * vx + vy * vy + vz * vz);
                world.m_7106_(particle, x + (vx *= mag), y + (vy *= mag), z + (vz *= mag), particle == ParticleTypes.f_123758_ ? (double)note / 24.0 : 0.0, 0.0, 0.0);
            }
            if (this.lastJingledTick != this.tick) {
                world.m_7785_(x, y, z, sound, SoundSource.BLOCKS, (float)FLConfig.getJingleAmplitude() / 16.0f, (float)Math.pow(2.0, (float)(note - 12) / 12.0f), false);
                this.startSwaying(world.f_46441_.m_188499_());
                this.lastJingledTick = this.tick;
            }
        }
    }

    public void startSwaying(boolean swayDirection) {
        this.swayDirection = swayDirection;
        this.swaying = true;
        this.sway = 0;
    }

    public void stopSwaying() {
        this.sway = 0;
        this.roll = 0.0f;
        this.swaying = false;
    }

    public void power(boolean powered, boolean now) {
        this.behavior.power(powered, now, this);
        this.powered = powered;
    }

    public boolean isPowered() {
        return this.powered;
    }

    public void tick(Level world, Vec3 origin) {
        super.tick(world);
        this.behavior.tick(world, origin, this);
        if (this.swaying) {
            if (this.sway >= 50) {
                this.stopSwaying();
            } else {
                this.roll = (float)(Math.sin((double)((this.swayDirection ? 1 : -1) * 2) * Math.PI / 10.0 * (double)this.sway) * Math.pow(114.59155902616465, (float)(-this.sway) / 50.0f));
                ++this.sway;
            }
        }
        ++this.tick;
    }

    @Override
    public AABB getBounds() {
        return this.getVariant().getBounds();
    }

    @Override
    public boolean parallelsCord() {
        return this.getVariant().parallelsCord();
    }
}

